<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
	
    
    <xsl:template name="main-menu">
		<xsl:if test="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
            <nav role="navigation" aria-label="skin.{$skin}:SKIN_NAV_MAIN_NAVIGATION" i18n:attr="aria-label">
    			<a name="menu"></a>
    			
                <ul>
                    <xsl:apply-templates select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="menu-item-level1"/>
    			
                    <!-- Quick access for mobile -->
                    <li class="access-copy"></li>
                </ul>
            </nav>
		</xsl:if>
	</xsl:template>
    
    <xsl:template match="page" mode="menu-item-level1">
        <li>
            <xsl:choose>
                <xsl:when test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <!-- Main section with submenu -->
                    <button type="button" class="open-submenu" aria-expanded="false" aria-label="{@sitemap:title}">
                        <span><xsl:value-of select="@sitemap:title" /></span>
                        <i aria-hidden="true" class="fas fa-angle-down"></i>
                    </button>
                    
                    <div class="submenu">
                        <button class="close" onclick="closeSubMenuMobile(this)" aria-label="skin.{$skin}:SKIN_NAV_MENU_MOBILE_CLOSE" i18n:attr="aria-label">
                            <i aria-hidden="true" class="fas fa-times"></i>
                        </button>
                        <xsl:call-template name="submenu-main-section-title"/>
                        <ul class="container">
                            <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level2"/>
                        </ul>  
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Main section with no submenu -->
                    <a href="{resolver:resolve('page', @sitemap:id)}">
                        <xsl:if test="@sitemap:in-path = 'true'">
                            <xsl:attribute name="class">active</xsl:attribute>
                            <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_MENU_ACTIVE</xsl:attribute>
                            <xsl:attribute name="i18n:attr">title</xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                            <xsl:call-template name="external-link-attributes">
                                <xsl:with-param name="title" select="@sitemap:title"/>
                            </xsl:call-template>
                        </xsl:if>
                        <xsl:value-of select="@sitemap:title" />
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <!-- Repeat main section in submenu -->
    <xsl:template name="submenu-main-section-title">
        <div class="section-title"> 
            <a class="" href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:value-of select="@sitemap:title" />
            </a>
         </div>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level2">
        <li class="title">
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:apply-templates select="." mode="menu-item-level2-icon"/>
                <span><xsl:value-of select="@sitemap:title" /></span>
            </a>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul>
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="menu-item-level3"/>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level2-icon">
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
             xmlns:xlink="http://www.w3.org/1999/xlink" width="45.312" height="32.78"
             viewBox="0 0 45.312 32.78">
            <defs>
                <filter id="filter" filterUnits="userSpaceOnUse">
                    <feFlood result="flood" flood-color="#fff" />
                    <feComposite result="composite" operator="in" in2="SourceGraphic" />
                    <feBlend result="blend" in2="SourceGraphic" />
                </filter>
            </defs>
            <g id="FLECHE">
                <path id="Rectangle_arrondi_15" data-name="Rectangle arrondi 15"
                    d="M281.062,1213.33a2.307,2.307,0,0,1,3.276,0l12.283,12.28a2.318,2.318,0,1,1-3.276,3.28l-12.283-12.29A2.31,2.31,0,0,1,281.062,1213.33Z"
                    transform="translate(-253.5 -1211.16)" />
                <path id="Rectangle_arrondi_15_copie"
                    data-name="Rectangle arrondi 15 copie"
                    d="M279.505,1238.48l12.283-12.28a2.318,2.318,0,0,1,3.276,3.28l-12.284,12.28A2.318,2.318,0,0,1,279.505,1238.48Z"
                    transform="translate(-253.5 -1211.16)" />
                <circle cx="20.031" cy="16.655" r="4.125" />
                <circle id="Ellipse_2_copie" data-name="Ellipse 2 copie" cx="5.625"
                    cy="16.655" r="4.125" />
            </g>
        </svg>
    </xsl:template>
        
	<xsl:template match="page" mode="menu-item-level3">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                    <xsl:call-template name="external-link-attributes">
                        <xsl:with-param name="title" select="@sitemap:title"/>
                    </xsl:call-template>
                </xsl:if>
                <xsl:apply-templates select="." mode="menu-item-level3-icon"/>
                <span><xsl:value-of select="@sitemap:title" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="menu-item-level3-icon"/>
    
    <xsl:template name="navinterieur">
        <nav role="navigation" aria-label="skin.{$skin}:SKIN_NAV_SECONDARY_NAVIGATION" i18n:attr="aria-label">
            <xsl:call-template name="nav-burger"/>
        
            <div class="navinterieur-menu" role="dialog" aria-modal="true">
                <button type="button" class="close" onclick="closeNavInterieur()" aria-label="skin.{$skin}:SKIN_NAV_SECONDARY_CLOSE" i18n:attr="aria-label"> <img src="{ametys:skinURL('templates/common/img/icon/close.svg')}"/></button>
                
                <ul class="first">
                    <xsl:apply-templates select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="navinterieur"/>
                </ul>
            </div>
        </nav>
    
        <xsl:call-template name="navinterieur-js"/>
    </xsl:template>
    
    <!-- Menu nav intérieur -->
    <xsl:template match="page" mode="navinterieur">
        <xsl:param name="level">2</xsl:param>
        
        <li>
            <xsl:attribute name="class">
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">has-submenu</xsl:if>
            </xsl:attribute>
            
            <div>
                <a href="{resolver:resolve('page', @sitemap:id)}">
                    
                    <xsl:choose>
                        <xsl:when test="@sitemap:current='true'">
                            <xsl:attribute name="class">current</xsl:attribute>
                            <xsl:attribute name="aria-current">page</xsl:attribute>
                        </xsl:when>
                        <xsl:when test="@sitemap:in-path='true'">
                            <xsl:attribute name="aria-current">true</xsl:attribute>
                        </xsl:when>
                    </xsl:choose>
                    
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="title" select="@sitemap:title"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:value-of select="@sitemap:title" />
                </a>
                
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <button type="button" aria-expanded="false" class="chevron">
                       <img src="{ametys:skinURL('templates/common/img/icon/chevron.svg')}" alt="" />
                    </button>
                </xsl:if>
            </div>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul class="level-{$level}">
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="navinterieur">
                        <xsl:with-param name="level" select="$level+1"/>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template name="nav-burger">
        <xsl:if test="not(ametys:renderingContext() = 'back')">
	        <button type="button" aria-expanded="false" class="navinterieur-link" onclick="openNavInterieur()" aria-haspopup="dialog">
	            <i class="fas fa-bars" aria-hidden="true"></i>
	            <span class="navinterieur-link__menu"><i18n:text i18n:key="SKIN_NAV_INTERIEUR_MENU" i18n:catalogue="skin.{$skin}"/></span>
	            <span class="navinterieur-link__descri"><i18n:text i18n:key="SKIN_NAV_INTERIEUR_EXPLORER" i18n:catalogue="skin.{$skin}"/></span>
	        </button>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="navinterieur-js">
        <script type="text/javascript">
             $j(function () {
                const $current = $j('.navinterieur-menu .current');
                const $section = $current.closest('ul');
                    
                if ($section.hasClass('first'))
                {
                    let $parentLI = $current.closest('.has-submenu');
                    $parentLI.addClass('open');
                    $parentLI.children('ul').show();
                    $parentLI.find('>div >.chevron').attr('aria-expanded', true);
                }
                else
                {
                    let $parentLIs = $current.parents('.has-submenu');
                    $parentLIs.addClass('open');
                    $parentLIs.children('ul').show();
                    $parentLIs.find('>div >.chevron').attr('aria-expanded', true);
                }
            });
            
            $j('.navinterieur-menu .has-submenu .chevron').on('click', function (e) {
                e.preventDefault();
    
                var $parent = $j(this).closest('.has-submenu');
                
                if ($parent.hasClass('open')) {
                    // collapse menu
                    $parent.removeClass('open');
                    $parent.find('ul').hide();
                    $parent.find('li.open').removeClass('open');
                    $parent.find('.chevron').attr("aria-expanded", false);
                    $j(this).attr("aria-expanded", false);
                } else {
                    // open menu
                    $parent.parent().find('ul').hide();
                    $parent.parent().find('li').removeClass('open');
    
                    $parent.addClass('open');
                    $parent.children('ul').show();
                    $j(this).attr("aria-expanded", true);
                }
                
                // Visible elements have changed, reload focus trap listener
                AmetysFront.Accessibility.trapFocus($j('.navinterieur-menu.open').get(0), false);
            });
            
            // Close menu on escape
            const closeNavInterieurOnEscape = (event) => {
                if (event.key === "Escape") {
                    var $currentOpenMenu = $j(".navinterieur-menu.open");
                    if ($currentOpenMenu.length)
                    {
                        closeNavInterieur();
                    }
                }
            };
    
            function openNavInterieur() {
                $j('.overlay.navinterieur').addClass('active');
                $j('.navinterieur-menu').addClass('open');
                $j(this).attr("aria-expanded", true);
                
                // Trap focus into menu
                AmetysFront.Accessibility.trapFocus($j('.navinterieur-menu.open').get(0), true);
                
                // Close menu on escape
                $j('.navinterieur-menu').on('keydown', closeNavInterieurOnEscape);
            }
    
            function closeNavInterieur() {
                // Untrap focus
                AmetysFront.Accessibility.untrapFocus($j('.navinterieur-menu.open').get(0));
                
                $j('.overlay.navinterieur').removeClass('active');
                $j('.navinterieur-menu').removeClass('open');
                $j('.navinterieur-link').attr("aria-expanded", false);
                $j('.navinterieur-link').trigger('focus');
                
                // Remove listener
                $j('.navinterieur-menu').off('keydown', closeNavInterieurOnEscape);
            }
        </script>
    </xsl:template>
</xsl:stylesheet>