<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							xmlns:docbook="http://docbook.org/ns/docbook"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
							exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="skin://stylesheets/content/member/member-abstract.xsl"/> 
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>	
	
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id" select="user:getUserPage(@id)"/>
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="content-image"/>
            <div class="arrivant"> 
                <xsl:call-template name="content-firstname"/>
                <xsl:call-template name="content-lastname"/>
                <xsl:call-template name="content-function"/>
            </div>
        </a>
    </xsl:template>
    
    <xsl:template name="content-firstname">
        <xsl:if test="metadata/firstname">
            <span class="firstname"><xsl:value-of select="metadata/firstname"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-lastname">
        <xsl:if test="metadata/lastname">
            <span class="lastname"><xsl:value-of select="metadata/lastname"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-function">
        <xsl:if test="metadata/function">
            <span class="function"><xsl:value-of select="metadata/function"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/user">
                <xsl:call-template name="user-profile-image">
                    <xsl:with-param name="size">72</xsl:with-param>
                    <xsl:with-param name="login" select="metadata/user/@login"/>
                    <xsl:with-param name="population" select="metadata/user/@populationId"/>
                    <xsl:with-param name="lang" select="@language"/>
                    <xsl:with-param name="class">svg agent-svg</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="metadata/illustration/image">
                <img alt="{metadata/illustration/alt-text}" src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 72, 72)}"/>
            </xsl:when>
            <xsl:otherwise>
                <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/avatar-homme.svg')}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
