<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
						      xmlns:exslt="http://exslt.org/common"
						      xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							  xmlns:edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
							  xmlns:cms="http://ametys.org/cms/3.0"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              exclude-result-prefixes="docbook resolver orgUnit">

    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="plugin:workspaces://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/member/member.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">project-member agent view-main</xsl:variable>
    
    <xsl:template name="common-content-head-css">
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_agent.css')}"/>
    </xsl:template>
   
   <xsl:template name="common-content-body-title-content"/>
   
   <xsl:template name="common-content-body-content">
        <xsl:call-template name="profile-header"/>
        
        <xsl:call-template name="profile-content"/>
   </xsl:template>
   
   <xsl:template name="profile-header">
        <div class="container-with-photo-profil">
            <xsl:call-template name="profile-title"/>

            <xsl:call-template name="profile-image"/>
        </div> 
        
        <script type="text/javascript">
            // move header
            $(".container-with-photo-profil").appendTo("article .top .container");
        </script>
   </xsl:template>
   
   <xsl:template name="profile-title">
        <div class="title">
            <h1>
                <xsl:value-of select="metadata/title"/>
                <br/>
                <xsl:call-template name="profile-function"/>
            </h1>
        </div>
   </xsl:template>
   
   
   <xsl:template name="profile-function">
        <xsl:if test="metadata/function">
            <span><xsl:value-of select="metadata/function"/></span>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-image">
        <div class="photo-profil">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <xsl:call-template name="common-content-body-image">
                        <xsl:with-param name="image" select="metadata/illustration/image"/>
                        <xsl:with-param name="alternative" select="metadata/illustration/alt-text"/>
                        <xsl:with-param name="maxWidth" select="'240'"/>
                        <xsl:with-param name="maxHeight" select="'240'"/>
                        <xsl:with-param name="type" select="'cropped'"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="metadata/user">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">140</xsl:with-param>
                        <xsl:with-param name="login" select="metadata/user/@login"/>
                        <xsl:with-param name="population" select="metadata/user/@populationId"/>
                        <xsl:with-param name="lang" select="@language"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="user-image-default-url"/>
                </xsl:otherwise>
            </xsl:choose> 
        </div> 
   </xsl:template>
   
   <xsl:template name="profile-content">
        <xsl:call-template name="profile-blocks"/>
        <xsl:apply-templates select="/view/contentType/fieldset[@name='main']/metadata" mode="display"/>
   </xsl:template>
   
   <xsl:template name="profile-blocks">
        <div class="blocks-agent">
            <xsl:call-template name="profile-block-orgunits"/>
            <xsl:call-template name="profile-block-mail"/>
            <xsl:call-template name="profile-block-contact"/>
        </div>  
   </xsl:template>
   
   <xsl:template name="profile-block-orgunits">
        <xsl:if test="metadata/orgunits or metadata/organisation">
            <div class="block-agent">
                <div class="icon">
                    <xsl:call-template name="location-icon"/>
                </div>
                <div class="description">
                    <span class="title"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_ORGUNIT" i18n:catalogue="skin.{$skin}"/></span>
                    
                    <xsl:choose>
                        <xsl:when test="count(metadata/orgunits) > 0">
                            <xsl:for-each select="metadata/orgunits">
                                <xsl:variable name="page-id"><xsl:value-of select="orgUnit:getOrgUnitPage(@id)"/></xsl:variable>
                                <span class="subtitle">
                                    <xsl:choose>
                                        <xsl:when test="$page-id != ''">
                                            <a href="{resolver:resolve('page', $page-id, false)}"><xsl:value-of select="@title"/></a>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="@title"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </span>
                                <xsl:if test="../organisation">
                                    <span class="text ametys-editable editable--text" data-ametys-metadata="{concat(/view/content/@id, ';organisation')}"><xsl:value-of select="../organisation"/></span>    
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:when test="metadata/organisation">
                            <span class="subtitle ametys-editable editable--text" data-ametys-metadata="{concat(/view/content/@id, ';organisation')}"><xsl:value-of select="metadata/organisation"/></span>
                        </xsl:when>
                    </xsl:choose>
                </div>
            </div> 
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-block-mail">
        <xsl:if test="metadata/email">
            <div class="block-agent">
                <div class="icon">
                    <xsl:call-template name="mail-icon"/>
                </div>
                <div class="description">
                    <span class="title"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_EMAIL" i18n:catalogue="skin.{$skin}"/></span>
                    <span class="subtitle">
                        <xsl:call-template name="mail-antispam">
                            <xsl:with-param name="mail" select="metadata/email"></xsl:with-param>
                        </xsl:call-template>
                    </span>
                </div>
            </div>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="profile-block-contact">
        <xsl:if test="metadata/phone or metadata/mobile">
            <div class="block-agent">
                <div class="icon">
                    <xsl:call-template name="contact-icon"/>
                </div>
                <div class="description">
                    <span class="title"><i18n:text i18n:key="SKIN_CONTENT_MEMBER_CONTACT" i18n:catalogue="skin.{$skin}"/></span>
                    
                    <div class="flex">
                        <xsl:if test="metadata/phone">
                            <span class="text ametys-editable editable--text editable--text-small" data-ametys-metadata="{concat(/view/content/@id, ';phone')}">
                                <i18n:text i18n:key="SKIN_CONTENT_MEMBER_PHONE" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text>
                                <a href="tel:{metadata/phone}"><xsl:value-of select="metadata/phone"/></a>
                            </span>
                        </xsl:if>
                        <xsl:if test="metadata/mobile">
                            <span class="text ametys-editable editable--text editable--text-small"  data-ametys-metadata="{concat(/view/content/@id, ';mobile')}">
                                <i18n:text i18n:key="SKIN_CONTENT_MEMBER_MOBILE" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text>
                                <a href="tel:{metadata/mobile}"><xsl:value-of select="metadata/mobile"/></a>
                            </span>
                        </xsl:if>
                    </div>
                </div>
            </div>
        </xsl:if>
   </xsl:template>
   
   <xsl:template name="location-icon">
        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
             viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
          <g>
              <g>
                  <path d="M256,0C156.7,0,76,80.7,76,180c0,33.5,9.3,66.3,26.9,94.7l142.9,230.3c2.7,4.4,7.6,7.1,12.7,7.1c0,0,0.1,0,0.1,0
                      c5.2,0,10.1-2.8,12.8-7.3l139.2-232.5c16.6-27.8,25.4-59.7,25.4-92.2C436,80.7,355.3,0,256,0z M384.9,256.8L258.3,468.2
                      L128.4,258.8c-14.6-23.6-22.6-50.9-22.6-78.8c0-82.7,67.5-150.2,150.2-150.2S406.1,97.3,406.1,180
                      C406.1,207.1,398.7,233.7,384.9,256.8z"/>
              </g>
          </g>
          <g>
              <g>
                  <path d="M256,90c-49.6,0-90,40.4-90,90c0,49.3,39.7,90,90,90c50.9,0,90-41.2,90-90C346,130.4,305.6,90,256,90z M256,240.2
                      c-33.3,0-60.2-27-60.2-60.2c0-33.1,27.1-60.2,60.2-60.2s60.1,27.1,60.1,60.2C316.1,212.7,289.8,240.2,256,240.2z"/>
              </g>
          </g>
       </svg>
   </xsl:template>
   
   <xsl:template name="mail-icon">
        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
               viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
              <g>
                  <g>
                      <path d="M467,76H45C20.1,76,0,96.3,0,121v270c0,24.9,20.3,45,45,45h422c24.7,0,45-20,45-45V121C512,96.3,491.9,76,467,76z
                           M460.7,106c-9.2,9.1-167.4,166.5-172.9,172c-8.5,8.5-19.8,13.2-31.8,13.2s-23.3-4.7-31.8-13.2C220.5,274.3,64,118.6,51.3,106
                          H460.7z M30,384.9V127.1l129.6,129L30,384.9z M51.3,406l129.6-128.8l22.1,21.9c14.2,14.2,33,22,53,22s38.9-7.8,53-21.9l22.1-22
                          L460.7,406H51.3z M482,384.9L352.4,256.1l129.6-129V384.9z" fill="#FC7D85"/>
                </g>
                </g>
        </svg>
   </xsl:template>
   
   <xsl:template name="contact-icon">
        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
               viewBox="0 0 473.8 473.8" style="enable-background:new 0 0 473.8 473.8;" xml:space="preserve">
          <g>
              <g>
                  <path d="M374.5,293.5c-9.7-10.1-21.4-15.5-33.8-15.5c-12.3,0-24.1,5.3-34.2,15.4l-31.6,31.5c-2.6-1.4-5.2-2.7-7.7-4
                      c-3.6-1.8-7-3.5-9.9-5.3c-29.6-18.8-56.5-43.3-82.3-75c-12.5-15.8-20.9-29.1-27-42.6c8.2-7.5,15.8-15.3,23.2-22.8
                      c2.8-2.8,5.6-5.7,8.4-8.5c21-21,21-48.2,0-69.2l-27.3-27.3c-3.1-3.1-6.3-6.3-9.3-9.5c-6-6.2-12.3-12.6-18.8-18.6
                      c-9.7-9.6-21.3-14.7-33.5-14.7s-24,5.1-34,14.7c-0.1,0.1-0.1,0.1-0.2,0.2l-34,34.3C9.7,89.4,2.4,105,0.8,123.1
                      c-2.4,29.2,6.2,56.4,12.8,74.2C29.8,241,54,281.5,90.1,324.9c43.8,52.3,96.5,93.6,156.7,122.7c23,10.9,53.7,23.8,88,26
                      c2.1,0.1,4.3,0.2,6.3,0.2c23.1,0,42.5-8.3,57.7-24.8c0.1-0.2,0.3-0.3,0.4-0.5c5.2-6.3,11.2-12,17.5-18.1c4.3-4.1,8.7-8.4,13-12.9
                      c9.9-10.3,15.1-22.3,15.1-34.6c0-12.4-5.3-24.3-15.4-34.3L374.5,293.5z M410.3,398.8C410.2,398.8,410.2,398.9,410.3,398.8
                      c-3.9,4.2-7.9,8-12.2,12.2c-6.5,6.2-13.1,12.7-19.3,20c-10.1,10.8-22,15.9-37.6,15.9c-1.5,0-3.1,0-4.6-0.1
                      c-29.7-1.9-57.3-13.5-78-23.4C202,396,152.3,357.1,111,307.8c-34.1-41.1-56.9-79.1-72-119.9c-9.3-24.9-12.7-44.3-11.2-62.6
                      c1-11.7,5.5-21.4,13.8-29.7l34.1-34.1c4.9-4.6,10.1-7.1,15.2-7.1c6.3,0,11.4,3.8,14.6,7c0.1,0.1,0.2,0.2,0.3,0.3
                      c6.1,5.7,11.9,11.6,18,17.9c3.1,3.2,6.3,6.4,9.5,9.7l27.3,27.3c10.6,10.6,10.6,20.4,0,31c-2.9,2.9-5.7,5.8-8.6,8.6
                      c-8.4,8.6-16.4,16.6-25.1,24.4c-0.2,0.2-0.4,0.3-0.5,0.5c-8.6,8.6-7,17-5.2,22.7c0.1,0.3,0.2,0.6,0.3,0.9
                      c7.1,17.2,17.1,33.4,32.3,52.7l0.1,0.1c27.6,34,56.7,60.5,88.8,80.8c4.1,2.6,8.3,4.7,12.3,6.7c3.6,1.8,7,3.5,9.9,5.3
                      c0.4,0.2,0.8,0.5,1.2,0.7c3.4,1.7,6.6,2.5,9.9,2.5c8.3,0,13.5-5.2,15.2-6.9l34.2-34.2c3.4-3.4,8.8-7.5,15.1-7.5
                      c6.2,0,11.3,3.9,14.4,7.3c0.1,0.1,0.1,0.1,0.2,0.2l55.1,55.1C420.5,377.7,420.5,388.2,410.3,398.8z"/>
                  <path d="M256.1,112.7c26.2,4.4,50,16.8,69,35.8s31.3,42.8,35.8,69c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
                      c7.4-1.2,12.3-8.2,11.1-15.6c-5.4-31.7-20.4-60.6-43.3-83.5s-51.8-37.9-83.5-43.3c-7.4-1.2-14.3,3.7-15.6,11
                      S248.7,111.5,256.1,112.7z"/>
                  <path d="M473.3,209c-8.9-52.2-33.5-99.7-71.3-137.5S316.7,9.1,264.5,0.2c-7.3-1.3-14.2,3.7-15.5,11c-1.2,7.4,3.7,14.3,11.1,15.6
                      c46.6,7.9,89.1,30,122.9,63.7c33.8,33.8,55.8,76.3,63.7,122.9c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
                      C469.6,223.3,474.6,216.3,473.3,209z"/>
              </g>
            </g>
          </svg>
   </xsl:template>  
   
   <xsl:template match="metadata[@type='rich-text']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/docbook:article">
            <div class="ametys-editable" data-ametys-attribute="{$name}">
            
                <xsl:apply-templates select="." mode="label"/>
                
                <div class="ametys-editable editable--richtext" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <xsl:apply-templates select="." mode="label"/>
            
            <xsl:variable name="definition" select="."/>
            <xsl:choose>
                <xsl:when test="@multiple = 'true'">
                    <ul class="content-tags ametys-editable editable--contenttags" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:for-each select="$value">
                            <li class="content-tags__item">
                                <xsl:apply-templates select="$definition" mode="value">
                                    <xsl:with-param name="value" select="."/>
                                </xsl:apply-templates>
                            </li>
                        </xsl:for-each>
                    </ul>
                </xsl:when>
                <xsl:otherwise>
                    <p data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </p>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='string']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>

        <xsl:if test="$value">
            <xsl:apply-templates select="." mode="label"/>
        
            <xsl:variable name="definition" select="."/>
            <p class="ametys-editable" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                <xsl:apply-templates select="$definition" mode="value">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='rich-text']" mode="label">
        <h1 class="ametys-richtext-title-1 ametys-editable"><xsl:value-of select="label"/></h1>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="label">
        <h1 class="ametys-richtext-title-1"><xsl:value-of select="label"/></h1>
    </xsl:template>
    
    <xsl:template match="metadata[@type='string']" mode="label">
        <h1 class="ametys-richtext-title-1"><xsl:value-of select="label"/></h1>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="contentId" select="$value/@id" />
        <xsl:if test="$contentId != ''">
            <xsl:choose>
                <xsl:when test="ametys:isReferenceTableContent($contentId)">
                    <xsl:value-of select="$value/@title"/>
                </xsl:when>
                <xsl:otherwise>
                    <a href="{resolver:resolve('content', $contentId)}">
                        <xsl:value-of select="$value/@title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='rich-text']" mode="value">
        <xsl:param name="value"/>
        <xsl:param name="level" select="2"/>
        
        <xsl:apply-templates select="$value/docbook:article">
            <xsl:with-param name="level" select="$level"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <xsl:template name="user-image-default-url">
        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/avatar-homme.svg')}" />
    </xsl:template>
</xsl:stylesheet>