<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
    xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper" 
    exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="skin://stylesheets/content/member/member-abstract.xsl" />
    
    <xsl:variable name="common-content-css-class-name">contact</xsl:variable>
    
    <xsl:template name="common-content-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/contact/scss/main.css')}"/> 
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="content-image" />
        <xsl:call-template name="content-title" />
        
        <xsl:call-template name="content-function" />
        
        <div class="contact-info">
            <xsl:call-template name="content-contact-infos" />
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <xsl:variable name="page-id" select="user:getUserPage(@id)" />
        <h1 class="title ametys-richtext-title-2">
            <a href="{resolver:resolve('page', $page-id, false)}">
                <xsl:value-of select="metadata/title"/>
            </a>
        </h1>
    </xsl:template>
    
    <xsl:template name="content-function">
        <span class="function">
            <xsl:value-of select="metadata/function" />
        </span>
    </xsl:template>
    
    <xsl:template name="content-contact-infos">
        <xsl:choose>
            <xsl:when test="metadata/phone != ''">
                <a class="tel phone" href="tel:{translate(metadata/phone, ' ', '')}">
                    <xsl:value-of select="metadata/phone" />
                </a>
            </xsl:when>
            <xsl:when test="metadata/mobile != ''">
                <span class="tel mobile" href="tel:{translate(metadata/mobile, ' ', '')}">
                    <xsl:value-of select="metadata/mobile" />
                </span>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="metadata/email != ''">
            <xsl:call-template name="mail-antispam">
                <xsl:with-param name="mail" select="metadata/email"></xsl:with-param>
                <xsl:with-param name="class">mailto</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
