<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="resolver ametys user">

	<xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:template name="common-content-body-title"/>
    
	<xsl:template name="common-content-body-content">
        <xsl:variable name="page-id" select="user:getUserPage(@id)"/>
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:value-of select="metadata/title"/>            
        </a>
    </xsl:template>
</xsl:stylesheet>
