<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="sitemap ametys">

    <xsl:import href="skin://stylesheets/main.xsl"/>
    <xsl:import href="workspace:web://stylesheets/service/_wrapper/service.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
 
    <xsl:template name="head">
        <xsl:call-template name="favico"/>  
        
        <title><xsl:value-of select="/html/head/title"/> - <i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/></title>
        
        <xsl:call-template name="head-js-jquery"/>
        <xsl:call-template name="head-css-jquery"/>
        
        <xsl:call-template name="head-js-user"/>
        
        <xsl:call-template name="head-js-front"/>
        
        <xsl:call-template name="head-js-pirobox"/>
        <xsl:call-template name="head-css-pirobox"/>
        
        <xsl:call-template name="head-js-mediaelement"/>      
        <xsl:call-template name="head-css-mediaelement"/>   
        
        <xsl:call-template name="common-css" />
        <xsl:call-template name="additionnal-css" />
        
        <xsl:call-template name="common-script" />
        <xsl:call-template name="additionnal-script" />
        
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/page_interieur.css')}"/>
                
        <xsl:copy-of select="/html/head/*[local-name() != 'title' and local-name() != 'meta']"/>
    </xsl:template>
    
    <xsl:template name="body">
        <body>
            <xsl:call-template name="main-zone"/>
        </body>
    </xsl:template>
    
    <xsl:template name="main-zone">
        <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level" select="1"/>
        </xsl:apply-templates>
    </xsl:template>
    
</xsl:stylesheet>