<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:datetime="http://ametys.org/datetime/4.2" 
                              exclude-result-prefixes="resolver exslt ametys"
                              extension-element-prefixes="datetime">
                              
    <xsl:import href="skin://stylesheets/content/news/news-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    
    <xsl:template name="common-content-body">
        <xsl:call-template name="common-content-body-title"/>
        
        <xsl:call-template name="common-content-body-content"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <a href="{resolver:resolve('page', $page-id, false)}">
            <xsl:call-template name="content-image"/>
            <div class="infos"> 
                <xsl:if test="not(metadata/illustration/image)">
                  <xsl:attribute name="class">infos no-picture</xsl:attribute>
                </xsl:if>
                <xsl:call-template name="content-tag"/>
                <xsl:call-template name="content-title"/>
                <xsl:call-template name="content-date"/>
            </div>
        </a>
    </xsl:template>
    
    <xsl:template name="content-date">
        <xsl:if test="metadata/start-date or metadata/end-date">
            <div class="date">
                <xsl:call-template name="dates-inner">
                    <xsl:with-param name="startDate" select="metadata/start-date"/>
                </xsl:call-template>
                
                <xsl:if test="metadata/start-date and metadata/end-date and not(datetime:sameDate(metadata/start-date, metadata/end-date))">
                  <!-- case when the two datetimes represent the same date -->
                  <xsl:call-template name="dates-inner">
                    <xsl:with-param name="endDate" select="metadata/end-date"/>
                  </xsl:call-template>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
     <xsl:template name="date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        
        <div class="date-item">
            <span class="day"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="d"><xsl:value-of select="$date"/></i18n:date></span>
            <span class="month"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="MMM"><xsl:value-of select="$date"/></i18n:date></span>
        </div>
    </xsl:template>
    
    <xsl:template name="dates-icon"/>
    
    <xsl:template name="date-separator"/>
    
    <xsl:template name="content-tag">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:if test="exslt:node-set($tags)/tag">
            <div class="tags">
                <xsl:for-each select="exslt:node-set($tags)/tag">
                    <span class="tag">
                        <xsl:if test="$useTagColor and @bgColor">
                            <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="." />
                   </span>
            </xsl:for-each>
            </div>
        </xsl:if>
     </xsl:template>
     
    <xsl:template name="content-image">
        <xsl:choose>
            <xsl:when test="metadata/illustration/image">
                <div class="picture">
                    <picture>
                        <source srcset="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@uri, 220, 290)}" media="(max-width: 340px)" />
                        <source srcset="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@uri, 220, 320)}" media="(max-width: 400px)" />
                        <img src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@uri, 220, 380)}" alt="{metadata/illustrations/image1/alt-text}" />
                    </picture>
                </div>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>