<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:datetime="http://ametys.org/datetime/4.2"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys datetime resolver">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />
	
	<xsl:template name="main-zone-content">
		<div class="full-screen fullpage">
			<div class="content">
				<zone name="default" level="2"/>
			</div>
			<div class="content">
				<zone name="secondary" level="2"/>
			</div>
            <div class="content">
                <zone name="bottom" level="2"/>
            </div>
		</div>
    </xsl:template>
    
    <xsl:template name="fo-toolbar-page">
        <xsl:call-template name="ametys-front-edition-page-toolbar">
            <xsl:with-param name="add-contents-config">[
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_CONTENT_TO_DEFAULT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "secondary", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_CONTENT_TO_SECONDARY" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_NEWS_TO_DEFAULT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-file-alt", "zoneName": "secondary", "label": "<i18n:text i18n:key="SKIN_FO_TOOLBAR_ADD_NEWS_TO_SECONDARY" i18n:catalogue="skin.{$skin}"/>"}
            ]</xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
               "default-pagetype" : "template",                 
               "default-template" : "page",                 
               "default-pagecontent-type" : "contenttype",   
               "pagetype-card-template-filter": ["page", "fullpage"]       
               }</xsl:with-param>  
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>