<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:datetime="http://ametys.org/datetime/4.2"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys datetime resolver">

    <xsl:import href="skin://templates/page/stylesheets/template.xsl" />
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <!-- To ignore UD transitional page in breadcrumb -->
    <xsl:variable name="ignoreTransitionPages">true</xsl:variable>
    
    <xsl:template name="additionnal-script">
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/fo-toolbar.css')}" /> 
        
        <!-- Search keywords highlight -->
        <xsl:call-template name="search-keywords-highlight"/>  
    </xsl:template>    
    
    <xsl:template name="main-zone">
        <main role="main" id="main-content">
            <xsl:call-template name="navinterieur"/>
            
            <article class="page-interieur">
                <xsl:call-template name="main-zone-top"/>
                <xsl:call-template name="main-zone-content"/>
                
                <br style="clear:both"/>
            </article>
        </main>
    </xsl:template>
    
    <xsl:template name="main-title"/>
    
    <xsl:template name="main-zone-content">
	    <div class="full-screen">
			<div class="content">
				<div class="left leftContent">
					<zone name="default" level="1"/>
	                
	                <zone name="bottom" level="2"/>
				</div>
			</div>
		</div>
	</xsl:template>
    
    <xsl:template name="actions"/>
    
    <xsl:template name="zone-item-before">
      <xsl:param name="position"/>
      <xsl:param name="count"/>
      <xsl:param name="zone-name"/>
      <xsl:param name="level"/>
      <xsl:param name="inherited"/>
      <xsl:param name="id"/>
      <xsl:param name="type"/>
      <xsl:param name="content-id"/>
      <xsl:param name="service"/>
      <xsl:param name="content-type"/>
      
      <xsl:if test="$zone-name = 'default' and $content-id != ''">
          <xsl:call-template name="ametys-front-edition-content-toolbar">
            <xsl:with-param name="content-id" select="$content-id"/>
            <xsl:with-param name="zone-name" select="$zone-name"/>
            <xsl:with-param name="zone-item-id" select="@id"/>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="items">[{type: 'edit', label: 'Modifier la fiche complète'}]</xsl:with-param>
          </xsl:call-template>
      </xsl:if>
    </xsl:template>
    
    <xsl:template match="page[starts-with(@sitemap:id, 'udtransitional://')]" mode="breadcrumb">
        <xsl:if test="$ignoreTransitionPages != 'true'">
            <li>
                <a href="{$site-uri-prefix}/{$lang}/{@sitemap:path}.html"><xsl:value-of select="@sitemap:title" /></a>
                <span class="delimiter"><xsl:text>&#160;/&#160;</xsl:text></span>
            </li>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>