<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl math resolver ametys">
    
    <xsl:import href="plugin:link-directory://pages/services/directory/directory_1.0.xsl"/> 

    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/apps/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        
        <div id="link-directory-{$uniqueId}" class="service-applications">
            <xsl:apply-templates select="/links/link[not(@unknownPage)]">
                <xsl:sort select="@user-selected='true'" order="descending"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template match="link[@url != '' and @isHidden = 'false']">
      <div>
        <xsl:choose>
            <xsl:when test="@disabled">
                <xsl:attribute name="class">app <xsl:call-template name="common-utils-class"/> link-disabled</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="class">app <xsl:call-template name="common-utils-class"/></xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
        
        <a onclick="window.open(this.href); return false;" >
            <xsl:attribute name="href">
                <xsl:choose>
                    <xsl:when test="@urlType = 'PAGE'"><xsl:value-of select="resolver:resolve('page', @url)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:call-template name="link-status" />
            
            <xsl:choose>
                <xsl:when test="normalize-space(@alternative) != ''">
                    <xsl:attribute name="title"><xsl:value-of select="@alternative"/></xsl:attribute>
                </xsl:when>
                <xsl:when test="normalize-space(@title) != ''">
                    <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
                </xsl:when>
            </xsl:choose>
            
	        <xsl:call-template name="link-picture"/>
	        
	        <xsl:call-template name="link-title"/>
	     </a>
	   </div>
    </xsl:template>
    
    <xsl:template name="link-title">
    	<xsl:if test="normalize-space(@title) != ''">
            <div class="title">
              <xsl:value-of select="@title"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-picture">
        <xsl:variable name="picture-size">54</xsl:variable>
        
    	<xsl:if test="@pictureType != '' and (@pictureId or @picturePath or @pictureGlyph)">
	    	<div class="icon">
                <xsl:choose>
                    <xsl:when test="@pictureType = 'glyph'">
                        <span aria-hidden="true" role="img" class="link-glyph {@pictureGlyph}">
                            <xsl:call-template name="link-glyph-styles">
                            	<xsl:with-param name="picture-size" select="$picture-size"/>
                            </xsl:call-template>
                        </span>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="id">
                            <xsl:choose>
                                <xsl:when test="@pictureType = 'resource'">
                                    <xsl:value-of select="@pictureId"/>
                                </xsl:when>
                                <xsl:when test="@pictureType = 'external'">
                                    <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                            <img src="{resolver:resolveBoundedImage(@imageType, $id, $picture-size, $picture-size)}" alt="{@pictureAlternative}"/>
                    </xsl:otherwise>
                </xsl:choose>
	        </div>
		 </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-glyph-styles"/>
    
    <!-- Others features disabled -->
    <xsl:template name="display-configure-links-btn-service"/>
    <xsl:template name="display-add-user-link-btn-service"/>
    <xsl:template name="unknown-themes"/>
    
</xsl:stylesheet>
