<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
    xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper" 
    exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="skin://stylesheets/content/member/member.xsl" />
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl" />
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="common-content-body-content">
        <div class="item-card">
            <xsl:call-template name="content-image" />
            <div class="infos">
                <div>
                    <xsl:call-template name="content-title" />
                    <xsl:call-template name="content-abstract" />
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="content-title">
        <xsl:variable name="page-id" select="user:getUserPage(@id)" />
        <a class="title" href="{resolver:resolve('page', $page-id, false)}" data-ametys-page-link="true">
            <xsl:value-of select="metadata/title"/>
        </a>
    </xsl:template>

    <xsl:template name="content-abstract">
        <xsl:if test="metadata/function">
            <span class="function">
                <xsl:value-of select="metadata/function" />
            </span>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="metadata/phone != ''">
                <span class="tel">
                    <xsl:value-of select="metadata/phone" />
                </span>
            </xsl:when>
            <xsl:when test="metadata/mobile != ''">
                <span class="tel">
                    <xsl:value-of select="metadata/mobile" />
                </span>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="metadata/email != ''">
            <xsl:call-template name="mail-antispam">
                <xsl:with-param name="mail" select="metadata/email"></xsl:with-param>
                <xsl:with-param name="class">mailto</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="content-image">
        <div class="picture">
            <xsl:variable name="page-id" select="user:getUserPage(@id)" />
            <a class="title" href="{resolver:resolve('page', $page-id, false)}">
                <xsl:choose>
                    <xsl:when test="metadata/user">
                        <xsl:call-template name="user-profile-image">
                            <xsl:with-param name="size">80</xsl:with-param>
                            <xsl:with-param name="login" select="metadata/user/@login"/>
                            <xsl:with-param name="population" select="metadata/user/@populationId"/>
                            <xsl:with-param name="class">svg agent-svg</xsl:with-param>
                            <xsl:with-param name="lang" select="@language"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="metadata/illustration/image">
                        <img alt="{metadata/illustration/alt-text}" src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 80, 80)}" />
                    </xsl:when>
                    <xsl:otherwise>
                        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/avatar-homme.svg')}" />
                    </xsl:otherwise>
                </xsl:choose>
            </a>
        </div>
    </xsl:template>
</xsl:stylesheet>
