<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
		exclude-result-prefixes="ametys">
	
    <xsl:import href="plugin:web://pages/services/sitemap/sitemap_3.3.xsl"/>       
     
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
		<link rel="stylesheet" href="{ametys:skinURL('zones/site-map/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/site-map/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script src="{ametys:skinURL('zones/site-map/js/ametys-expanded-list.js')}"></script>
		<script type="text/javascript">
            $j(function () {
                $j('#<xsl:value-of select="$id"/> [data-toggle="collapse"]').on('click', function () {
                    var $this = $j(this);
                    var target = $this.data('target');
                    
                    $this.attr('aria-expanded', !($this.attr('aria-expanded') == 'true'));
                    $j(target).toggleClass('show');
                })
            });
        </script>
    </xsl:template>
    
    <xsl:template name="page-list">
        <xsl:if test="/sitemap/page">
            <ul id="{$id}" class="ametys-expanded-list">
                <xsl:apply-templates select="/sitemap/page"  mode="first-level"/>
            </ul>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template match="page" mode="first-level">
		<li class="ametys-expanded-list__item">
			<xsl:choose>
				<xsl:when test="page">
                    <div class="ametys-expanded-list__link-wrap">
    					<button class="ametys-expanded-list__link"
    					     aria-expanded="false"
    					     aria-controls="siteMapMenu-{generate-id()}"
                             aria-label="{@title}"
    					     data-toggle="collapse"
    					     data-target="#siteMapMenu-{generate-id()}"></button>
                         <a href="{resolver:resolve('page', @id)}" title="{@long-title}"><xsl:value-of select="@title"/></a>
                    </div>
					<ul id="siteMapMenu-{generate-id()}" class="ametys-expanded-second-type-list collapse">
						<xsl:apply-templates select="page"/>
					</ul>
				</xsl:when>
				<xsl:otherwise>
					<a href="{resolver:resolve('page', @id)}" title="{@long-title}"><xsl:value-of select="@title"/></a>
				</xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
	
	<xsl:template match="page">
		<li class="ametys-expanded-second-type-list__item">
			<xsl:choose>
				<xsl:when test="page">
                    <div class="ametys-expanded-second-type-list__link-wrap">
                        <button class="ametys-expanded-second-type-list__link"
                             aria-expanded="false"
                             aria-controls="siteMapMenu-{generate-id()}"
                             aria-label="{@title}"
                             data-toggle="collapse"
                             data-target="#siteMapMenu-{generate-id()}">
                        </button>
                        <a href="{resolver:resolve('page', @id)}" title="{@long-title}"><xsl:value-of select="@title"/></a>
                    </div>
					<ul id="siteMapMenu-{generate-id()}" class="ametys-expanded-second-type-list collapse">
						<xsl:apply-templates select="page"/>
					</ul>
				</xsl:when>
				<xsl:otherwise>
					<a href="{resolver:resolve('page', @id)}" title="{@long-title}" class="ametys-expanded-second-type-list__link"><xsl:value-of select="@title"/></a>
				</xsl:otherwise>
			</xsl:choose>
		</li>
	</xsl:template>
    
</xsl:stylesheet>		
