<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
	xmlns:math="java.lang.Math"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	extension-element-prefixes="ametys math sitemap resolver">

    <!-- +
         | Name of global search text field :
         | * use "user.input.criterion.common$wording$textfield$1" if global search service if configured with "Full text" criteria
         | * use "user.input.criterion.common$titleorwording$textfield$1" if global search service if configured with "Title or full text" criteria
         + -->
    <xsl:variable name="searchInputName">user.input.criterion.common$titleorwording$textfield$1</xsl:variable>
    
    <xsl:template name="search-form">
        <xsl:param name="cssClass">search search-header</xsl:param>
        
    	<xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]">
    		<a name="search"></a>
            
            <form class="{$cssClass}" role="search" action="{resolver:resolve('page', /cms/inputData/sitemap//page[@PLUGIN_TAGS_SEARCH]/@sitemap:id)}" method="post" aria-label="skin.{$skin}:SKIN_MAIN_SEARCH_LABEL" i18n:attr="aria-label">
                <xsl:if test="ametys:renderingContext() = 'back'"><xsl:attribute name="target">_blank</xsl:attribute></xsl:if>
                <xsl:call-template name="search-form-fields"/>
            </form>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="search-form-fields">
        <xsl:call-template name="search-icon"/>
        
    	<xsl:variable name="searchUniqueId" select="concat('search-', substring-after(math:random(), '.'))"/>
        
        <label for="search-field-{$searchUniqueId}" class="sr-only" data-renewfor=""><i18n:text i18n:key="SKIN_SEARCH_INPUT_TITLE" i18n:catalogue="skin.{$skin}"/></label>
        <input type="text" class="input-text" name="{$searchInputName}" data-renewid="" id="search-field-{$searchUniqueId}" placeholder="skin.{$skin}:SKIN_SEARCH_INPUT_TITLE" title="skin.{$skin}:SKIN_SEARCH_INPUT_TITLE" i18n:attr="title placeholder">
            <xsl:call-template name="search-form-fields-additionnal-attributes"/>
        </input>
        <input type="hidden" name="submit-form" />
    </xsl:template>
    
    <!-- Activate the fast search on page title -->
    <xsl:template name="search-form-fields-additionnal-attributes">
        <xsl:attribute name="data-ametys-fastsearch">page</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-classname-hide">noresult</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-ul-classname">ametys-fastsearch-result-ul</xsl:attribute>
        <xsl:attribute name="data-ametys-fastsearch-result-li-classname">ametys-fastsearch-result-li</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="search-icon">
        <svg aria-hidden="true" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 310.4 310.4"
            style="enable-background:new 0 0 310.4 310.4;" xml:space="preserve">
            <g>
                <g>
                    <path d="M273.6,215c49.1-49.1,49.1-129,0-178.1c-49.1-49.1-129-49.1-178.1,0c-41.7,41.7-48,103.6-18.9,152c0,0,2.1,3.5-0.7,6.3
                    c-16.1,16.1-64.3,64.3-64.3,64.3c-12.8,12.8-15.8,30.7-4.5,42l2,2c11.3,11.3,29.2,8.3,42-4.5c0,0,48.1-48.1,64.1-64.1
                    c3-3,6.4-0.9,6.4-0.9C170,262.9,231.9,256.6,273.6,215z M118.7,191.7c-36.3-36.3-36.3-95.3,0-131.6c36.3-36.3,95.3-36.3,131.6,0
                    c36.3,36.3,36.3,95.3,0,131.6C214,228,155,228,118.7,191.7z" />
                    <g>
                        <path
                            d="M126.8,118.4c-1.7,0-3.4-0.3-5.1-1c-6.6-2.8-9.7-10.4-6.9-17c17.6-41.6,65.7-61.1,107.3-43.5c6.6,2.8,9.7,10.4,6.9,17
                        c-2.8,6.6-10.4,9.7-17,6.9c-28.4-12-61.2,1.3-73.2,29.7C136.6,115.4,131.8,118.4,126.8,118.4z" />
                    </g>
                </g>
            </g>
        </svg>
    </xsl:template>
    
    <xsl:template name="search-keywords-highlight">
        <script type="text/javascript" src="{ametys:skinURL('plugins/js/jquery.mark.js')}"></script>
        <script type="text/javascript">
            $j(function()
            {
                // Extract the keywords from the URL
                var hlRegexp = new RegExp('[\?\&amp;]search-keywords=([^\?\&amp;#;]+)', 'i');
                var result = hlRegexp.exec(location.search);
                if (result != null &amp;&amp; result.length &gt; 1)
                {
                    var keywords = result[1].split('+');
                    for (var x = 0; x &lt; keywords.length; x++)
                    {
                        if (keywords[x] != '')
                        {
                            <xsl:for-each select="/cms/template-information/template/zone">
                                $j('#ametys-cms-zone-<xsl:value-of select="@id"/>').mark($j.trim(decodeURIComponent(keywords[x])));
                            </xsl:for-each> 
                        }
                    }
                }
            });
        </script>
    </xsl:template> 
    
</xsl:stylesheet>
