function openOrCloseUserMenuItem(currentStep, nextStep)
{
	let nextParams = nextStep['transitionParams'] || {};
	if (nextParams.openUserMenuItemId)
	{
		if ($j(".open-menu-mobile.is-closed").is(':visible'))
        {
			openMenuMobile(); // open user menu in mobile
        }
			
		// Open user menu item	
		$j(`button[data-user-menu-id="${nextParams.openUserMenuItemId}"]`).trigger('click');
		
		return 300;
	}
	else if ($j(".menu-fixed.opened").length) // user menu is open
	{
		// Close menu
		closeMenu();
		return 300;
		
	}
	return 0;
}

function openOrCloseMainMobileMenuIfNeeded(currentStep, nextStep)
{
    let nextParams = nextStep['transitionParams'] || {};
    if (nextParams.type == "main-menu")
    {
		var isMobile = $j(".open-menu-mobile").is(':visible');
		if (isMobile && !$j('header .second.open').length)
        {
			openSecondMobile(); // open main mobile menu
			return 300;
        }
		else if (!isMobile)
		{
			window.scrollTo({ top: 0, behavior: 'smooth' })
		}
    }
	else if($j('.second.open').length) // main mobile menu is open
	{
		closeSecondMobile();
		return 300;
	}
    return 0;
}

function selectMainMenuItem(step)
{
	let params = step['transitionParams'] || {};
	let position = params.position || 1;
	
	var isMobileMenu = $j('header .second.open').length != 0;
	if (isMobileMenu)
	{
		return $j(`header[role=banner] .second.open:visible nav > ul > li:nth-child(${position})`)[0];
	}
	else 
	{
		return $j(`header[role=banner] .second-container nav > ul > li:nth-child(${position})`)[0];
	}
}

AmetysFront.WelcomeTour.transitionFunction = function(currentStep, nextStep)
{
    let transitions = [openOrCloseUserMenuItem, openOrCloseMainMobileMenuIfNeeded];
    let delays = transitions.map(t => t.apply(null, [currentStep, nextStep]))
    return Math.max(...delays);
}
