<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
            	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            	xmlns:docbook="http://docbook.org/ns/docbook"
            	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
            	xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
            	xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
            	exclude-result-prefixes="docbook resolver">
    
    <xsl:import href="jobOffer.xsl" />
    <xsl:import href="skin://stylesheets/content/common-abstract.xsl"/> 
    
    <xsl:template name="common-content-body">
        <xsl:choose>
            <xsl:when test="$zone = 'default' or $zone = 'secondary'">
                <div class="ametys-cms-content {$common-content-css-class-name} wrapper">
                    <xsl:call-template name="common-content-body-title"/>
                    <xsl:call-template name="common-content-body-content"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="page-id"><xsl:call-template name="get-page-id" /></xsl:variable>
                <a href="{resolver:resolve('page', $page-id, false)}" data-ametys-page-link="true">
                    <section>
                        <xsl:call-template name="job-tag"/>
                        <xsl:call-template name="job-start-date"/>
                        <xsl:call-template name="job-title"/>
                    </section>
                    <xsl:call-template name="job-closing-date"/>
                </a>     
            </xsl:otherwise>
        </xsl:choose>  
    </xsl:template>
    
    <xsl:template name="job-tag">
        <xsl:if test="metadata/contractType/@title">
            <span class="tag"><xsl:value-of select="metadata/contractType/@title"/></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-start-date">
        <xsl:if test="metadata/startDate">
            <div class="date-container">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/startDate"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="job-title">
        <span class="title"><xsl:value-of select="metadata/title"/></span>
    </xsl:template>
    
    <xsl:template name="job-closing-date">
        <xsl:if test="metadata/closingDate">
            <span class="excerpt">
                <xsl:call-template name="dates">
	                <xsl:with-param name="endDate" select="metadata/closingDate"/>
	                <xsl:with-param name="textBefore"><i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_ABSTRACT_END_DATE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    <xsl:with-param name="withIcon">false</xsl:with-param>
                </xsl:call-template>
                <!-- xsl:call-template name="apply-icon"/-->
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="apply-icon">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="enable-background:new 0 0 512 512;" viewBox="0 0 512 512" y="0px" x="0px" id="Layer_1" version="1.1">
            <path d="M490.3,0.8l-479,156.5c-13.5,4.4-15.5,22.8-3.2,30l181,105.3c5.7,3.3,12.8,2.9,18.1-1l50.9-37.8l-37.8,50.9                     c-3.9,5.3-4.3,12.4-1,18.1l105.3,181c7.2,12.3,25.6,10.3,30-3.2l156.5-479C515.4,8.8,503.1-3.3,490.3,0.8L490.3,0.8z M334.7,455.3                     l-81.2-139.7l98-131.9c4.9-6.6,4.2-15.7-1.6-21.5c-5.8-5.8-15-6.5-21.5-1.6l-131.9,98L56.7,177.3l413-134.9L334.7,455.3z                      M173.4,361.9L63.7,471.6c-6.4,6.4-16.9,6.5-23.4,0c-6.5-6.4-6.5-16.9,0-23.4l109.7-109.7c6.5-6.4,16.9-6.5,23.4,0                     C179.9,345,179.9,355.5,173.4,361.9z M28.5,366.1c-6.5-6.5-6.5-16.9,0-23.4l43.3-43.3c6.4-6.5,16.9-6.5,23.4,0                     c6.5,6.5,6.5,16.9,0,23.4l-43.3,43.3C45.4,372.5,35,372.5,28.5,366.1z M212.5,416.8c6.5,6.4,6.5,16.9,0,23.4l-43.3,43.3                     c-3.2,3.2-7.5,4.8-11.7,4.8c-14.6,0-22.1-17.8-11.7-28.2l43.3-43.3C195.6,410.4,206.1,410.4,212.5,416.8L212.5,416.8z"></path>
        </svg>
    </xsl:template>

    <xsl:template name="content-default-image">
        <img class="svg" src="{ametys:skinURL('templates/common/img/icon/recherche/emploi.svg')}"/>
    </xsl:template>
    
    <xsl:template name="content-dates">
        <xsl:if test="metadata/startDate">
            <div class="date-container">
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="metadata/startDate"/>
                    <xsl:with-param name="textBefore"><i18n:text i18n:key="SKIN_CONTENT_JOB_OFFER_ABSTRACT_START_DATE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
