<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:math="java.lang.Math" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:str="http://exslt.org/strings"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                exclude-result-prefixes="xalan math str ametys resolver user filenameutils">  
    
    <xsl:import href="plugin:web://stylesheets/utils.xsl"/>
	<xsl:import href="workspace:web://stylesheets/variables.xsl"/>
	<xsl:import href="skin://stylesheets/variables.xsl"/>
    
	<xsl:variable name="site" select="ametys:site()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    
    <xsl:variable name="openNewWindowSuffix" select="ametys:translate(concat('skin.', $skin, ':SKIN_LINK_OPEN_NEW_WINDOW_SUFFIX'), $lang)"></xsl:variable>
	
    <!-- +
         | Helper to insert a breadcrumb
         +  -->
    <xsl:template name="main-banner-breadcrumb">
        <xsl:if test="ametys:pageId() != ''"><!-- No breadcrumb when there is no current page (content view) -->
            <nav class="nav-breadcrumb" role="navigation" aria-label="skin.{$skin}:SKIN_BREADCRUMB_ARIA_LABEL" i18n:attr="aria-label">
                <a name="breadcrumb"/>
                <ul class="breadcrumb">
                    <xsl:if test="ametys:pageExists($site, $lang, 'index')">
                        <li>
                            <a href="{$site-uri-prefix}/{$lang}/index.html">
                                <xsl:value-of select="ametys:pageTitle($site, $lang, 'index')"/>
                            </a>
                        </li>
                    </xsl:if>
                    <xsl:for-each select="ametys:breadcrumb()">
                        <li>
                        	<span class="delimiter" aria-hidden="true"><xsl:text>&#160;/&#160;</xsl:text></span>
                            <a href="{resolver:resolve('page', .)}"><xsl:value-of select="ametys:pageTitle(.)"/></a>
                        </li>
                    </xsl:for-each>
                    <li class="current">
                    	<span class="delimiter" aria-hidden="true"><xsl:text>&#160;/&#160;</xsl:text></span>
                    	<span class="noLink"><xsl:value-of select="ametys:pageTitle(ametys:pageId())"/></span>
                    </li>
                </ul>
            </nav>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="file-icon">
        <xsl:param name="filename"/>
        <xsl:param name="altWithExtension">false</xsl:param>
        
        <xsl:variable name="fileExtension" select="filenameutils:getExtension($filename)"/>
        <xsl:variable name="fileExtensionLc" select="translate($fileExtension, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>

        <xsl:variable name="pngSkinPath" select="concat('templates/common/img/icon/files/', $fileExtensionLc, '.png')"/>
        <xsl:choose>
            <xsl:when test="ametys:skinResources($pngSkinPath)">
                <img alt="" src="{ametys:skinURL($pngSkinPath)}" class="svg">
                    <xsl:if test="$altWithExtension = 'true'">
                        <xsl:attribute name="alt"><xsl:value-of select="$fileExtensionLc"/></xsl:attribute>
                    </xsl:if>
                </img>
            </xsl:when>
            <xsl:otherwise>
                <img alt="" src="{ametys:skinURL('templates/common/img/icon/file.svg')}" class="icon">
                    <xsl:if test="$altWithExtension = 'true'">
                        <xsl:attribute name="alt"><xsl:value-of select="$fileExtensionLc"/></xsl:attribute>
                    </xsl:if>
                </img>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>   
    
    <!-- Helper for format size -->
    <xsl:template name="format-size">
        <xsl:param name="size"/>
        
        <xsl:choose>
            <xsl:when test="$size &lt; 1024">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_BYTES" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="$size"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:when test="$size &lt; (1024 * 1024)">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_KB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div 1024)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_MB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div (1024 * 1024))"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Helper for format size to use in attribute -->
    <xsl:template name="format-size-in-attribute">
        <xsl:param name="size"/>
        
        <xsl:choose>
            <xsl:when test="$size &lt; 1024">
                <xsl:variable name="i18nparams"><size><xsl:value-of select="$size"/></size></xsl:variable> 
                <xsl:value-of select="ametys:translate('plugin.web:ATTACHMENTS_FILE_SIZE_BYTES', $lang, $i18nparams)"/>
            </xsl:when>
            <xsl:when test="$size &lt; (1024 * 1024)">
                <xsl:variable name="i18nparams"><size><xsl:value-of select="round($size div 1024)"/></size></xsl:variable> 
                <xsl:value-of select="ametys:translate('plugin.web:ATTACHMENTS_FILE_SIZE_KB', $lang, $i18nparams)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="i18nparams"><size><xsl:value-of select="round($size div (1024 * 1024))"/></size></xsl:variable> 
                <xsl:value-of select="ametys:translate('plugin.web:ATTACHMENTS_FILE_SIZE_MB', $lang, $i18nparams)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="get-content-tags">
        <xsl:param name="tags" select="tags/*"/>
        
        <xsl:for-each select="$tags">
            <xsl:variable name="tagId" select="local-name()"/>
            <xsl:variable name="tagPath" select="ametys:tagPath($site, $tagId)"/>
            <xsl:variable name="tagColor" select="ametys:tagColor($site, $tagId)"/>
            
            <xsl:if test="contains($tagPath, 'CONTENT_CATEGORIES')">
                <tag bgColor="{$tagColor/main}" textColor="{$tagColor/text}"><xsl:value-of select="." /></tag>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="user-profile-image">
        <xsl:param name="size">80</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="url">
            <xsl:call-template name="user-profile-image-url">
                <xsl:with-param name="size" select="$size"/>
                <xsl:with-param name="login" select="$login"/>
                <xsl:with-param name="population" select="$population"/>
                <xsl:with-param name="lang" select="$lang"/>
            </xsl:call-template>
        </xsl:variable>
        <img src="{$url}" alt="">
            <xsl:if test="$class != ''">
                <xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
            </xsl:if>
        </img>
    </xsl:template>
    
    <xsl:template name="user-profile-image-url">
        <xsl:param name="size">80</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>

        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $population, '/', uriutils:encodePath($login), '/image_', $size, '?lang=', $lang)"/>        
    </xsl:template>
    
    <!-- Templates for attributes to add on external links -->
    <xsl:template name="external-link-attributes">
        <xsl:param name="title"/>
        <xsl:param name="className">external</xsl:param>
        
        <xsl:attribute name="target">_blank</xsl:attribute>
        <xsl:attribute name="class"><xsl:value-of select="$className"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="concat($title, $openNewWindowSuffix)"/></xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>    