<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:stringutils="org.apache.commons.lang.StringUtils"
        exclude-result-prefixes="ametys resolver escaper stringutils url filename"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/results/search-results.xsl"/>
    <xsl:import href="skin://stylesheets/dates.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:template name="search-results">
        <div class="flex" data-ametys-search-role="search-results">
            <xsl:call-template name="search-sidebar"/>
            
            <div class="results">
                <xsl:call-template name="form-criteria-hidden"/>
            
                <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                    <xsl:call-template name="back-button"/>
                </xsl:if>
                
                <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
                    <xsl:call-template name="form-result"/>
                    <xsl:call-template name="form-result-js"/>
                </xsl:if>
                
                <xsl:choose>
                    <xsl:when test="/search/hits/hit">
                        <xsl:call-template name="hits"/>
                        <xsl:call-template name="pagination"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="/search/hits">
                            <!-- hits is present but no single hit => there is no result -->
                            <xsl:call-template name="no-result"/>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="form-result">
         <xsl:call-template name="results-count"/>
         <xsl:call-template name="filter-mobile"/>
    </xsl:template>
    
    <xsl:template name="results-count">
        <div class="nb-results">
            <span>
                <xsl:choose>
                    <xsl:when test="not(hits) or hits/@total = '0'"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_NO_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                    <xsl:when test="hits/@total = '1'"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_ONE_RESULT" i18n:catalogue="skin.{$skin}"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="hits/@total"/> <i18n:text i18n:key="SKIN_SERVICE_SEARCH_RESULTS" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
                </xsl:choose>
            </span>
            <xsl:call-template name="rss"/>
            <xsl:call-template name="link"/>
        </div>
    </xsl:template>   
    
    <xsl:template name="filter-mobile">
       <xsl:if test="/search/hits/hit and /search/form/facets/facet[@total > 0]">
            <div class="filter-button-block">
                <button class="btn filter" data-ametys-search-role="facet-filters" onclick="openFilter(this)" type="button" aria-haspopup="dialog" aria-expanded="false">
                    <span><i18n:text i18n:key="SKIN_SERVICE_SEARCH_OPEN_FILTERS" i18n:catalogue="skin.{$skin}"/></span>
                </button>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link">
        <xsl:if test="/search/link/page">
            <div class="link">
                <xsl:call-template name="link-tag"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="link-tag">
        <xsl:if test="/search/link/page">
            <a class="btn desktop">
                <xsl:attribute name="href">
                    <xsl:call-template name="link-href"/>
                </xsl:attribute>
                <xsl:call-template name="link-attribute"/>
                <span class="plus" aria-hidden="true">+</span>
                <span><xsl:call-template name="link-title"/></span>
            </a>
        </xsl:if>
    </xsl:template>
    
    <!-- Template for the rss link -->
    <xsl:template name="rss">
        <xsl:if test="RSSFeedURL != ''">
            <a href="{$site-uri-prefix}/{RSSFeedURL}" class="first-link">
            	<span class="icon-container icon-rss">
                    <xsl:call-template name="icon-rss"/>
                </span>
            	<span class="text">
            		<i18n:text i18n:key="SKIN_SERVICE_SEARCH_FILTERS_RSS_FEED_TITLE" i18n:catalogue="skin.{$skin}"/>
            	</span>
            </a>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="icon-rss">
    	<svg xmlns="http://www.w3.org/2000/svg" width="30.53" height="30.62" viewBox="0 0 30.53 30.62">
          <path id="icon-flux" class="cls-1" d="M1239.07,1771.65a20.16,20.16,0,0,1,20.16,20.2h-5.88a14.168,14.168,0,0,0-1.08-5.48,14.782,14.782,0,0,0-3.1-4.66,13.9,13.9,0,0,0-4.62-3.13,14.168,14.168,0,0,0-5.48-1.08v-5.85Zm0.04-10.43a30.373,30.373,0,0,1,21.54,8.98,30.431,30.431,0,0,1,6.53,9.75,30.03,30.03,0,0,1,2.41,11.9h-5.88a24.592,24.592,0,0,0-7.21-17.5,24.519,24.519,0,0,0-17.39-7.25v-5.88Zm7.58,24.48a4.041,4.041,0,0,0-1.49-1.47,4.1,4.1,0,0,0-2.07-.54,4.024,4.024,0,0,0-3.51,2.01,3.913,3.913,0,0,0-.55,2.05,4.01,4.01,0,0,0,.55,2.07,4.042,4.042,0,0,0,3.51,2.03,4.108,4.108,0,0,0,2.07-.55,3.993,3.993,0,0,0,1.49-1.48,4.1,4.1,0,0,0,.54-2.07A4,4,0,0,0,1246.69,1785.7Z" transform="translate(-1239.06 -1761.22)"/>
        </svg>
    </xsl:template>

    <xsl:template name="hits">
        <ul data-ametys-search-role="hits" class="result-list">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </ul>
    </xsl:template>    
    
    <xsl:template name="hit">
        <li>
            <xsl:apply-templates select="."/>
        </li>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>classic-item<xsl:text> </xsl:text>
    </xsl:template>
    
    <!-- Override rendering for resource hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']">
        <xsl:attribute name="class">
            <xsl:apply-templates select="." mode="class-attribute"/>
        </xsl:attribute>
        
        <a>
            <xsl:attribute name="href"><xsl:call-template name="hit-resource-title-link-href"/></xsl:attribute>
            
            <xsl:apply-templates select="." mode="image"/>
            <div class="infos">
                <span class="title"><xsl:value-of select="filename"/><xsl:text> </xsl:text><span class="weight">(<xsl:value-of select="size"/>)</span></span>
                <xsl:apply-templates select="." mode="abstract"/>
                <xsl:apply-templates select="." mode="date"/>
            </div>
            
        </a>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="class-attribute">
        <xsl:text/>classic-item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="image">
        <div class="picture">
            <xsl:call-template name="file-icon">
                <xsl:with-param name="filename" select="filename"></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="abstract">
        <p class="descri"><xsl:value-of select="excerpt"/></p>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="date">
        <div class="date-container">
            <xsl:call-template name="dates">
                <xsl:with-param name="startDate" select="lastModified"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    <!-- // End resource hits -->
    
    <!-- Override rendering for page hits -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']">
        <xsl:attribute name="class">
            <xsl:apply-templates select="." mode="class-attribute"/>
        </xsl:attribute>
        
        <div class="ametys-cms-content">
            <a>
                <xsl:attribute name="href"><xsl:call-template name="hit-page-title-href" /></xsl:attribute>
                
                <xsl:apply-templates select="." mode="image"/>
                
                <div class="infos">
                    <span class="title"><xsl:value-of select="title"/></span>
                    <xsl:apply-templates select="." mode="abstract"/>
                </div>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer' and contentTypes/contentType = 'org.ametys.plugins.workspaces.Content.member']" mode="abstract" priority="100">
        <xsl:if test="content/function">
            <span class="function"><xsl:value-of select="content/function"/></span>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="content/phone != ''">
                <span class="tel"><xsl:value-of select="content/phone"/></span>
            </xsl:when>
            <xsl:when test="content/mobile != ''">
                <span class="tel"><xsl:value-of select="content/mobile"/></span>
            </xsl:when>
        </xsl:choose>
        <xsl:if test="content/email != ''">
			<span class="mailto"><xsl:value-of select="content/email"/></span>
		</xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="abstract">
        <span class="descri"><xsl:value-of select="excerpt"/></span>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer' and contentTypes/contentType = 'org.ametys.plugins.workspaces.Content.member']" mode="image" priority="100">
        <div class="picture">
            <xsl:call-template name="user-profile-image">
                <xsl:with-param name="size">80</xsl:with-param>
                <xsl:with-param name="login" select="content/user/@login"/>
                <xsl:with-param name="population" select="content/user/@populationId"/>
                <xsl:with-param name="lang" select="content/@language"/>
                <xsl:with-param name="class">svg agent-svg</xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="image">
        <div class="picture">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="512px" height="513px" viewBox="0 0 512 513" version="1.1" class="svg replaced-svg">
                <title>article</title>
                <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g id="Desktop" transform="translate(0.000000, -478.000000)" fill="#f1f1f1" fill-rule="nonzero">
                        <g id="icons" transform="translate(0.000000, 43.105692)">
                            <g id="article" transform="translate(0.000000, 434.900123)">
                                <path d="M496,0 L112,0 C103.2,0 96,7.2 96,16 L96,96 L16,96 C7.2,96 0,103.2 0,112 L0,448 C0,483.3 28.7,512 64,512 L448,512 C483.4,512 512,483.4 512,448 L512,16 C512,7.2 504.8,0 496,0 Z M64,480 C46.4,480 32,465.6 32,448 L32,128 L384,128 C384,471.4 384,448.4 384.1,450.9 C384.6,461.4 387.6,471.3 392.6,480 L64,480 Z M480,448 C480,465.6 465.7,480 448,480 C430.4,480 416,465.6 416,448 L416,112 C416,103.2 408.8,96 400,96 L128,96 L128,32 L480,32 L480,448 Z" id="Shape"></path>
                                <path d="M344,152 L72,152 C63.2,152 56,159.2 56,168 L56,272 C56,280.8 63.2,288 72,288 L344,288 C352.8,288 360,280.8 360,272 L360,168 C360,159.2 352.8,152 344,152 Z M328,256 L88,256 L88,184 L328,184 L328,256 Z" id="Shape"></path>
                                <path d="M184,312 L72,312 C63.2,312 56,319.2 56,328 L56,440 C56,448.8 63.2,456 72,456 L184,456 C192.8,456 200,448.8 200,440 L200,328 C200,319.2 192.8,312 184,312 Z M168,424 L88,424 L88,344 L168,344 L168,424 Z" id="Shape"></path>
                                <path d="M344,312 L240,312 C231.2,312 224,319.2 224,328 C224,336.8 231.2,344 240,344 L344,344 C352.8,344 360,336.8 360,328 C360,319.2 352.8,312 344,312 Z" id="Path"></path>
                                <path d="M344,368 L240,368 C231.2,368 224,375.2 224,384 C224,392.8 231.2,400 240,400 L344,400 C352.8,400 360,392.8 360,384 C360,375.2 352.8,368 344,368 Z" id="Path"></path>
                                <path d="M344,424 L240,424 C231.2,424 224,431.2 224,440 C224,448.8 231.2,456 240,456 L344,456 C352.8,456 360,448.8 360,440 C360,431.2 352.8,424 344,424 Z" id="Path"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </svg>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="class-attribute">
        <xsl:text/>classic-item<xsl:text> </xsl:text>
    </xsl:template>
    <!-- // End page hits -->
    
</xsl:stylesheet>