<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<!-- + 
	     | MAIN ZONE
	     + -->
	<xsl:template name="main-zone">
		<a name="content"></a>
		<zone name="default" level="2"/>
	</xsl:template>

	<!-- + 
	     | BLOCK ZONES
	     + -->
	<xsl:template name="zone-1">
		<xsl:variable name="blockHeaderZoneTitle" select="/cms/page/pageContents/zone[@name='zone-1']/zoneItem[1]/html/head/title"/>
		<xsl:variable name="level">
			<xsl:choose>
				<xsl:when test="$blockHeaderZoneTitle != ''"><xsl:text>3</xsl:text></xsl:when>
				<xsl:otherwise><xsl:text>2</xsl:text></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<zone name="zone-1" level="{$level}"/>
	</xsl:template>

	<!-- + 
	     | INVISIBLE ZONES
	     + -->
	<xsl:template name="invisible-zone-sidebar1">
		<zone name="invisible-zone-sidebar1" level="2"/>
	</xsl:template>
	<xsl:template name="invisible-zone-sidebar2">
		<zone name="invisible-zone-sidebar2" level="2"/>
	</xsl:template>
</xsl:stylesheet>