<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver ametys i18n">

    <xsl:variable name="uri-prefix" select="ametys:uriPrefix()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    <xsl:variable name="siteUrl" select="ametys:siteParameter('url')"/>
    
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                
                <xsl:call-template name="welcome-head-css"/>
                <xsl:call-template name="welcome-head-title"/>
            </head>
            <body>
                <xsl:call-template name="welcome-body"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="welcome-head-title">
        <title>Help</title>
    </xsl:template>
    
    <xsl:template name="welcome-head-css">
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        
        <link type="text/css" href="{ametys:skinURL('welcome/scss/layout.css')}" rel="stylesheet" media="screen"/>
        <link type="text/css" href="{ametys:skinURL('welcome/scss/styles.css')}" rel="stylesheet" media="screen"/>
        <link type="text/css" href="{ametys:skinURL('welcome/scss/print.css')}" rel="stylesheet" media="print" />
    </xsl:template>
    
    <xsl:template name="welcome-body">
        
        <xsl:call-template name="welcome-body-frame"/>
        
        <xsl:call-template name="print"/>
        
        <xsl:call-template name="main-presentation"/>
        
        <xsl:call-template name="get-started"/>
        
        <xsl:call-template name="skin-presentation"/>                 
    </xsl:template>
    
    <xsl:template name="welcome-body-frame">
        <div class="frame">
            <xsl:call-template name="ametys-community"/>
        </div>
    </xsl:template>
    
    <xsl:template name="ametys-community">
        <h2>Community</h2>
        <p>Ametys is Open Source, you can see the documentation and contribute here:</p>
        <ul>
            <li><a target="_blank" href="http://www.ametys.org/forum">Ametys Forum</a></li>
            <li><a target="_blank" href="http://docs.ametys.org/">Ametys Documentations</a></li>
            <li><a target="_blank" href="https://issues.ametys.org/browse/CMS">Issues and enhancement tool</a></li>
        </ul>
        <p>Visit also the Ametys website <a target="_blank" href="http://www.ametys.org">www.ametys.org</a>.</p>
    </xsl:template>
    
    <xsl:template name="print">
        <div class="print">
            <a href="javascript:window.print()" title="Print"><i class="fas fa-print"/></a>
        </div>
    </xsl:template>
    
    <xsl:template name="main-presentation">
         <h1>Welcome to Ametys Intranet</h1>
         <p>
            You are in the contributor workspace of site <a target="_blank" href="{$siteUrl}"><b><xsl:value-of select="ametys:siteParameter('title')"/></b></a> using <b><xsl:value-of select="$skin"/></b> skin.
        </p>
    </xsl:template>
    
    <xsl:template name="get-started">
        <h1>Get started</h1>
        <p>
            Use the <b><i>Sitemap</i></b> tool on the left to create or alter page.
            <br />
            Click twice on a page to open it. 
        </p>
        
        <h1>Need help?</h1>
        <p>Use the "Search a feature" search bar of the ribbon.<br/>
        Use the online help by pressing the <strong>F1 key </strong>on hover of a button or tool, or by clicking on the link <strong>Know more</strong> of tooltips
        </p>
        
    </xsl:template> 
    
    <xsl:template name="skin-presentation">
        <h1>Templates</h1>
        <h2>Home</h2>
        
        <div class="flex">
            <img src="{$uri-prefix}/skins/{$skin}/templates/index/resources/thumbnail.png" alt="Home page"/>
            <div>
                <p>
                    The <i>home</i> template is only for the home page, named "index". <br/>
                    This template is composed of several blades.
                    Each blade can contain one or two search services (news carousel, documents, kiosks, job offers, classified ads, ...).<br/>
                </p>
                <p>
                    The other graphic elements that make up the home page are: 
                    <ul>
                        <li><strong>Quick access: </strong>links of the directory with the theme "Quick access"</li>
                        <li><strong>Top links: </strong> links of the directory with the theme "Home page"</li>
                    </ul>
                </p>
            </div>
        </div>
        
        <h2>Page</h2>
        <div class="flex">
            <img src="{$uri-prefix}/skins/{$skin}/templates/page/resources/thumbnail.png" alt="Page"/>
            <div>
                <p>The <i>page</i> template is used for the majority of other pages. <br/>
                It is composed of 2 central zones and 1 side zone.
                </p>
            </div>
        </div>
        
        <h1>Other graphic elements</h1>
        <h2>Header</h2>
        <p>The header banner is made up of:
            <ul>
                <li>notification links (directory links with the "Notification" theme)</li>
                <li>a search input</li>
                <li>navigation in main sections</li>
            </ul>
        </p>
        
        <h2>Footer</h2>
        <p>Footer links consist of pages tagged with a tag of the category <i>Special pages > Footer</i></p>
        
        <h1>Content types</h1>
                    
        <h2>Articles</h2>
        <p>You should use it for most pages: Overview, Contact, References ...</p>
        <h2>News</h2>
        <p>Use news content type for events: new products, news of any kind, events ..</p>
        
        <h2>FAQ</h2>
        <p>The content "FAQ" is used to present a "Frequently asked questions" (list of questions/answers)</p>
        <h2>Documents</h2>
        <p>Use document content types (PDF, audio, video, ...) to present documents and build kiosk, video gallery, ...</p>
    </xsl:template>
    
</xsl:stylesheet>
