<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2017 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
   <xsl:import href="plugin:link-directory://pages/services/directory/dynamic-info/default.xsl"/>
   <xsl:import href="plugin:cms://stylesheets/utils.xsl"/>
   
   <xsl:template match="dynamic-information[@id]">
        <dynamic-information id="{@id}">
            <xsl:if test="error">
                <xsl:attribute name="error"><xsl:value-of select="error/@type"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="short-value" />
            
            <xsl:if test="not(error)">
                <span class="dropdown" id="{concat('dynamic-information-', substring-after(@id, '://'))}">
                    <xsl:if test="short-value = '0'"><xsl:attribute name="class">dropdown empty</xsl:attribute></xsl:if>
                    <xsl:apply-templates select="long-value" />
                    <xsl:if test="tooltip/item">
                        <xsl:apply-templates select="tooltip" />
                    </xsl:if>
                </span>
            </xsl:if>
            
            <xsl:apply-templates select="error" />
        </dynamic-information>
    </xsl:template>
   
   
   <xsl:template match="short-value">
       <span class="link-info-short-value badge" aria-hidden="true" data-ametys-link-role="short-value">
           <xsl:apply-templates />
       </span>
       <span class="sr-only"><xsl:value-of select="../long-value"/></span>
   </xsl:template>
   
    <xsl:template match="summary">
        <span class="link-info-summary">
            <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="defaultText" select="."/>                
                <xsl:with-param name="maxDefaultTextSize" select="'110'"/>                
            </xsl:call-template> 
        </span>
    </xsl:template>
   
   <xsl:template match="error">
        <span class="link-info-error-message badge error" data-ametys-link-role="error">!</span>
        <span class="link-info-error-message dropdown" data-ametys-link-role="error" id="{concat('dynamic-information-', substring-after(../@id, '://'))}">
            <xsl:apply-templates />
        </span>
    </xsl:template>
    
</xsl:stylesheet>