<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
        
    <!-- The placeholder for fulltext search field -->
    <xsl:variable name="searchInputPlaceholder" select="ametys:serviceViewParameter('searchInputPlaceholder')"/>
    <!-- Prefix for "Full text" criteria -->
    <xsl:variable name="fulltextCriteriaPrefix">user.input.criterion.common$wording$textfield</xsl:variable>
    <!-- Prefix for  "Title or full text" criteria -->
    <xsl:variable name="titleOrFulltextCriteriaPrefix">user.input.criterion.common$titleorwording$textfield</xsl:variable>
    
	<xsl:template name="form-criteria">
    	<xsl:call-template name="js-sumit-bo"/>
    	
		<form method="post" role="search" class="searchForm" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
			<xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
			<xsl:call-template name="top-search-input"/>
			<xsl:call-template name="top-search-submit"/>
		</form>
    </xsl:template>
    
    <xsl:template name="form-criteria-hidden">
        <form hidden="hidden" data-ametys-search-role="form-criteria-hidden">
            <xsl:for-each select="/search/form/fields/criterion">
                <xsl:for-each select="/search/form/values/criterion[@name = current()/@name]">
                    <input type="hidden" name="{@name}" value="{.}"/>
                </xsl:for-each>
            </xsl:for-each>
        </form>
    </xsl:template>
    
    <xsl:template name="top-search-input">
        <xsl:for-each select="/search/form/fields/criterion">
        	<xsl:apply-templates select="." mode="field">
                <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field">
        <xsl:param name="value"/>
        
        <!-- The selected criterion will be replaced by a facet choice -->
        <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', @definition)"></xsl:value-of></xsl:variable>
            
        <xsl:variable name="options">
            <items>
                <xsl:for-each select="enumeration/item">
                    <xsl:sort select="label" />
                    
                    <xsl:variable name="itemValue" select="@value" />
                    <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                    <xsl:if test="$compute-counts = 'false' or $count">
                        <item value="{$itemValue}" id="{generate-id()}">
                            <xsl:if test="$count"><xsl:attribute name="count"><xsl:value-of select="$count" /></xsl:attribute></xsl:if>
                            <xsl:copy-of select="label" />
                        </item>
                    </xsl:if>
                 </xsl:for-each>
            </items>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($options)/items/item">
	        <div class="field field-select">
	            <xsl:apply-templates select="." mode="field-label"/>
	                
	            <xsl:apply-templates select="." mode="field-input">
	                <xsl:with-param name="value" select="$value"/>
	                <xsl:with-param name="options" select="exsl:node-set($options)"/>
	            </xsl:apply-templates>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="field search">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <!-- Override to allow placeholder -->
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" class="text">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="field-input-title"/>
        </input>
    </xsl:template>
    
    <xsl:template match="criterion[type = 'date' or type = 'datetime']" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}">
            <xsl:apply-templates select="." mode="field-input-placeholder"/>
            <xsl:apply-templates select="." mode="field-input-title"/>
        </input>
        <xsl:call-template name="criterion-date-script-js"/>
    </xsl:template>
    
    <!-- Override to add "Cancel selection" and "Today" buttons -->
    <xsl:template name="criterion-date-script-js">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <script type="text/javascript">
            (function(id)
            {
                var setCalsClearButton = function (year, month, elem) {
                  var afterShow = (function () {
                    var d = new $j.Deferred();
                    var cnt = 0;
                    setTimeout(function () {
                      if (elem.dpDiv[0].style.display === "block") {
                        d.resolve();
                      }
                      if (cnt >= 500) {
                        d.reject("datepicker show timeout");
                      }
                      cnt++;
                    }, 10);
                    return d.promise();
                  })();
        
                  afterShow.done(function () {
                    $j(".ui-datepicker").css("z-index", 2000);
        
                    var buttonPane = $j(elem)
                      .datepicker("widget")
                      .find(".ui-datepicker-buttonpane");
        
                    var btn = $j(
                      `&lt;button class="ui-datepicker-current ui-state-default ui-priority-primary clear-btn ui-corner-all" type="button"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DATEPICKER_CANCEL" i18n:catalogue="skin.{$skin}"/>&lt;/button>`
                    );
        
                    btn.off("click").on("click", function () {
                      $j(".ui-datepicker-calendar td").removeClass(
                        "ui-datepicker-current-day"
                      );
                      $j(".ui-datepicker-calendar td a").removeClass("ui-state-active");
                      $j.datepicker._clearDate(elem.input[0]);
                    });
        
                    btn.appendTo(buttonPane);
        
                    var btn2 = $j(
                      `&lt;button class="ui-datepicker-current ui-state-default ui-priority-primary validate-btn ui-corner-all" type="button"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DATEPICKER_TODAY" i18n:catalogue="skin.{$skin}"/>&lt;/button>`
                    );
        
                    btn2.off("click").on("click", function () {
                      ndp.datepicker("setDate", "0");
                    });
                    btn2.appendTo(buttonPane);
                    
                    var btn3 = $j(
                      `&lt;button class="ui-datepicker-current ui-state-default ui-priority-primary validate-btn ui-corner-all" type="button"><i18n:text i18n:key="SKIN_SERVICE_SEARCH_DATEPICKER_VALIDATE" i18n:catalogue="skin.{$skin}"/>&lt;/button>`
                    );
        
                    btn3.off("click").on("click", function () {
                      $j.datepicker._hideDatepicker();
                    });
        
                    //btn3.appendTo(buttonPane);
                  });
                };
        
                var odp = $j('#' + id);
                var ndp = odp.clone();
                ndp.attr('id', ndp.attr('id') + '-clone');
                ndp.attr('name', null);
                ndp.attr('value', '');
                ndp.attr('maxlength', '');
                ndp.keydown(function (event) {
                    if (event.which == 46 || event.which == 8) // del or backspace
                    {
                        ndp.datepicker("setDate", null);
                    }
                });
                
                var serverFormat = "yy-mm-dd";
                
                if (odp.attr("value") != "")
                {
                    $j(function () 
                    {
                        var existingDateAsString =  odp.attr("value") || '';
                        var existingDate = $j.datepicker.parseDate(serverFormat, existingDateAsString);
                        var reformatedDateAsString = $j.datepicker.formatDate('<i18n:text key="PLUGINS_WEB_FOWIDGET_DATE_FORMAT" i18n:catalogue="plugin.web"/>', existingDate); 
                        ndp.attr('value', reformatedDateAsString);
                    });
                }
                ndp.attr('readonly', 'readonly');
                ndp.appendTo(odp.parent());
                odp.css('visibility', 'hidden');
                odp.css('position', 'absolute');
                odp.css('top', '-1000px');
                odp.css('left', '-1000px');
                
                var opt = { 
                    dateFormat: '<i18n:text key="PLUGINS_WEB_FOWIDGET_DATE_FORMAT" i18n:catalogue="plugin.web"/>', 
                    altFormat: serverFormat, 
                    altField: '#' + id,
                    showButtonPanel: true,
                    beforeShow: function (inst, elem) {
                        setCalsClearButton(null, null, elem);
                    },
                    onSelect: function (dateText, inst, elem) {
                    },
                    onClose: function (date, inst) {
                      //Set inline to false => datapicker is closed
                      // onClose is called only if you click outside the datapicker, onSelect will not
                    },
                    onChangeMonthYear: setCalsClearButton
                };
                ndp.datepicker(opt);
            })("<xsl:value-of select="$id"/>");
        </script>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-placeholder">
        <xsl:choose>
            <xsl:when test="$searchInputPlaceholder != ''">
                <xsl:attribute name="placeholder"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="$searchInputPlaceholder"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_INPUT_PLACEHOLDER_LABEL</xsl:attribute>
                <xsl:attribute name="title">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_SEARCH_INPUT_PLACEHOLDER_LABEL</xsl:attribute>
                <xsl:attribute name="i18n:attr">placeholder title</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-input-title">
    </xsl:template>
    
    <!-- Default placeholder is criteria label -->
    <xsl:template match="criterion" mode="field-input-placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <!-- Default title is criteria label -->
    <xsl:template match="criterion" mode="field-input-title">
        <xsl:attribute name="title"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <select id="{$id}" name="{@name}" multiple="multiple">
            <xsl:apply-templates select="." mode="criterion-enumeration-select"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-all-option"/>
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
            
        </select>
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, $titleOrFulltextCriteriaPrefix) or starts-with(@name, $fulltextCriteriaPrefix)]" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label for="{$id}" class="sr-only">
            <xsl:choose>
                <xsl:when test="$searchInputPlaceholder != ''"><xsl:value-of select="$searchInputPlaceholder"/></xsl:when>
                <xsl:otherwise><i18n:text i18n:key="SKIN_SERVICE_SEARCH_INPUT_PLACEHOLDER_LABEL" i18n:catalogue="skin.{$skin}"/></xsl:otherwise>
            </xsl:choose>
        </label>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <label class="sr-only" for="{$id}"><xsl:value-of select="label"/></label>
    </xsl:template>
    
    <xsl:template name="top-search-submit">
        <div class="search-button">
		 <xsl:if test="/search/launch-search-at-startup = 'false' or count(/search/form/fields/criterion) > 0">
            <xsl:if test="/search/result-display-type = 'ON_PAGE'">
                <input type="hidden" name="submit-form">
                    <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                        <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
                    </xsl:if>
                </input>
            </xsl:if>
            
	       <button type="submit" class="btn">
	       		<xsl:attribute name="onclick" ><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
	            <i18n:text i18n:key="SKIN_SERVICE_SEARCH_FORM_SUBMIT" i18n:catalogue="skin.{$skin}"/>
	        </button>
        </xsl:if>
        </div>
    </xsl:template>
    
</xsl:stylesheet>