<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							  xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="job-offer.xsl"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">job-offer view-link</xsl:variable>    
    
    <!-- +
         | BODY
         + -->
    <!-- Empty title for link view--> 
        
    <!-- Used in common.xsl -->
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
    
    <xsl:variable name="page-id" select="//pages/page[ametys:pageId() != @id]/@id"/>
    
    		<xsl:if test="metadata/title"> 
        		<h3>
					<xsl:value-of select="metadata/title"/>
				</h3>
	        </xsl:if>
	        <xsl:if test="metadata/num_avis"> 
        		<p class="category_job">
					<i class="fa fa-hashtag"></i><xsl:value-of select="metadata/num_avis"/>
				</p>
	        </xsl:if>
	        
   			
            <p class="content-read-more">
            	<a href="{resolver:resolve('page', $page-id, false)}" class="url"><i18n:text i18n:key="CONTENT_VIEW_READMORE_JOB_OFFER" i18n:catalogue="plugin.job-offer"/></a>
            </p>
   			
    </xsl:template> 
    
</xsl:stylesheet>