<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                extension-element-prefixes="math ametys resolver escaper">
    
    <xsl:import href="plugin:user-directory://pages/services/user-signup/signup.xsl"/>
   
    <xsl:variable name="withTosContent" select="normalize-space($tos-mode) = 'CONTENT' and /user-signup/tos/content"/>
    <xsl:variable name="common-service-css-class-name">user-account user-signup<xsl:if test="$step = 'password'"> sign-up-2-1 sign-up-2-2</xsl:if><xsl:if test="$withTosContent"> sign-up-2-bis</xsl:if></xsl:variable>
    
    <xsl:template name="common-service-head-css">
        <!-- Signup Page Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('pages/signup/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('pages/signup/scss/print.css')}" />
        <xsl:if test="$tos-content-id != ''">
            <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        </xsl:if>
        <!-- END::Signup Page Styles -->
        
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('services/signup/scss/step-form.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="strong-password-head-js"/>
        
        <script src="{ametys:skinURL(concat('services/signup/js/step-form.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript">
             $j(document).ready(function() {
                var $input = $j('.user-signup form .field input');
                $input.each(function() {
                    var $this = $j(this),
                        label = $this.closest('.field').find('.label label').text();
                        
                    $this.attr('placeholder', label);
                })
                
                var $select = $j('.user-signup .select select');
                $select.each(function() {
                    var $this = $j(this),
                        $option = $this.children(),
                        label = $this.closest('.field').find('.label label').text();
                
                    $option.each(function () {
                        var $opt = $j(this),
                            text = $opt.text();
                        
                        if ($opt.val() === "") {
                            $opt.remove();
                        }
                        
                        $opt.attr('data-content', '&lt;span&gt;' + text + '&lt;/span&gt;');
                    });
                
                    $select.selectpicker({
                        width: '100%',
                        noneSelectedText: label,
                        liveSearch: true,
                        multipleSeparator: '',
                        size: 5.6,
                        selectedTextFormat: 'count > 3',
                        countSelectedText: "<i18n:text i18n:key="SKIN_SERVICE_SIGNUP_COUNT_SELECTED_TEXT" i18n:catalogue="skin.{$skin}"/>"
                    });
                
                });
             });
        </script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
        
        <xsl:call-template name="step-form-progress"/>
        
        <h1 class="service-title">
            <xsl:choose>
                <xsl:when test="$step = 'signup' and $status = 'success'"><i18n:text i18n:key="SKIN_SERVICE_SIGNUP_SUCCESS_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:when>
                <xsl:otherwise><xsl:copy-of select="$title"/></xsl:otherwise>
            </xsl:choose>
        </h1>
   </xsl:template>
   
   <xsl:template match="*" mode="contenttype-form-field-js">
        <!-- Neutralize default JS validation of input (handled by step-form.js) -->
   </xsl:template>
   
    <xsl:template name="step-form-progress">
        <xsl:if test="$step != 'signup'">
            <div id="progressStepForm" class="ametys-auth-steps" data-step="{$step}">
                <a data-to-step="#tempSignUp">
                    <xsl:if test="$step = '' or $step = 'temp-signup'"><xsl:attribute name="class">current</xsl:attribute></xsl:if>
                    <i></i>
                    <i18n:text i18n:key="SKIN_SERVICE_SIGNUP_DISPLAY_STEP1" i18n:catalogue="skin.{$skin}"/>
                </a>
                <a data-to-step="#signUp">
                    <xsl:if test="$step = 'password'"><xsl:attribute name="class">current</xsl:attribute></xsl:if>
                    <i></i>
                    <i18n:text i18n:key="SKIN_SERVICE_SIGNUP_DISPLAY_STEP2" i18n:catalogue="skin.{$skin}"/>
                </a>
                <xsl:if test="normalize-space($tos-mode) = 'CONTENT' and /user-signup/tos/content">
                    <a data-to-step="#stepFormTermsOfUse">
                        <xsl:if test="$step = 'signup'"><xsl:attribute name="class">current</xsl:attribute></xsl:if>
                        <i></i>
                        <i18n:text i18n:key="SKIN_SERVICE_SIGNUP_DISPLAY_STEP3" i18n:catalogue="skin.{$skin}"/>
                    </a>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="continue-signup-fields">
        <div id="signUp">
        	<div class="field-name-wrapper">
    	        <xsl:call-template name="firstname-field">
    	            <xsl:with-param name="value" select="/user-signup/@firstname"/>
    	        </xsl:call-template>
    	        <xsl:call-template name="lastname-field">
    	            <xsl:with-param name="value" select="/user-signup/@lastname"/>
    	        </xsl:call-template>
            </div>
            
            <xsl:call-template name="password-form-fields">
                <xsl:with-param name="uniqueId" select="$uniqueId"/>
                <xsl:with-param name="email" select="/user-signup/@email"/>
                <xsl:with-param name="token" select="/user-signup/@token"/>
                <xsl:with-param name="errors" select="/user-signup/errors"/>
            </xsl:call-template>
            
            <xsl:call-template name="user-fields"/>
            
            <xsl:if test="$withTosContent">
                <div class="button">
                    <input type="button" data-next-step="#stepFormTermsOfUse" i18n:attr="value" value="skin.{$skin}:SKIN_SERVICE_SIGNUP_NEXT" class="save" title=""/>
                </div>
            </xsl:if>
        </div>
        
        <div id="stepFormTermsOfUse">
            <xsl:if test="$withTosContent">
                <xsl:attribute name="style">display:none;</xsl:attribute>
                
                <xsl:call-template name="tos-title"/>
                
                <xsl:call-template name="tos-content">
                    <xsl:with-param name="tos-content-id" select="$tos-content-id"/>
                </xsl:call-template>
            </xsl:if>
            
            <xsl:if test="normalize-space($tos-mode) != 'NONE'">
                <xsl:call-template name="tos-field">
                    <xsl:with-param name="tos-mode" select="$tos-mode"/>
                    <xsl:with-param name="tos-page-id" select="$tos-page-id"/>
                    <xsl:with-param name="tos-link-label" select="$tos-link-label"/>
                </xsl:call-template>
            </xsl:if>
            
            <xsl:if test="$withTosContent">
                <script type="text/javascript">
                    // check terms of use
                    $j('.field.tos input[type=checkbox]').prop('checked', 'checked');
                </script>
                <div class="button precede-step">
                    <input type="button" data-precede-step="#signUp" i18n:attr="value" value="skin.{$skin}:SKIN_SERVICE_SIGNUP_PRECEDE" class="save" title=""/>
                </div>
            </xsl:if>
        </div>
        <script type="text/javascript">
            $j(".tos-content .ametys-cms-content").mCustomScrollbar();
        </script>
    </xsl:template>
    
    <xsl:template name="tos-title">
        <h1 class="service-title"><i18n:text i18n:key="SKIN_SERVICE_SIGNUP_CGU_TITLE" i18n:catalogue="skin.{$skin}"/></h1>
    </xsl:template>
    
    <xsl:template name="success-content">
        <xsl:param name="success-content-id"/>
        
        <div id="success-content-{$uniqueId}" class="success-content info">
            <xsl:apply-templates select="/user-signup/success/content/html/body/div/node()" mode="move-hierarchy">
                <xsl:with-param name="level" select="2"/>
            </xsl:apply-templates>
        </div>
                    
    </xsl:template>
    
</xsl:stylesheet>
