<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="docbook xlink html i18n resolver math">

    <xsl:import href="plugin:web://stylesheets/io/docbook2html.xsl" />
    
    <xsl:template match="docbook:para[contains(@class, 'code') or contains(@class, 'prettyprint')]|para[contains(@class, 'code') or contains(@class, 'prettyprint')]">
        
        <xsl:variable name="codeId" select="concat('code-', substring-after(math:random(), '.'))"/>
             
        <xsl:variable name="maxLines" select="10"/>
        <xsl:variable name="nbLines" select="count(docbook:phrase|phrase) + 1"/>
        

        <div class="inline-code-wrap"> 
            <xsl:variable name="codeCls">inline-code <xsl:if test="$nbLines &gt; $maxLines">inline-code--collapsed</xsl:if></xsl:variable>
            <pre id="{$codeId}" class="{$codeCls} {@class}">
                <xsl:if test="@class = 'prettyprintLinenums'"><xsl:attribute name="class"><xsl:value-of select="$codeCls"/> prettyprint linenums</xsl:attribute></xsl:if>
                <xsl:apply-templates select="child::node()" mode="code"/>
            </pre>
                        
            <!-- No formatting for copy -->
            <pre id="{$codeId}-for-copy" style="display: none">
                <xsl:apply-templates select="child::node()" mode="code"/>
            </pre>
            
            <xsl:if test="$nbLines &gt; $maxLines">
                <div class="inline-code--expand" onclick="openPrettyPrintDialog('{$codeId}')">
                    <button type="button">
                        <i class="fa fa-code"><span style="display: none">&#160;</span></i>
                        <i18n:text i18n:key="SKIN_CONTENT_SHOW_CODE" i18n:catalogue="skin.{$skin}"/>
                    </button>
                </div>
            </xsl:if>
            <div class="inline-code--actions">
                <button type="button" id="copy-{$codeId}" onclick="copyPrettyPrintButton('{$codeId}')" title="plugin.workspaces:PLUGINS_WORKSPACES_FORUM_PRETTYPRINT_COPY_CODE" i18n:attr="title">
                    <i class="fa fa-clone"><span style="display: none">&#160;</span></i>
                </button>
            </div>
            
            <xsl:if test="$nbLines &gt; $maxLines">
                <div class="inline-code-blur"><span style="display: none">&#160;</span></div>
            </xsl:if>
        </div>
                  
    </xsl:template>
  
    <xsl:template match="docbook:phrase[@role='linebreak']|phrase[@role='linebreak']" mode="code">
        <xsl:text>&#10;</xsl:text>
    </xsl:template>
    
    <xsl:template match="docbook:emphasis|emphasis" mode="code">
        <xsl:choose>
            <xsl:when test="@role='strong'">
                <strong><xsl:apply-templates mode="code"/></strong>
            </xsl:when>
            <xsl:otherwise>
                <em><xsl:apply-templates mode="code"/></em>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
