<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:variable name="displaySections" select="ametys:templateParameter('displaySections')" />
    <xsl:variable name="sections" select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]"/>
    <xsl:variable name="withSectionsMenu" select="$displaySections = 'true' and $sections"/>

    <xsl:template name="additionnal-css">
        <!-- edit tools styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/print.css')}" />
        <!-- End edit tools styles -->
        
        <xsl:if test="$withSectionsMenu">
        	<!-- custom control styles -->
			<link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/main.css')}" />
			<link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/print.css')}" />
			<!-- END::custom control styles -->
	
        	<!-- filter styles -->
			<link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/main.css')}" />
			<link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/print.css')}" />
			<!-- END::filter styles -->
            
            <!-- tab content -->
            <link rel="stylesheet" href="{ametys:skinURL('pages/tab-content/scss/main.css')}" />
            <link rel="stylesheet" href="{ametys:skinURL('pages/tab-content/scss/print.css')}" />
            <!-- END::tab content -->
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="start-callback">function() { $j('.front-edition-placeholder .ametys-front-edition-button').parents('.front-edition-placeholder').show(); }</xsl:with-param>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="main-content">
        <div class="container">
            <div class="ametys-main-content-wrap">
                <div class="ametys-main-content">
                    <xsl:choose>
                        <xsl:when test="$withSectionsMenu">
                            <div class="container">
                                <xsl:call-template name="sections"/>
                                <div class="ametys-main__inner">
                                    <zone name="default" level="1" />
                                </div>
                            </div>
                        </xsl:when>
                        <xsl:otherwise>
                            <div class="ametys-main__inner">
                                <xsl:call-template name="delete-btn"/>
                                <zone name="default" level="1" />
                            </div>       
                        </xsl:otherwise>
                    </xsl:choose>
                	
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner">
        <xsl:variable name="bgImg"><xsl:call-template name="main-banner-background-url"/></xsl:variable>
        
        <div class="ametys-main-banner ametys-main-banner--sm ametys-main-banner--clean" 
            style="background-image: url({$bgImg});">
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-background-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/bg.jpg')"/>
    </xsl:template>
    
    <xsl:template name="sections">
    	<xsl:if test="$displaySections = 'true' and $sections">
			<div id="categories_scroll" class="ametys-scroll-via-btn">
				<div class="ametys-filter-categories-wrap">
	                <ul class="ametys-filter-categories ametys-filter-categories--alt">
	                	<xsl:for-each select="$sections">
	                		<xsl:call-template name="section"/>
	                	</xsl:for-each>
	                </ul>
	            </div>
	            <button type="button" data-btn-right="data-btn-right">
					<i class="fas fa-angle-right"></i>
				</button>
				<button type="button" data-btn-left="data-btn-left">
					<i class="fas fa-angle-left"></i>
				</button>
	        </div>
			<script>
				var currentLeft,
						$target = $j('#categories_scroll .ametys-filter-categories-wrap');
				
				$j('#categories_scroll [data-btn-right]').on('click', function () {
					currentLeft = $target.scrollLeft();
					$target.stop()
							.animate({
								scrollLeft: currentLeft + 200
							}, 400);
				});
				
				$j('#categories_scroll [data-btn-left]').on('click', function () {
					currentLeft = $target.scrollLeft();
					$target.stop()
							.animate({
								scrollLeft: currentLeft - 200
							}, 400);
				});
			</script>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="section">
		<li>
	 		<a href="{resolver:resolve('page', @sitemap:id)}">
	 			<xsl:attribute name="class">
	 				<xsl:text>ametys-filter-categories-btn</xsl:text>
	 				<xsl:if test="@sitemap:in-path = 'true'"> active</xsl:if>
	 			</xsl:attribute>
	     		<xsl:choose>
	     			<xsl:when test="@PLUGIN_TAGS_WORKSPACES_STATISTICS"><i class="fas fa-chart-bar"/></xsl:when>
	     			<xsl:when test="@PLUGIN_TAGS_WORKSPACES_PREFERENCES"><i class="fas fa-cog"/></xsl:when>
	     			<xsl:when test="@PLUGIN_TAGS_WORKSPACES_HELP"><i class="fas fa-question-circle"/></xsl:when>
	     			<xsl:when test="@PLUGIN_TAGS_WORKSPACES_CONTACT"><i class="fas fa-envelope"/></xsl:when>
	     			<xsl:otherwise></xsl:otherwise>
	     		</xsl:choose>
	 		     <xsl:value-of select="@sitemap:title" />
	 		</a>
		</li>
	</xsl:template>
    
    <xsl:template name="delete-btn">
        <xsl:param name="mainContent" select="/cms/page/pageContents/zone[@name='default']/zoneItem[1]"/>
        <xsl:param name="cTypeId" select="$mainContent/information/type-information/@id"/>
        
        <xsl:if test="$cTypeId = 'org.ametys.plugins.workspaces.Content.catalogNews'">
            <xsl:call-template name="ametys-front-edition-insert-delete-page-button">
                <xsl:with-param name="page-id" select="ametys:pageId()"/>
                <xsl:with-param name="title-i18n" select="concat('skin.', $skin, ':SKIN_FO_DELETE_NEWS_BTN_TEXT')"/>
                <xsl:with-param name="class">ametys-edit-tools__delete</xsl:with-param>
                <xsl:with-param name="button-text"><span class="ametys-edit-tools__icon fas fa-trash-alt"></span></xsl:with-param>
                <xsl:with-param name="edition-mode-only" select="false()"/>
                <xsl:with-param name="callback">function() { window.location.href = "<xsl:value-of select="$site-uri-prefix"/>/<xsl:value-of select="$lang"/>/index.html"; }</xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>