<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:import href="skin://stylesheets/variables.xsl"/>
            
    <xsl:template name="edit-tools">
        <xsl:param name="rootPageId"/>
        <xsl:param name="contentPageId"/>
        <xsl:param name="addBtnI18nKey"/>
        <xsl:param name="addDialogI18nKey"/>
        <xsl:param name="contentTypeI18nKey"/>
        <xsl:param name="defaultTitleI18nKey"/>
        <xsl:param name="workflowInitActionId">14</xsl:param>
        <xsl:param name="contentTypeId"/>
        <xsl:param name="allowedTagProviders">[]</xsl:param><!-- Array of tags providers -->
        <xsl:param name="editBtnI18nKey"/>
        <xsl:param name="deleteBtnI18nKey"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and ametys-front-edition:hasFrontEditionRight()">
            <ul class="ametys-edit-tools">
                <!-- Add page with content -->
                <xsl:call-template name="add-content-button">
                    <xsl:with-param name="rootPageId" select="$rootPageId"/>
			        <xsl:with-param name="btnTitleI18n" select="$addBtnI18nKey"/>
			        <xsl:with-param name="dialogI18nKey" select="$addDialogI18nKey"/>
			        <xsl:with-param name="contentTypeI18nKey" select="$contentTypeI18nKey"/>
			        <xsl:with-param name="defaultTitleI18nKey" select="$defaultTitleI18nKey"/>
			        <xsl:with-param name="workflowInitActionId" select="$workflowInitActionId"/>
			        <xsl:with-param name="contentTypeId" select="$contentTypeId"/>
                    <xsl:with-param name="allowedTagProviders" select="$allowedTagProviders"/>
                </xsl:call-template>
                <!-- Edit content -->
                <xsl:call-template name="edit-content-button">
                    <xsl:with-param name="pageId" select="$contentPageId"/>    
                    <xsl:with-param name="btnI18nKey" select="$editBtnI18nKey"/>
                </xsl:call-template>
                <!-- Delete content -->
                <xsl:call-template name="delete-content-button">
                    <xsl:with-param name="pageId" select="$contentPageId"/>
                    <xsl:with-param name="btnI18nKey" select="$deleteBtnI18nKey"/>
                </xsl:call-template>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="add-content-button">
        <xsl:param name="rootPageId"/>
        <xsl:param name="btnTitleI18n"/>
        <xsl:param name="dialogI18nKey"/>
        <xsl:param name="contentTypeI18nKey"/>
        <xsl:param name="defaultTitleI18nKey"/>
        <xsl:param name="workflowInitActionId">14</xsl:param>
        <xsl:param name="contentTypeId"/>
        <xsl:param name="allowedTagProviders">[]</xsl:param>
                
        <li class="ametys-edit-tools__item">
            <xsl:choose>  
                <xsl:when test="$rootPageId and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Create', $rootPageId, false())">
                        <xsl:call-template name="ametys-front-edition-insert-create-page-button">
                            <xsl:with-param name="page-id" select="$rootPageId"/>
                            <xsl:with-param name="title-i18n"><xsl:value-of select="$btnTitleI18n"/></xsl:with-param>
                            <xsl:with-param name="button-text"><span class="ametys-edit-tools__icon fas fa-plus"></span></xsl:with-param>
                            <xsl:with-param name="edition-mode-only" select="false()"/>
                            <xsl:with-param name="class">ametys-edit-tools__link</xsl:with-param>
                            <xsl:with-param name="callback">function(page)
                                {
                                    var path = AmetysFrontEdition.CONTEXT_PATH + "/" + AmetysFrontEdition.LANG + "/" + page.getPath() + ".html";
                                    window.location.href = path;
                                }
                            </xsl:with-param>
                            <xsl:with-param name="config">{
                                "title": "<xsl:value-of select="ametys:escapeJS(ametys:translate($dialogI18nKey))"/>",
                                "force": true,
                                "workflowInitActionId": "<xsl:value-of select="$workflowInitActionId"/>",
                                "show-card-tags" : <xsl:value-of select="$allowedTagProviders"/>.length &gt; 0,
                                "pagecontent-card-tags-categories-filter": <xsl:value-of select="$allowedTagProviders"/>,
                                "pagecontent-card-tags-categories-filter-only-subcategories": false,
                                "show-card-content" : false, 
                                "show-card-content-properties" : false,
                                "show-card-type" : false,  
                                "default-pagetype" : "template",
                                "default-template" : "page",
                                "default-zone" : "default",
                                "default-pagecontent-type" : "contenttype",
                                "default-contenttype" :  "<xsl:value-of select="$contentTypeId"/>",
                                "default-page-title" : "<xsl:value-of select="ametys:escapeJS(ametys:translate($defaultTitleI18nKey))"/>",
                                "default-contenttype-label" : "<xsl:value-of select="ametys:escapeJS(ametys:translate($contentTypeI18nKey))"/>",
                                "pagecontent-service" : false}
                                </xsl:with-param>
                        </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <a class="ametys-edit-tools__link ametys-edit-tool-disabled" href="javascript:;">
                        <span class="ametys-edit-tools__icon fas fa-plus"></span>
                    </a>
                </xsl:otherwise>
            </xsl:choose>     
        </li>
    </xsl:template>
    
    <xsl:template name="edit-content-button">
        <xsl:param name="pageId"/>
        <xsl:param name="btnI18nKey"/>
        
        <li class="ametys-edit-tools__item">
            <xsl:choose>
                <xsl:when test="ametys-front-edition:hasFrontEditionRight('Workflow_Rights_Edition_Online', @id, false())">
                    <a class="ametys-edit-tools__link" href="{resolver:resolve('page', $pageId, false)}" i18n:attr="title" title="{$btnI18nKey}">
                        <span class="ametys-edit-tools__icon fas fa-pencil-alt"></span>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a class="ametys-edit-tools__link ametys-edit-tool-disabled" href="javascript:;"  i18n:attr="title" title="{$btnI18nKey}">
                        <span class="ametys-edit-tools__icon fas fa-pencil-alt"></span>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template name="delete-content-button">
        <xsl:param name="pageId"/>
        <xsl:param name="btnI18nKey"/>
        
        <li class="ametys-edit-tools__item">
            <xsl:choose>
                <xsl:when test="ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Delete', $page-id, false())">
                    <xsl:call-template name="ametys-front-edition-insert-delete-page-button">
                        <xsl:with-param name="page-id" select="$pageId"/>
                        <xsl:with-param name="title-i18n"><xsl:value-of select="$btnI18nKey"/></xsl:with-param>
                        <xsl:with-param name="class">ametys-edit-tools__link</xsl:with-param>
                        <xsl:with-param name="button-text"><span class="ametys-edit-tools__icon fas fa-trash-alt"></span></xsl:with-param>
                        <xsl:with-param name="edition-mode-only" select="false()"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <a class="ametys-edit-tools__link ametys-edit-tool-disabled" href="javascript:;" i18n:attr="title" title="{$btnI18nKey}">
                        <span class="ametys-edit-tools__icon fas fa-trash-alt"></span>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
</xsl:stylesheet>