<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:exslt="http://exslt.org/common"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="ametys escape math user resolver exslt">
                
    <xsl:import href="plugin:workspaces://pages/services/members/members-summary.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    
    <xsl:template name="common-service-head-css">
        <!-- Members styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/membres/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/membres/scss/print.css')}" />
        <!-- END::Members styles -->
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    	
    
    <xsl:template name="common-service-body-nonempty-content-content">
      <div class="ametys-sidebar-section">
      	<xsl:call-template name="members-title" />
      
        <xsl:call-template name="managers" />
        <xsl:call-template name="members" />
      </div>
    </xsl:template>
    
    <xsl:template name="managers">
        <xsl:if test="/project/member[@manager = 'true']">
            <xsl:apply-templates select="/project/member[@manager = 'true' and @managerPosition = 1]/user" mode="manager"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="members-title">
    	<h2 class="ametys-sidebar-section__title">
    		<xsl:value-of select="$header"/>
    	</h2>
    </xsl:template>
    
    
    <xsl:template match="user" mode="manager">
        <xsl:variable name="rawUser">
            <xsl:call-template name="user-info">
                <xsl:with-param name="login" select="info/@login"/>
                <xsl:with-param name="population" select="info/@population"/>
                <xsl:with-param name="imgWidth">73</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="user" select="exslt:node-set($rawUser)"/>
        
        <xsl:variable name="userPage" select="resolver:resolve('page', $user/user/pageId)"/>
        
        <xsl:choose>
            <xsl:when test="$userPage != ''">
                <a href="{$userPage}" class="ametys-membres">
                    <xsl:call-template name="member-avatar">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="member-title">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="member-subtitle">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <div class="ametys-membres">
                    <xsl:call-template name="member-avatar">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="member-title">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="member-subtitle">
                        <xsl:with-param name="user" select="$user"/>
                    </xsl:call-template>
                </div>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="member-avatar">
	    <xsl:param name="user"/>
	    
		<div class="ametys-membres-avatar">
			<img src="{$user/user/imgUrl}" alt="" title="{$user/user/fullname}"/>
			<span class="ametys-membres-avatar__icon">
				<i class="fas fa-sun"></i>
			</span>
		</div>
    </xsl:template>
    
    <xsl:template name="member-subtitle">
	    <xsl:param name="user"/>
    
        <xsl:variable name="role" select="$user/user/role"/>
        <xsl:variable name="organisationAccronym" select="$user/user/organisationAccronym"/>
        
    	<xsl:if test="$role != '' or $organisationAccronym != ''">
             <div class="ametys-membres-bottom">
                 <span class="ametys-membres__role ametys-truncate-1" data-ametys-tooltip="{$role}"><xsl:value-of select="$role"/></span>
                 <xsl:if test="$organisationAccronym != ''">
                     <xsl:if test="$role != ''"><xsl:text> - </xsl:text></xsl:if>
                     <span class="ametys-membres__tag ametys-truncate-1" >
                       <span>
                           <xsl:if test="$user/user/organisation != ''">
	                           <xsl:attribute name="data-ametys-tooltip">
	                               <xsl:value-of select="$user/user/organisation"/>
	                           </xsl:attribute>
       	                   </xsl:if>
                           <xsl:value-of select="$organisationAccronym"/>
                       </span>
                     </span>
                 </xsl:if>
             </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="member-title">
	    <xsl:param name="user"/>
    
    	<h3 class="ametys-membres__title"><xsl:value-of select="$user/user/fullname" /></h3>
    </xsl:template>
    
    <xsl:template name="members-divider">
        <hr class="ametys-membres__divider" />
    </xsl:template>
    
    <xsl:template name="members">
        <xsl:if test="/project/member[@manager != 'true'] or /project/member[@manager = 'true' and @managerPosition > 1]">
            <xsl:call-template name="members-divider" />
            
            <div class="ametys-membres-list-wrap">
                <ul class="ametys-membres-list">
                    <xsl:apply-templates select="/project/member[@manager = 'true' and @managerPosition > 1]"/>
                    <xsl:apply-templates select="/project/member[@manager != 'true']"/>
            	</ul>
            	
            	<xsl:call-template name="members-page"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="member">
    	<xsl:if test="position() &lt;= 6">
    		<li>
	        	<xsl:apply-templates select="user"/>
	        </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="user">
        <xsl:call-template name="user-image"/>
    </xsl:template>
    
    <xsl:template name="user-image">
        <xsl:variable name="rawUser">
            <xsl:call-template name="user-info">
                <xsl:with-param name="login" select="info/@login"/>
                <xsl:with-param name="population" select="info/@population"/>
                <xsl:with-param name="imgWidth">36</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="user" select="exslt:node-set($rawUser)"/>
        
        <xsl:variable name="userPage" select="resolver:resolve('page', $user/user/pageId)"/>
        <xsl:choose>
            <xsl:when test="$userPage != ''">
                <a href="{$userPage}">
                    <img src="{$user/user/imgUrl}" alt="" title="{$user/user/fullname}"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <img src="{$user/user/imgUrl}" alt="" title="{$user/user/fullname}"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="members-page">
        <xsl:choose>
            <xsl:when test="/project/@memberPageId">
                <a class="ametys-membres_link" href="{resolver:resolve('page', /project/@memberPageId)}"><xsl:call-template name="nb-members" /></a>
            </xsl:when>
            <xsl:otherwise>
                <span class="ametys-membres_link"><xsl:call-template name="nb-members" /></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>