<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:exslt="http://exslt.org/common"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
        xmlns:math="http://exslt.org/math" 
        exclude-result-prefixes="ametys resolver exslt sitemap project math">
    
    <xsl:import href="plugin:web://pages/services/search/search-more-results.xsl"/>  
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">wall-content</xsl:variable>
    <xsl:variable name="common-service-name">wall-content</xsl:variable>
    
    <xsl:variable name="callback-function">onLoadResults</xsl:variable>
    
    <xsl:variable name="formUniqueId" select="concat('publish_wall_content_', substring-after(math:random(), '.'))"/>
    <xsl:variable name="uploadFormUniqueId" select="concat('upload_form_', substring-after(math:random(), '.'))"/>
    
    <xsl:template name="common-service-head-css">
        <!-- publier styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/publier-add/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/publier-add/scss/print.css')}" />
        <!-- END::publier styles -->
        
        <!-- comment styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/comment/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/comment/scss/print.css')}" />
        <!-- END::comment styles -->
        
        <!-- Fancy box for zoomable image -->
        <link rel="stylesheet" href="{ametys:skinURL('plugins/fancybox/jquery.fancybox.css')}"/>
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
    
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/WallContent.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/linkify/linkify.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/linkify/linkify-html.js')}"></script>
        
        <!-- Fancy box for zoomable image -->
        <script src="{ametys:skinURL('plugins/fancybox/jquery.fancybox.js')}"></script>
        <script type="text/javascript">
          $j(document).on('ready', function () {
            handleZoomableImages();
            setInterval(updateMomentDates, 60000);
          });
          
          function updateMomentDates()
          {
            $j(".search-results .ametys-comment__top span[data-momentdate]").each(function() {
                let date = $j(this).data('momentdate');
                $j(this).html(AmetysFront.Utils.toRelativeDate(date, {withTime: true}));
            });
          }
          
          function handleZoomableImages()
          {
             $j('.ametys-cms-service.wall-content [data-ametys-search-role=hits] .js-fancybox').fancybox();
          }
          
          function linkifyComments()
          {
             // Find links in comments and convert them to HTML links
             const options = { defaultProtocol: "https" }
             $j('[data-comment-content]').each(function (i, para){
                $j(para).html(linkifyHtml($j(para).html(), options));
             })
          }
          
          // Function to call when loading wall contents (at start or on show more)
          function onLoadResults()
          {
             handleZoomableImages();
             linkifyComments();
          }
        </script>
        
        <script type="text/javascript">
            // Function to refresh wall after new post
            function refresh() {
                var resultsEl = $j('.ametys-cms-service.wall-content [data-ametys-search-role=hits], .ametys-cms-service.wall-content [data-ametys-search-role=no-result]');
                (function () { <xsl:call-template name="search-js-submit-button"/> }).apply(resultsEl[0])
                
                handleZoomableImages();
            }
            
            WallContent.refresh = refresh;
        </script>
        
        

    </xsl:template>
    
    <xsl:template name="search-service-head-js">
        <!-- Always need the js to refresh after submission of a new wall content -->
        <script src="{$uri-prefix}/plugins/web/resources/js/search/SearchService.{ametys:lang()}.js" type="text/javascript"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="noscript"/>
        
        <xsl:call-template name="add-wallcontent-form"/>
    
        <xsl:call-template name="form-criteria"/>
        
        <xsl:call-template name="search-results"/>

        <xsl:call-template name="link"/>
    </xsl:template>
    
    <xsl:template name="hits">
        <div class="ametys-main-content__comments" data-ametys-search-role="hits">
            <xsl:apply-templates select="/search/hits/hit"/>
        </div>
    </xsl:template>
    
    <xsl:template name="add-wallcontent-form">
        <div class="ametys-add-publier ametys-mb-25" tabindex="-1">
            <form id="{$formUniqueId}" method="post" onsubmit="return false">
                <div class="ametys-add-publier__top">
                    <div class="ametys-add-publier__top_img ametys-add-publier__top-imgno">
                        <img class="rounded-circle" alt=""/>
                    </div>
                    <div class="ametys-add-publier__top_input">
                        <textarea
                                autocomplete="off"
                                name="content"
                                i18n:attr="placeholder"
                                placeholder="plugin.workspaces:PLUGINS_WORKSPACES_WALL_CONTENT_PUBLISH_PLACEHOLDER"/>
                                
                        <!-- <xsl:call-template name="mentions"/> -->
                    </div>
                    <button class="ametys-add-publier__top-btn disabled" id="publierBtnHd" disabled="disabled">
                        <i class="icon-send-icon"></i>
                        <i class="fas fa-spinner"></i>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_PUBLISH_BTN" i18n:catalogue="plugin.workspaces"/>
                    </button>
                    <script type="text/javascript">
                        $j('.ametys-add-publier__top_img img').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/user-directory/user/' + ametysUser.populationId + '/' + encodeURIComponent(ametysUser.login) + '/image_50?lang=<xsl:value-of select="$lang"/>');
                    </script>
                </div>
                
                <!-- Image preview -->
                <div class="ametys-add-publier__fitcher d-none">
    				<div id="publier_picked_files_list" class="ametys-add-publier__fitcher__list"></div>
    			</div>
                
                <div class="ametys-add-publier__bottom d-none">
                    <div class="ametys-add-publier_chips-list">
                        <!-- <xsl:call-template name="add-file"/> -->
                        <xsl:call-template name="add-image"/>
                    </div>
                    <button class="ametys-add-publier__top-btn disabled" onclick="return WallContent.publish(this);" disabled="disabled">
                        <i class="icon-send-icon"></i>
                        <i class="fas fa-spinner"></i>
                        <i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_PUBLISH_BTN" i18n:catalogue="plugin.workspaces"/>
                    </button>
                </div>
            </form>
        </div>
        <script type="text/javascript">
            $j('.ametys-add-publier textarea').on('keyup', function() {
              if($j(this).val()) {
                $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').prop("disabled", false);
                $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').removeClass("disabled");
              } else if (!$j('.ametys-add-publier .ametys-pick-img__control').val()) {
                $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').prop("disabled", true);
                $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').addClass("disabled");
              }
            });
            
            $j('.ametys-add-publier .ametys-pick-img__control').on('change', function() {
                if ($j(this).val()) {
                   $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').prop("disabled", false);
                   $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').removeClass("disabled");
                } else if (!$j('.ametys-add-publier textarea').val()){
                    $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').prop("disabled", true);
                    $j('.ametys-add-publier__bottom .ametys-add-publier__top-btn').addClass("disabled");
                }
            });
        </script>
    </xsl:template>
    
    <xsl:template name="add-file">
        <span class="ametys-add-publier_chips active">
            <i class="fas fa-file"></i>
            Fichier
        </span>
    </xsl:template>
    
    <xsl:template name="add-image">
        <label class="ametys-add-publier_chips ametys-add-publier_chips--excluded ametys-pick-img"
               data-pick-image-insert-target="#publier_picked_files_list"
               data-pick-image-single-only="">
            <i class="fas fa-image ametys-pick-img__icon-default"></i>
            <i class="fas fa-trash ametys-pick-img__icon-remove ametys-pick-img__remove"></i>
            <span class="ametys-pick-img__text-default"><i18n:text i18n:key="SKIN_WALL_ADD_IMAGE" i18n:catalogue="skin.{$skin}"/></span>
            <span class="ametys-pick-img__text-remove ametys-pick-img__name"><i18n:text i18n:key="SKIN_WALL_DELETE_IMAGE" i18n:catalogue="skin.{$skin}"/></span>
            <input class="ametys-pick-img__control" name="file" type="file"/>
        </label>
    </xsl:template>
    
    <!-- +
         | Template for list persons to mention on @
         | TODO Not used
         + -->
    <xsl:template name="mentions">
        <div class="ametys-add-publier_membres d-none">
            <ul class="ametys-add-publier_membres__list">
                <li>
                    <div class="ametys-add-publier_membres__list_img">
                        <img src="./resources/templates/common/img/img10.jpg" alt="Image description" />
                    </div>
                    <span class="ametys-add-publier_membres__list_name">Céline Baccoulla</span>
                </li>
                <li>
                    <div class="ametys-add-publier_membres__list_img">
                        <img src="./resources/templates/common/img/img10.jpg" alt="Image description" />
                    </div>
                    <span class="ametys-add-publier_membres__list_name">Céline Baccoulla</span>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-main-content__comments<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="pagination-more-results">
        <xsl:if test="/search/pagination/@total > 1">
            <div class="ametys-loadmore" data-ametys-search-role="show-more">
                <xsl:attribute name="onclick"><xsl:call-template name="search-js-next-page"/></xsl:attribute>
                <div>
                    <i class="fas fa-sync" title="plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_MORE_RESULTS" i18n:attr="title"></i>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- Template for no result -->
    <xsl:template name="no-result">
        <div class="no-result" data-ametys-search-role="no-result">
            <!-- TODO ? -->
        </div>
    </xsl:template>
</xsl:stylesheet>