<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		extension-element-prefixes="ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
	
    <xsl:template name="common-css">
        <!-- Note This is where you can other meta, script or link ; and also a title tag -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/vendor/font-poppins/font-poppins.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/vendor/font-materialicons/stylesheet.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/ametys-font/style.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/animate.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.min.css')}" />
        
        <!-- Vendors Styles-->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/malihu-scrollbar/jquery.mCustomScrollbar.css')}" />
        
        <!-- Richtext Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <!-- END::Richtext Styles -->
        
        <!-- Main Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/print.css')}" />
        <!-- End Main Styles -->
        
        <!-- Login Page Styles -->
		<link rel="stylesheet" href="{ametys:skinURL('pages/auth/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('pages/auth/scss/print.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('pages/login/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('pages/login/scss/print.css')}" />
        <!-- END::Login Page Styles -->
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <!-- Vendors JS -->
        <script src="{ametys:skinURL('templates/common/js/popper.min.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.min.js')}"></script>
    </xsl:template>
    
    <xsl:template name="body">
        <body>
            <main class="ametys-main ametys-auth-page">
                <div class="ametys-auth">
                    <xsl:call-template name="main-banner"/>
                    <xsl:call-template name="main-content"/>
                </div>
            </main>
            
            <xsl:call-template name="footer"/>
        </body>
    </xsl:template>
    
    <xsl:template name="main-banner">
        <div class="ametys-auth-header">
            <xsl:call-template name="header-main-logo"/>
        </div>
    </xsl:template>

    <xsl:template name="main-content">
        <div class="ametys-auth-body">
            <div class="container">
                <div class="row align-items-center mx-n5">
        			<xsl:call-template name="main-content-right"/>
                    <xsl:call-template name="main-content-left"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-content-right">
        <div class="col-lg-6 px-5 mb-4 mb-lg-0">
            <div class="ametys-auth-content ametys-richtext">
                <xsl:choose>
                    <xsl:when test="/cms/inputData/Model/login-content/content">
                        <xsl:for-each select="cms/inputData/Model/login-content/content">
                            <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                                <xsl:with-param name="level" select="1"/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="signup-link"/>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="main-content-left">
        <div class="col-lg-6 px-5">
            <zone name="default" level="1" />
        </div>
    </xsl:template>
    
    <xsl:template name="header-main-logo">
        <a class="ametys-auth-logo" href="{$site-uri-prefix}/{$lang}/index.html">
            <img src="{ametys:skinURL('templates/common/img/logo-white.png')}" alt="Ametys" />
        </a>
    </xsl:template>
    
	<xsl:template name="signup-link">
		<xsl:variable name="public-signup" select="ametys:requestParameter('publicSignup')"/>
        <xsl:variable name="signup-page" select="ametys:requestParameter('signup-page')"/>
		
		<xsl:if test="$public-signup = 'true' and $signup-page != ''">
            <h2><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_NO_ACCOUNT" i18n:catalogue="plugin.web"/></h2>
        	
        	<p>
        	   <i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_PUBLIC_SIGNUP" i18n:catalogue="plugin.web"/>
        	   <a href="{resolver:resolve('page', $signup-page)}"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_PUBLIC_SIGNUP_LINK" i18n:catalogue="plugin.web"/></a>
        	</p>
	    </xsl:if>
	</xsl:template>
    
</xsl:stylesheet>