<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
	
    <xsl:import href="plugin:forms://pages/services/display/mini-survey.xsl"/> 	
    
    <xsl:variable name="chart-width">250</xsl:variable>     
    <xsl:variable name="chart-height">250</xsl:variable>     
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/mini-survey/scss/main.css')}"/>  
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/mini-survey/scss/print.css')}"/> 
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="head-scripts"/>
        <xsl:call-template name="mini-survey-js"/>
        <xsl:call-template name="input-radio-script"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="mini-survey-bo-link"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>     
        </div>
    </xsl:template>
    
    <xsl:template name="mini-survey-bo-link">
        <xsl:if test="project:canAccessBO()">
            <a class="mini-survey__toplink" href="{concat(ametys:config('cms.url'), '/', $site, '/index.html')}" target="_blank">
                <i class="icon-logo_ametys_small"></i>
                <i18n:text i18n:key="SKIN_MINI_SURVEY_ACCESS_BO" i18n:catalogue="skin.{$skin}"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <!-- Override to change button's label -->
    
    <xsl:template name="submit-button-js-front">
        <xsl:param name="pos" />
        <xsl:param name="formId" />
        
        <xsl:call-template name="common-utils-jswrite-input-submit">
            <xsl:with-param name="class-name">submit</xsl:with-param>
            <xsl:with-param name="i18nkey">skin.workspace-project:SKIN_MINI_SURVEY_SUBMIT_BTN</xsl:with-param>
            <xsl:with-param name="onclick">try { MiniSurveyHelper.submitForm('<xsl:value-of select="$formId" />', '<xsl:value-of select="$uniqueId" />'); } catch(e) {} return false;</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="chart-legend-color">#FFFFFF</xsl:template>
    <xsl:template name="chart-legend-font-family">Poppins Light, sans-serif</xsl:template>
    
    <xsl:template name="input-radio-script">
        <script>
            $j(document).ready(function () {
              $j('.mini-survey input[type="radio"]').on('change',
                function () {
                  $j(".mini-survey .field-radio .label").removeClass("active");
                  $j(this)
                    .closest(".field-radio")
                    .find(".label")
                    .addClass("active");
                }
              );
              
              $j('.mini-survey input[type="checkbox"]').on('change',
                function () {
                    let $label = $j(this).closest(".field-checkbox").find(".label")
                    if ($j(this).is(':checked'))
                    {
                        $label.addClass("active");
                    }
                    else
                    {
                        $label.removeClass("active");
                    }
                  
                }
              );

              // Display number of votes
              $j(".mini-survey__votes").each(function () {
                $j(this).insertBefore(
                  $j(this)
                    .closest(".mini-survey")
                    .find(".buttons")
                );
              });
            });
          </script>
    </xsl:template>
</xsl:stylesheet>		
