<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:math="http://exslt.org/math" 
                extension-element-prefixes="ametys math exslt">
    
    <xsl:import href="plugin:web://pages/comments/helper/comments_4.8.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <!-- Order comments in descending order (recent first) -->
    <xsl:variable name="sortCommentsAsc">false</xsl:variable>
    <xsl:variable name="loadCommentsCallback">loadCommentsCb_<xsl:value-of select="$uniqueId"/></xsl:variable>
    
    <xsl:template name="comments">
        <xsl:call-template name="comments-inner"/>
        <xsl:call-template name="content-comment-template-script"/>
        
        <xsl:call-template name="content-comments-js"/>
        <xsl:call-template name="comments-additional-js"/>
    </xsl:template>
    
    <xsl:template name="comments-inner">
        <div class="ametys-comment__bottom" id="content-comments-wrapper-{$uniqueId}" data-ametys-comments-wrapper="{@id}">
            <xsl:call-template name="comments-header"/>
            
            <xsl:call-template name="comment-form"/>
            
            <div id="content-comments-{$uniqueId}" data-ametys-comments="{@id}">
                <!-- Comments will be inserted here -->
            </div>
            
            <!-- Show/hide more comments -->
            <div class="ametys-comment__bottom__list_footer" data-show-other-comments="true" style="display: none">
                <span class="ametys-comments-show"><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_SHOW_COMMENTS" i18n:catalogue="plugin.workspaces"/></span>
                <span class="ametys-comments-hide d-none"><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_HIDE_COMMENTS" i18n:catalogue="plugin.workspaces"/></span>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="comments-additional-js">
        <script type="text/javascript">
            // Callback after loading comments
            function loadCommentsCb_<xsl:value-of select="$uniqueId"/>(comments, contentId)
            {
                let nbComments = comments.length;
                let $wrapper = $j('#content-comments-wrapper-<xsl:value-of select="$uniqueId"/>');
                
                // Update nb comments text in whole content
                updateNbCommentsText_<xsl:value-of select="$uniqueId"/>();
                
                if (nbComments &gt; 0)
                {
                    $wrapper.find('[data-comments-header]').show();
                    
                    // Show first comment only
                    $wrapper.find('[data-ametys-is-comment]').first().show();
                    
                    if (nbComments > 1)
                    {
                        let $showOthers = $wrapper.find('[data-show-other-comments]');
                        $showOthers.show();
                    }
                }
            }
            
            function updateNbCommentsText_<xsl:value-of select="$uniqueId"/>(results, args)
            {
                let $wrapper = $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"]');
                let $nbCommentsText = $wrapper.closest('.ametys-cms-content').find('[data-ametys-nb-comments-text]');
                let $nbComments = $wrapper.find('[data-ametys-nb-comments]');
                let nbComments = $wrapper.find('[data-ametys-comments] > [data-ametys-is-comment]').length;
                
                if (nbComments == 0)
                {   
                    $wrapper.find('[data-comments-header]').hide();
                }
                else
                {
                    $wrapper.find('[data-comments-header]').show();
                }
                
                if (nbComments &gt; 1)
                {   
                    $nbCommentsText.html("<i18n:text i18n:key="SKIN_CONTENT_HEADER_COMMENTS" i18n:catalogue="skin.{$skin}"/>");
                }
                else
                {
                    $nbCommentsText.html("<i18n:text i18n:key="SKIN_CONTENT_HEADER_COMMENT" i18n:catalogue="skin.{$skin}"/>");
                }
            }
            
            function updateRelativeDates_<xsl:value-of select="$uniqueId"/>()
            {
                let $wrapper = $j('[data-ametys-comments-wrapper="<xsl:value-of select="@id"/>"]');
                $wrapper.find("span[data-momentdate]").each(function() {
                    let date = $j(this).data('momentdate');
                    $j(this).html(AmetysFront.Utils.toRelativeDate(date, {withTime: true}));
                });
            }
            
            // Update bootstrap tooltip for likers
            function updateCommentLikersTooltip_<xsl:value-of select="$uniqueId"/>(el)
            {
                let likers = el.attr('data-ametys-comment-likers') || "[]";
                let maxNbLikers = 5;
                try
                {
                    likers = JSON.parse(likers.replace(/&amp;quot;/g, '"'));
                    if (likers.length &gt; 0)
                    {
                        let tooltip = "";
                        $j.each(likers, function(i, liker) {
                            if (i &lt; maxNbLikers)
                            {
                                tooltip += "&lt;span class='like'>" + (liker.fullname || "<i18n:text i18n:key="PLUGINS_CORE_USERS_UNKNOWN_USER" i18n:catalogue="plugin.core"/>")+ "&lt;/span>"
                            }
                        });
                        
                        let nbLikers = likers.length;
                        let otherCount = nbLikers - maxNbLikers;
                        if (otherCount == 1)
                        {
                            tooltip += "&lt;span class='like'><i18n:text i18n:key="SKIN_CONTENT_LIKE_OTHER_TOOLTIP" i18n:catalogue="skin.{$skin}"/>&lt;/span>"
                        }
                        else if (otherCount &gt; 1)
                        {
                            tooltip += "&lt;span>" + "<i18n:text i18n:key="SKIN_CONTENT_LIKE_OTHERS_TOOLTIP" i18n:catalogue="skin.{$skin}"/>".replace(/\{0}/, otherCount) + "&lt;/span>";
                        }

                        el.attr('data-ametys-tooltip', tooltip);
                    }
                    else
                    {   
                        el.removeAttr('data-ametys-tooltip');
                    }
                }
                catch(e) 
                {
                    console.error("Unable to parse likers : " + likers, e);
                }
            }
            
            // Callback after like/unlike comment
            function likeOrUnlikeCommentCb_<xsl:value-of select="$uniqueId"/>(result, args) 
            {
                var voteIcon = $j(args.btn).find('i');
                if (result.liked)
                {
                    $j(args.btn).addClass('active');
                    voteIcon.addClass('fas');
                    voteIcon.removeClass('far');
                    //$j(args.btn).attr('title', "<i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_UNLIKE" i18n:catalogue="plugin.workspaces"/>");
                }
                else
                {
                    $j(args.btn).removeClass('active');
                    voteIcon.addClass('far');
                    voteIcon.removeClass('fas');
                    //$j(args.btn).attr('title', "<i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_LIKE" i18n:catalogue="plugin.workspaces"/>");
                }
                
                // Update likers and tooltip
                updateCommentLikersTooltip_<xsl:value-of select="$uniqueId"/>($j(args.btn));
            }
            
            // Show/hide answer form
            function toggleAnswerForm_<xsl:value-of select="$uniqueId"/>(btn) 
            {
                var $form = $j(btn).parent().parent().find('.ametys-comment-repodre-block');
                $form.slideToggle();
                
                if ($form.is(':visible'))
                {
                    $j(btn).attr("aria-expanded", true);
                    $form.find("textarea[name=text]").trigger('focus');
                }
                else
                {
                    $j(btn).attr("aria-expanded", false);
                }
            }
            
            // Function to execute for each comment after insertion
            function onCommentInsertion_<xsl:value-of select="$uniqueId"/>(comment)
            {
                // Fill form inputs
                comment.find('input[name=name]').val(ametysUser.fullname);
                comment.find('input[name=email]').val(ametysUser.email);
                
                let commentContent = comment.find(" >.ametys-comment__bottom__list_cmt > .ametys-single-comment");
                
                // Display function and organisation if not empty
                let authorFunction = commentContent.find('.ametys-comment__top_data .ametys-comment__top_data_1__charge');
                if (authorFunction.html() != '')
                {
                    authorFunction.show();
                }
                
                let authorOrganiztion = commentContent.find('.ametys-comment__top_data .ametys-tag');
                if (authorOrganiztion.html() != '')
                {
                    authorOrganiztion.show();
                }
                
                // Transform to moment date
                commentContent.find('[data-momentdate]').each(function() {
                    let date = $j(this).data('momentdate');
                    $j(this).html(AmetysFront.Utils.toRelativeDate(date, {withTime: true}));
                });
                
                // Active comment action menu
                commentContent.find(".ametys-more").on('click', function () {
                    $j(this).toggleClass('active');
                });
                
                let commentBottom = comment.find(" >.ametys-comment__bottom__list_cmt > .ametys-comment-vote");
                
                // Active vote icons
                commentBottom.find('[data-ametys-comment-own-liker=true]').each(function(i, btn) {
                    $j(btn).addClass('active');
                    
                    var voteIcon = $j(btn).find('i');
                    voteIcon.addClass('fas');
                    voteIcon.removeClass('far');
                });
                
                // Bootstrap tooltip for likers
                commentBottom.find('[data-ametys-comment-likers]').each(function(i, el) {
                    updateCommentLikersTooltip_<xsl:value-of select="$uniqueId"/>($j(el));
                });
                                    
                // Update current user image
                comment.find('form [data-current-user-img]').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/user-directory/user/' + ametysUser.populationId + '/' + encodeURIComponent(ametysUser.login) + '/image_45?lang=<xsl:value-of select="$lang"/>');
                
                // Show more
                var bodies = commentContent.find('[data-comment-content]');
                bodies.each(function(i, body) {
                    
                    let showMoreId= "csm_" + Math.random().toString(36).substring(2, 15);
                    
                    $j(body).parent().find('[data-show-more=input]').attr('id', showMoreId);
                    $j(body).parent().find('[data-show-more=label]').attr('for', showMoreId);
                    
                    $j(body).on('show', function() {
                        
                        var height = $j(this).height(); // height!=0 on invisible elements only
                        if (70 > height)
                        {
                            $j(this).parent().find('[data-show-more=label]').hide();
                            $j(this).parent().find('[data-show-more=input]').prop('checked', true);
                        }
                        else
                        {
                            $j(this).parent().find('[data-show-more=input]').prop('checked', false);
                        }
                    });
                    
                    if ($j(body).is(":visible"))
                    {
                        $j(body).trigger('show');
                    }
                })
                
                // Find links in comment and subcomments and convert them to HTML links
                const options = { defaultProtocol: "https" }
                let $commentContent = commentContent.find('[data-comment-content]');
                if ($commentContent.length)
                {
                    $commentContent.each(function(i, cm) {
                        $j(cm).html(linkifyHtml($j(cm).html(), options));
                    });
                   
                }  
            }
            
            $j(document).ready(function(){
            
                getAmetysUser(function(user) {
                    if (user)
                    {
                        // Fill form inputs
                        var $form = $j('[data-ametys-comments-form="<xsl:value-of select="@id"/>"]');
                        $form.find('input[name=name]').val(user.fullname);
                        $form.find('input[name=email]').val(user.email);
                        
                        // Update current user image
                        $j('[data-current-user-img]').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/user-directory/user/' + ametysUser.populationId + '/' + encodeURIComponent(ametysUser.login) + '/image_45?lang=<xsl:value-of select="$lang"/>');
                    }
                });
            
                // Show/hide others comments
                $j('.ametys-comments-show').on('click', function () {
                    $j(this).addClass('d-none');
                    $j(this).parent().parent().find('[data-ametys-comment-id][data-ametys-is-comment]').each(function(i, commentEl) {
                        if (i != 0)
                            $j(commentEl).slideDown()
                            
                        $j(commentEl).find('[data-comment-content]').trigger('show');
                    });
                    $j(this).parent().find('.ametys-comments-hide').removeClass('d-none');
                });
            
                $j('.ametys-comments-hide').on('click', function () {
                    $j(this).addClass('d-none');
                    $j(this).parent().parent().find('[data-ametys-comment-id][data-ametys-is-comment]').each(function(i, commentEl) {
                        if (i != 0)
                            $j(commentEl).slideUp()
                    });
                    $j(this).parent().find('.ametys-comments-show').removeClass('d-none');
                });
                
                setInterval(updateRelativeDates_<xsl:value-of select="$uniqueId"/>, 60000);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="comments-header">
        <div style="display: none" class="ametys-comment__bottom-title" data-comments-header="true">
            <span data-ametys-nb-comments="true"></span> <span data-ametys-nb-comments-text="true"><i18n:text i18n:key="SKIN_CONTENT_HEADER_COMMENTS" i18n:catalogue="skin.{$skin}"/></span>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-form">
         <form method="post" action="" id="comment-form-{$uniqueId}" data-ametys-comments-form="{@id}">
               <div class="ametys-comment__bottom__leavecomment">
                    <div class="ametys-comment__bottom__leavecomment_img">
                        <img data-current-user-img="true" src="" alt=""/>
                    </div>
                    <div class="ametys-comment__bottom__leavecomment_send">
                        <input name="name" value="" type="hidden"/>
                        <input name="email" value="" type="hidden"/>
                        <input name="url" value="" type="hidden"/>
                        <textarea id="comment-text-{$uniqueId}" name="text" class="ametys-textarea-auto" i18n:attr="placeholder" placeholder="plugin.workspaces:PLUGINS_WORKSPACES_WALL_CONTENT_ADD_COMMENT_PLACEHOLDER"></textarea>
                        <span class="ametys-comment__bottom__leavecomment_send_btn">
                            <i onclick="AmetysFront.Comments.addComment('{$uniqueId}', '{@id}', {$sortCommentsAsc}, updateNbCommentsText_{$uniqueId})" role="submit" class="icon-send-icon"></i>
                        </span>
                    </div>
               </div>
          </form>
          <script type="text/javascript">
                $j(document).ready(function(){
                    getAmetysUser(function(user) {
                        if (user)
                        {
                            // Fill form inputs
                            var $form = $j('#comment-form-<xsl:value-of select="$uniqueId"/>');
                            $form.find('input[name=name]').val(user.fullname);
                            $form.find('input[name=email]').val(user.email);
                            
                            // Update current user image
                            $form.find('[data-current-user-img]').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/user-directory/user/' + user.populationId + '/' + encodeURIComponent(user.login) + '/image_45?lang=<xsl:value-of select="$lang"/>');
                        }
                    });
                });
           </script>
    </xsl:template>
    
    <xsl:template name="content-comment-template">
        <div class="ametys-comment__bottom__list" data-ametys-comment-id="%%id%%" data-ametys-is-comment="true" style="display: none">
            <!-- Author image -->
            <xsl:call-template name="comment-author-img"/>
            
            <div class="ametys-comment__bottom__list_cmt">
                <div class="ametys-single-comment ametys-bg-white ametys-radius-20 ametys-pa-10-25 mb-2">
                    <div class="ametys-comment__top_data">
                        <!-- Author info -->
                        <xsl:call-template name="comment-header"/>
                        <!-- Comment content -->
                        <xsl:call-template name="comment-content"/>
                    </div>
                </div>
                
                <xsl:call-template name="comment-footer"/>
                
                <!-- Subcomment -->
                <xsl:call-template name="comment-subcomments"/>
                
                <!-- Answer form -->
                <xsl:call-template name="comment-answer-form"/>
                
            </div>
            
            <xsl:call-template name="comment-script"/>
        </div>
    </xsl:template>
    
    <!-- Sample template for a sub-comment -->
    <xsl:template name="content-subcomment-template">
        <li class="ametys-comment__bottom__list ametys-border-none" data-ametys-comment-id="%%id%%" data-ametys-is-comment="true">
            <!-- Author image -->
            <xsl:call-template name="comment-author-img"/>
            
            <div class="ametys-comment__bottom__list_cmt">
                <div class="ametys-single-comment ametys-bg-white ametys-radius-20 ametys-pa-10-25 mb-2">
                    <div class="ametys-comment__top_data">
                        <!-- Author info -->
                        <xsl:call-template name="comment-header"/>
                        <!-- Comment content -->
                        <xsl:call-template name="comment-content"/>
                    </div>
                </div>
                
                <!-- Votes -->
                <div class="ametys-comment-vote ametys-px-25 mb-0">
                    <xsl:call-template name="comment-like"/>
                </div>
            </div>
            
            <xsl:call-template name="comment-script"/>
        </li>
    </xsl:template>
    
    <xsl:template name="comment-script">
        <script type="text/javascript">
            // Here the scripts that should be executed after comment insertion
            {
                let comment = $j('[data-ametys-comment-id="%%id%%"][data-ametys-is-comment]');
                
                $j(document).ready(function(){
                
                    onCommentInsertion_<xsl:value-of select="$uniqueId"/>(comment)
                });
            }
        </script>
    </xsl:template>
    
    <xsl:template name="comment-author-img">
        <div class="ametys-comment__bottom__leavecomment_img">
            <img src="%%author.imgUrl%%" alt=""/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-header">
        <div class="ametys-comment__top_data_1 flex-nowrap align-items-start justify-content-between">
            <div class="d-flex flex-wrap align-items-center">
                <div class="ametys-comment__top_data_1-title">%%author-name%%</div>
                <span class="ametys-comment__top_data_1__date" data-momentdate="%%creation-date%%"></span>
                <p class="ametys-comment__top_data_1__charge" style="display: none">%%author-function%% %%author-organisation-accronym%%</p>
                <span data-ametys-tooltip="%%author-organisation%%" class="ametys-tag ametys-tag--sm ametys-tag--gray text-uppercase" data-placement="top" style="display: none">%%author-organisation-accronym%%</span>
            </div>
            
            <xsl:call-template name="comment-actions"/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-actions">
        <div class="ametys-more ametys-more--inner">
            <span class="g-dot_wrap">
                <span class="g-dot dot-1"></span>
                <span class="g-dot dot-2"></span>
                <span class="g-dot dot-3"></span>
            </span>
            <div class="ametys-more__dropdown">
                <i class="material-icons ametys-color-white">more_horiz</i>
                <ul class="ametys-more__list">
                    <xsl:call-template name="comment-action-delete"/>
                    <xsl:call-template name="comment-action-report"/>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-action-delete">
        <li data-ametys-comment-delete="true">
            <a href="javascript:void(0);" data-ametys-comment-id="%%id%%" onclick="AmetysFront.Comments.deleteComment(this, '{@id}', $j(this).attr('data-ametys-comment-id'), updateNbCommentsText_{$uniqueId})">
                <i class="fas fa-trash-alt"></i>
                <i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_DELETE_BUTTON_TITLE" i18n:catalogue="plugin.cms"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="comment-action-report">
        <li data-ametys-comment-report="true">
            <a href="javascript:void(0);" data-ametys-comment-id="%%id%%" onclick="AmetysFront.Comments.reportComment(this, '{@id}', $j(this).attr('data-ametys-comment-id'))">
                <i class="fas fa-exclamation-triangle"></i>
                <i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_REPORT_BUTTON_TITLE" i18n:catalogue="plugin.cms"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="comment-content">
        <div class="ametys-comment__content-body">
            <xsl:variable name="showMoreId" select="concat('csm_', substring-after(math:random(), '.'))"/>
            
            <input type="checkbox" style="display: none" data-show-more="input"/>
            
            <p data-comment-content="true" class="ametys-comment__paragraph mb-0">%%content%%</p>
            
            <label class="show-more__txt" data-show-more="label">
                <i18n:text i18n:key="SKIN_CONTENT_COMMENT_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>
            </label>
        </div>    
    </xsl:template> 
    
    <xsl:template name="comment-subcomments">
        <ul class="ametys-comment__sub" data-ametys-comment-subcomments="true" style="display: none">
            <!-- Subcomments will be inserted here -->
        </ul>
    </xsl:template>
    
    <xsl:template name="comment-footer">
        <div class="ametys-comment-vote ametys-px-25 mb-0">
            <xsl:call-template name="comment-answer-btn"/>
            
            <xsl:call-template name="comment-like"/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-answer-btn">
        <button class="ametys-comment-repondre mr-1" aria-expanded="false" onclick="toggleAnswerForm_{$uniqueId}(this)">
            <i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_COMMENT_ANSWER" i18n:catalogue="plugin.workspaces"/>
        </button>
    </xsl:template>
    
    <xsl:template name="comment-like">
        <span class="ametys-comment-vote__item" 
              data-ametys-comment-own-liker="%%own-liker%%" 
              data-ametys-comment-id="%%id%%" 
              data-ametys-comment-likers="%%likers%%"
              data-html="true"
              data-placement="top"
              data-offset="50px 0"
              onclick="AmetysFront.Comments.likeOrUnlikeComment(this, '{@id}', $j(this).attr('data-ametys-comment-id'), $j(this).attr('data-ametys-comment-own-liker') == 'true', likeOrUnlikeCommentCb_{$uniqueId})">
            <i class="far fa-thumbs-up"></i>
            <span data-ametys-comment-nb-likes="true">%%nb-likes%%</span>
        </span>
    </xsl:template>
    
    <xsl:template name="comment-answer-form">
        <div class="ametys-comment-repodre-block">
            <form method="post" action="">
                <div class="ametys-comment__bottom__leavecomment px-0">
                    <div class="ametys-comment__bottom__leavecomment_img">
                        <img data-current-user-img="true" alt=""/>
                    </div>
                    <div class="ametys-comment__bottom__leavecomment_send">
                        <input name="name" value="" type="hidden"/>
                        <input name="email" value="" type="hidden"/>
                        <input name="url" value="" type="hidden"/>
                        <input name="comment-id" value="%%id%%" type="hidden"/>
                        <textarea name="text" id="comment-text-%%id%%-{$uniqueId}" class="ametys-textarea-auto" i18n:attr="placeholder" placeholder="plugin.workspaces:PLUGINS_WORKSPACES_WALL_CONTENT_ADD_COMMENT_PLACEHOLDER"></textarea>
                        <span class="ametys-comment__bottom__leavecomment_send_btn">
                            <i class="icon-send-icon" onclick="AmetysFront.Comments.addSubComment(this, '{$uniqueId}', '{@id}', {$sortSubCommentsAsc})" role="submit"></i>
                        </span>
                    </div>
                </div>
            </form>
        </div>
    </xsl:template>   
</xsl:stylesheet>