<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                extension-element-prefixes="math ametys resolver escaper">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">workspaces-preference</xsl:variable>
    <xsl:variable name="common-service-name">service-workspaces-preference</xsl:variable>   
    
    <xsl:variable name="unique-id" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-head-css">
        <!-- Vendors Styles-->
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/css/bootstrap-select.min.css')}" />
        
        <!-- statistics styles -->
        <link rel="stylesheet" href="{ametys:skinURL('pages/preferences/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('pages/preferences/scss/print.css')}" />
        <!-- END::statistics styles -->
        
        <!-- form custom styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/form-custom/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/form-custom/scss/print.css')}" />
        <!-- END::form custom styles -->
        
        <!-- modal styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/modal/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/modal/scss/print.css')}" />
        <!-- END::modal styles -->
        
        <!-- custom control styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/custom-control/scss/print.css')}" />
        <!-- END::custom control styles -->
        
        <!-- basic message styles -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/basic-messages.css')}" />
        <!-- END::basic message styles -->
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/Ametys/fo/ServerComm.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/Preferences.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/bootstrap-select/dist/js/bootstrap-select.min.js')}"></script>
        <script type="text/template" id="project-item-template">
            <xsl:call-template name="notifications-project-item-template"/>
        </script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/basic-messages.', ametys:lang(), '.js'))}"></script>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-template">
        <div class="ametys-notifications-list-alt__item" data-project-prefs-item="true">
            <xsl:call-template name="notifications-project-item-content"/>
            <xsl:call-template name="notifications-project-item-action"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-content">
        <div class="ametys-notifications-list-alt-content">
            <xsl:call-template name="notifications-project-item-title"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-title">
        <a href="javascript:void(0);" class="ametys-notifications-list-alt__content-title" data-project-title="" data-project-name="data-project-name" data-action="open-edit-modal">
            <i class="fas fa-dice-d6"/>
        </a>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-action">
            <div class="ametys-notifications-list-alt-actions">
                <div class="ametys-more">
                    <xsl:call-template name="notifications-project-item-action-button"/>
                    <xsl:call-template name="notifications-project-item-action-dropdown"/>
                </div>
            </div>
    </xsl:template>

    <xsl:template name="notifications-project-item-action-button">
        <span class="g-dot_wrap">
            <span class="g-dot dot-1"></span>
            <span class="g-dot dot-2"></span>
            <span class="g-dot dot-3"></span>
        </span>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-action-dropdown">
        <div class="ametys-more__dropdown">
            <i class="material-icons ametys-color-white">more_horiz</i>
            <ul>
                <li>
                    <a href="javascript:void(0);" data-action="open-edit-modal" data-project-title="data-project-title" data-project-name="data-project-name">
                        <xsl:call-template name="notifications-project-item-action-dropdown-edit"/>
                    </a>
                </li>
                <li>
                    <a href="javascript:void(0);" data-action="delete-project-prefs" data-project-title="data-project-title" data-project-name="data-project-name">
                        <xsl:call-template name="notifications-project-item-action-dropdown-delete"/>
                    </a>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-action-dropdown-edit">
        <i class="far fa-edit"></i>
        <span>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_ITEM_ACTION_EDIT"/>
        </span>
    </xsl:template>
    
    <xsl:template name="notifications-project-item-action-dropdown-delete">
        <i class="far fa-trash-alt"></i>
        <span>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_ITEM_ACTION_DELETE"/>
        </span>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="notifications-card"/>
        
        <xsl:call-template name="notifications-new-project-preferences-modal"/>
        
        <xsl:call-template name="notifications-project-preferences-modal"/>
        
        <script type="text/javascript">
            var projects = {};
            <xsl:for-each select="/UserPreferences/userProjects/project">
                projects["<xsl:value-of select="@name"/>"] = {"title" :"<xsl:value-of select="ametys:escapeJS(title)"/>"};
            </xsl:for-each>
            <xsl:choose>
                <xsl:when test="/UserPreferences/groups/group/preferences/preference[@name = 'workspaces.notifications']/value != ''">
                    <xsl:variable name="prefs" select="/UserPreferences/groups/group/preferences/preference[@name = 'workspaces.notifications']/value"/>
                    AmetysWorkspacePreferences.populateService("<xsl:value-of select="$unique-id"/>", <xsl:value-of select="$prefs"/>, projects);
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="prefs" select="/UserPreferences/groups/group/preferences/preference[@name = 'workspaces.notifications']/defaultValue"/>
                    AmetysWorkspacePreferences.populateService("<xsl:value-of select="$unique-id"/>", <xsl:value-of select="$prefs"/>, projects);
                </xsl:otherwise>
            </xsl:choose>
        </script>
    </xsl:template>
    
    <xsl:template name="notifications-card">
        <div class="ametys-card">
            <xsl:call-template name="notifications-header"/>
            
            <xsl:call-template name="notifications-body"/>
        </div>
    </xsl:template>

    
    <xsl:template name="notifications-header">
        <div class="ametys-card-header">
            <div class="ametys-card-header-left">
                <div class="ametys-card-header-title">
                    <xsl:call-template name="notifications-header-title"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-header-title">
        <i class="fas fa-bell"/>
        <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_HEADER_TITLE"/>
    </xsl:template>
    
    <xsl:template name="notifications-body">
        <div class="ametys-card-body">
            <div class="ametys-card-body-content-limit">
                <form id="preference-default-notification-form-{$unique-id}" data-default-notifications-form="true">
                    <xsl:call-template name="notifications-body-disable-section"/>
                    
                    <xsl:call-template name="notifications-body-frequency-section"/>
                                    
                    <xsl:call-template name="notifications-body-projects-section"/>
                </form>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-disable-section">
        <div class="ametys-content-section">
            <xsl:call-template name="notifications-body-disable-section-widgets"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-disable-section-widgets">
        <label class="ametys-switch">
            <input name="disable" type="checkbox"/>
            <span class="ametys-switch__control"></span>
            <span class="ametys-switch__label"><xsl:call-template name="notifications-body-disable-section-widgets-label"/></span>
        </label>
    </xsl:template>
    
    <xsl:template name="notifications-body-disable-section-widgets-label">
        <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_DISABLE_WIDGET_LABEL"/>
    </xsl:template>
    
    <xsl:template name="notifications-body-frequency-section">
        <div class="ametys-content-section" data-notification-frequency="true">
            <xsl:call-template name="notifications-body-default-form-frequency-title"/>
            
            <xsl:call-template name="notifications-body-default-form-frequency-widgets"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-default-form-frequency-title">
        <h3>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_SECTION_TITLE"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="notifications-body-default-form-frequency-widgets">
        <div class="ametys-radio-group">
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">each</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_EACH"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">daily</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_DAILY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">weekly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_WEEKLY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">monthly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_MONTHLY"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-projects-section">
        <div data-notification-project-prefs="true" class="ametys-content-section">
            <xsl:call-template name="notifications-body-projects-section-title"/>
            <xsl:call-template name="notifications-body-projects-section-hint"/>
            
            <xsl:call-template name="notifications-body-projects-section-list"/>
            
            <xsl:call-template name="notifications-body-projects-section-new-preferences-action"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-projects-section-title">
        <h3>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_PROJECTS_SECTION_TITLE"/>
        </h3>
    </xsl:template>
    
     <xsl:template name="notifications-body-projects-section-hint">
        <p>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_PROJECTS_SECTION_HINT"/>
        </p>
    </xsl:template>
    
    <xsl:template name="notifications-body-projects-section-list">
    <div class="ametys-notifications-list-alt" data-notification-projects-list="true">
<!--    This will be filled from the JS. Here we only create the block to fill. -->
<!--    See template notifications-project-item-template to define the list elements. -->
    </div>
    </xsl:template>
    
    <xsl:template name="notifications-body-projects-section-new-preferences-action">
        <a class="ametys-download-btn" data-action="open-new-project-modal" href="javascript:void(0);">
            <i class="fas fa-plus"></i>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_PROJECTS_SECTION_NEW_PREFERENCES_ACTION_LABEL"/>
        </a>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal">
        <div id="preference-new-project-notification-modal-{$unique-id}"
             class="ametys-modal modal fade"
             tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <xsl:call-template name="notifications-new-project-preferences-modal-header"/>
                    
                    <xsl:call-template name="notifications-new-project-preferences-modal-body"/>
                    
                    <xsl:call-template name="notifications-new-project-preferences-modal-footer"/>
                    
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-header">
        <div class="modal-header">
            <xsl:call-template name="notifications-new-project-preferences-modal-header-title"/>
            
            <xsl:call-template name="preferences-modal-close-button"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-header-title">
        <h3 class="modal-title">
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_HEADER_TITLE"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body">
        <div class="modal-body">
            <form>
                <xsl:call-template name="notifications-new-project-preferences-modal-body-project-selector"/>
                
                <xsl:call-template name="notifications-new-project-preferences-modal-body-disable-section"/>
                
                <xsl:call-template name="notifications-new-project-preferences-modal-body-frequency-section"/>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-project-selector">
        <div class="ametys-content-section">
            <xsl:call-template name="notifications-new-project-preferences-modal-body-project-selector-title"/>
            
            <xsl:call-template name="notifications-new-project-preferences-modal-body-project-selector-widgets"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-project-selector-title">
        <h3 class="ametys-form-control-label">
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_PROJECT_SELECTOR_TITLE"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-project-selector-widgets">
        <select class="selectpicker ametys-form-control"
                name="project-name"
                title="Sélectionner"
                data-live-search="true">
            <!-- Options are filled in JS -->
        </select>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-disable-section">
        <div class="ametys-content-section">
            <xsl:call-template name="notifications-new-project-preferences-modal-body-disable-section-widget"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-disable-section-widget">
        <label class="ametys-switch">
            <input name="disable" type="checkbox" />
            <span class="ametys-switch__control"></span>
            <span class="ametys-switch__label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_DISABLE_WIDGET_LABEL"/></span>
        </label>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-frequency-section">
        <div class="ametys-content-section" data-notification-frequency="true">
            <xsl:call-template name="notifications-new-project-preferences-modal-body-frequency-section-title"/>
            
            <xsl:call-template name="notifications-new-project-preferences-modal-body-frequency-section-widget"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-frequency-section-title">
        <h3>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_FREQUENCY_SECTION_TITLE"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-body-frequency-section-widget">
        <div class="ametys-radio-group">
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">each</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_EACH"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">daily</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_DAILY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">weekly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_WEEKLY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">monthly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_MONTHLY"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-new-project-preferences-modal-footer">
        <div class="modal-footer">
            <button type="button" class="modal-close" data-dismiss="modal">
                <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_FOOTER_CLOSE_ACTION"/>
            </button>
            <button type="button" class="modal-apply">
                <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_NEW_PROJECT_PREFERENCES_MODAL_FOOTER_APPLY_ACTION"/>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="notifications-project-preferences-modal">
        <div id="preference-project-notification-modal-{$unique-id}"
                 class="ametys-modal modal fade"
                 tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <xsl:call-template name="notification-project-preferences-modal-header"/>
                    
                    <xsl:call-template name="notification-project-preferences-modal-body"/>
                    
                    <xsl:call-template name="notification-project-preferences-modal-footer"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-header">
        <div class="modal-header">
            <xsl:call-template name="notification-project-preferences-modal-header-title"/>
            
            <xsl:call-template name="preferences-modal-close-button"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-header-title">
        <h3 class="modal-title">
<!--             Will be filled by JS at opening -->
        </h3>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body">
        <div class="modal-body">
            <form>
                <input name="project-name" type="hidden"/>
                <xsl:call-template name="notification-project-preferences-modal-body-disable-section"/>
                
                <xsl:call-template name="notification-project-preferences-modal-body-frequency-section"/>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body-disable-section">
        <div class="ametys-content-section">
            <xsl:call-template name="notification-project-preferences-modal-body-disable-section-title"/>
            
           <xsl:call-template name="notification-project-preferences-modal-body-disable-section-widgets"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body-disable-section-title"/>
    
    <xsl:template name="notification-project-preferences-modal-body-disable-section-widgets">
        <label class="ametys-switch">
            <input name="disable" type="checkbox" />
            <span class="ametys-switch__control"></span>
            <span class="ametys-switch__label">
                <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_PREFERENCES_MODAL_DISABLE_WIDGET_LABEL"/>
            </span>
        </label>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body-frequency-section">
        <div class="ametys-content-section" data-notification-frequency="true">
            <xsl:call-template name="notification-project-preferences-modal-body-frequency-section-title"/>
            
            <xsl:call-template name="notification-project-preferences-modal-body-frequency-section-widget"/>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body-frequency-section-title">
        <h3>
            <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_PREFERENCES_MODAL_FREQUENCY_SECTION_TITLE"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-body-frequency-section-widget">
        <div class="ametys-radio-group">
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">each</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_EACH"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">daily</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_DAILY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">weekly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_WEEKLY"/></xsl:with-param>
            </xsl:call-template>
            
            <xsl:call-template name="ametys-radio">
                <xsl:with-param name="name">frequency</xsl:with-param>
                <xsl:with-param name="value">monthly</xsl:with-param>
                <xsl:with-param name="label"><i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_BODY_FREQUENCY_WIDGET_LABEL_MONTHLY"/></xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-project-preferences-modal-footer">
        <div class="modal-footer">
            <button type="button" class="modal-close" data-dismiss="modal">
                <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_PREFERENCES_MODAL_FOOTER_CLOSE_ACTION"/>
            </button>
            <button type="button" class="modal-apply">
                <i18n:text i18n:catalogue="skin.workspace-catalog" i18n:key="SKIN_SERVICE_PREFERENCE_NOTIFICATIONS_PROJECT_PREFERENCES_MODAL_FOOTER_APPLY_ACTION"/>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="ametys-radio">
        <xsl:param name="name"/>
        <xsl:param name="value"/>
        <xsl:param name="label"/>
        
        <label class="ametys-radio">
            <input type="radio" name="{$name}" value="{$value}"/>
            <span class="ametys-radio__control"></span>
            <span class="ametys-radio__label"><xsl:copy-of select="$label"/></span>
        </label>
    </xsl:template>
    
    <xsl:template name="preferences-modal-close-button">
        <button type="button"
                        class="close"
                        data-dismiss="modal"
                        aria-label="Close">
            <i class="material-icons">close</i>
        </button>
    </xsl:template>
    
</xsl:stylesheet>