<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:stringutils="org.apache.commons.lang.StringUtils"
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="docbook resolver ametys user exslt"
                              extension-element-prefixes="text">
    
    <xsl:import href="skin:workspace-catalog://stylesheets/content/catalogNews/catalogNews-portlet.xsl"/>    

    <xsl:template name="common-content-body-content">
        <div class="ametys-portlet">
            <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
            <a class="ametys-portlet__master-link" href="{resolver:resolve('page', $page-id, false)}"></a>
            
            <xsl:call-template name="top-news"/>
            
            <xsl:call-template name="content-news"/>
            
            <xsl:call-template name="comment-news"/>
            
            <xsl:call-template name="bottom-news"/>
        </div>
    </xsl:template>
    
    <xsl:template name="author-name">
        <xsl:param name="author"/>
        <h3>
            <xsl:value-of select="$author/user/fullname"/>
        </h3>
    </xsl:template>
    
    <xsl:template name="news-title">
        <h2 class="ametys-truncate" data-lines="2">
            <xsl:if test="metadata/title != ''">
                <xsl:value-of select="metadata/title"/>
            </xsl:if>
        </h2> 
    </xsl:template>
    
    <xsl:template name="bottom-news">
		<div class="ametys-portlet__bottom">
            <xsl:call-template name="news-tags">
                <xsl:with-param name="maxlength">2</xsl:with-param>
                <xsl:with-param name="tagPrefix">WORKSPACES_TAG_</xsl:with-param>
            </xsl:call-template>
	    </div>
    </xsl:template>
</xsl:stylesheet>