<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xlink="http://www.w3.org/1999/xlink"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:math="http://exslt.org/math" 
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                            exclude-result-prefixes="ametys exslt resolver docbook math">

    <xsl:import href="view://stylesheets/content/common.xsl"/>
    <xsl:import href="plugin:web://stylesheets/helper/url-preview.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>   
    <xsl:import href="skin://stylesheets/helper/comments.xsl"/>   
    
    <xsl:variable name="prefix" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-content-css-class-name">
        <xsl:choose>
            <xsl:when test="/view/content/tags/WORKSPACES_CONTENT_PINNED">ametys-comment ametys-mb-25 ametys-comment--favorite</xsl:when>
            <xsl:otherwise>ametys-comment ametys-mb-25</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/WallContent.', ametys:lang(), '.js'))}"></script>
    </xsl:template>

    <xsl:template name="common-content-head-css">
        <!-- publier styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/publier-add/scss/main.css')}" />
        <!-- END::publier styles -->
        
        <!-- comment styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/comment/scss/main.css')}" />
        <!-- END::comment styles -->
    </xsl:template>
    
    <xsl:template name="common-content-body-title-content"/>

    <xsl:template name="common-content-body-content">
        <xsl:variable name="rawUser">
            <xsl:call-template name="user-info">
                <xsl:with-param name="userIdentity" select="@creator"/>
                <xsl:with-param name="imgWidth">40</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="user" select="exslt:node-set($rawUser)"/>
        
        <div id="wallcontent-{$uniqueId}" data-content-id="{@id}">
            <div class="ametys-comment__top ametys-mb-16">
                <xsl:call-template name="author-image">
                    <xsl:with-param name="author" select="$user"/>
                </xsl:call-template>
                
                <xsl:call-template name="author-data">
                    <xsl:with-param name="author" select="$user"/>
                    <xsl:with-param name="date" select="@createdAt"/>
                </xsl:call-template>
                
                <xsl:call-template name="content-actions">
                    <xsl:with-param name="contentId" select="@id"/>
                    <xsl:with-param name="author" select="$user"/>
                </xsl:call-template>
                
                <!-- <span class="ametys-comment__top_badge"></span> -->
            </div>
            
            <xsl:call-template name="common-content-body-content-content"/>

            <xsl:call-template name="common-content-body-comments"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content-content">
        <div class="ametys-comment__content">
            
            <div data-content-wrapper="true">
                <xsl:variable name="showMoreId" select="concat('wcsm_', substring-after(math:random(), '.'))"/>
                
                <div class="ametys-comment__content-body">
                    <input type="checkbox" style="display: none" id="input-{$showMoreId}"/>
    
                    <!-- Rich content -->
                    <div class="ametys-richtext" data-ametys-wallcontent="{@id};content">
                        <xsl:call-template name="common-content-body-content-rich"/>
                    </div>
                    
                    <label class="show-more__txt" for="input-{$showMoreId}">
                        <i18n:text i18n:key="SKIN_CONTENT_COMMENT_SHOW_MORE" i18n:catalogue="skin.{$skin}"/>
                    </label>
                </div>
                
                <script type="text/javascript">
                    // Show more
                    var body = $j("#wallcontent-<xsl:value-of select="$uniqueId"/> [data-ametys-wallcontent]");
                    var height = body.height();
                    if (100 > height)
                    {
                        $j("#wallcontent-<xsl:value-of select="$uniqueId"/> label[for=input-<xsl:value-of select="$showMoreId"/>]").hide();
                        body.parent().find('input[type=checkbox]').prop('checked', true);
                    }
                    else
                    {
                        body.parent().find('input[type=checkbox]').prop('checked', false);
                    }
                </script>
                
                <!-- Image -->
                <xsl:call-template name="common-content-body-image-bigsize">
                    <xsl:with-param name="maxWidth" select="'600'"/>
                    <xsl:with-param name="maxHeight" select="'600'"/>
                    <xsl:with-param name="class" select="'mb-4'"/>
                </xsl:call-template>
            </div>
            
            <!-- Expand url preview -->
            <xsl:call-template name="display-url-preview"/>

            <!-- Edit form -->
            <xsl:call-template name="content-edit-form"/>
                        
            <div class="ametys-comment-vote">
                <!-- Nb comments -->
                <span class="ametys-comment-vote__item active">
                    <i class="far fa-comment"></i>
                    <span data-ametys-nb-comments=""></span>
                </span>
                <!-- Like -->
                <xsl:call-template name="content-action-like">
                    <xsl:with-param name="contentId" select="@id"/>
                </xsl:call-template>
                <!-- Favorites -->
                <xsl:call-template name="content-favorites"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="content-edit-form">
        <form style="display: none" class="ametys-edit-publier" data-content-edit="true" method="POST">
            <textarea name="content"></textarea>
            
            <div class="ametys-add-publier__bottom">
                <button class="ametys-add-publier__top-btn" onclick="WallContent.saveChanges('{@id}')">
                    <i class="icon-send-icon"></i>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_PUBLISH_BTN" i18n:catalogue="plugin.workspaces"/>
                </button>
                <button class="ametys-add-publier__top-btn" onclick="WallContent.cancelChanges('{@id}')">
                    <i class="fas fa-ban"></i>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_CANCEL_BTN" i18n:catalogue="plugin.workspaces"/>
                </button>
            </div>
        </form>
    </xsl:template>
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <div class="ametys-comment__gallery ametys-mb-25">
                <div class="ametys-comment__gallery_item">
                    <a href="{resolver:resolve($image/@type, $image/@path)}" class="js-fancybox" data-fancybox="lightbox-gallery-{$uniqueId}" rel="single" data-overlay-bg="rgba(0, 0, 0, 1)" data-caption="{$image/@filename}">
                        <img class="img-fluid" alt="{$alternative}">
                            <xsl:attribute name="src">
                                <xsl:choose>
                                    <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                        </img>
                    </a>
                </div>
            </div>
        </xsl:if>        
    </xsl:template>  
    
    <xsl:template name="display-url-preview">
        <xsl:variable name="links" select="metadata/content/docbook:article//docbook:link[not(@xlink:type) or @xlink:type = '']"/>
        <xsl:for-each select="$links">
            <xsl:call-template name="url-preview-async">
                <xsl:with-param name="url" select="@xlink:href"/>
                <xsl:with-param name="lang" select="$lang"/>
                <xsl:with-param name="uniqueId" select="concat($uniqueId, '-preview-', position())"/>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="author-image">
        <xsl:param name="author"/>
        
        <xsl:variable name="isManager" select="project:isManager($author/user/login, $author/user/population)"/>
        
        <div class="ametys-comment__top_img">
            <xsl:if test="$isManager"><xsl:attribute name="class">ametys-comment__top_img position-relative</xsl:attribute></xsl:if>
            
            <xsl:variable name="authorImgUrl">
                <xsl:choose>
                    <xsl:when test="$author/user/login != ''">
                        <xsl:call-template name="user-image-url">
                            <xsl:with-param name="login" select="$author/user/login"/>
                            <xsl:with-param name="population" select="$author/user/population"/>
                            <xsl:with-param name="imgWidth">45</xsl:with-param>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="anonymous-user-img-url"/>
                    </xsl:otherwise>
                </xsl:choose>
                
            </xsl:variable>
            
            <xsl:choose>
                <xsl:when test="$author/user/pageId !=''">
                    <a href="{resolver:resolve('page', $author/user/pageId)}">
                        <img class="rounded-circle" src="{$authorImgUrl}" alt=""/>
                        <xsl:if test="project:isManager($author/user/login, $author/user/population)">
                            <span class="ametys-membres__avatar_icon">
                                <i class="fas fa-sun ametys-color-purple"></i>
                            </span>
                        </xsl:if>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <img class="rounded-circle" src="{$authorImgUrl}" alt=""/>
                    <xsl:if test="$isManager">
                        <span class="ametys-membres__avatar_icon">
                            <i class="fas fa-sun ametys-color-purple"></i>
                        </span>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="author-data">
        <xsl:param name="author"/>
        <xsl:param name="date"/>
        
        <div class="ametys-comment__top_data">
            <div class="ametys-comment__top_data_1">
                <div class="ametys-comment__top_data_1-title">
                    <xsl:choose>
                        <xsl:when test="$author/user/fullname != ''"><xsl:value-of select="$author/user/fullname"/></xsl:when>
                        <xsl:otherwise><xsl:call-template name="anonymous-user-name"/></xsl:otherwise>
                    </xsl:choose>
                </div>
                <span class="ametys-comment_minleft" data-momentdate="{$date}"></span>
            </div>
            <div class="ametys-comment__top_data_2">
                <xsl:if test="$author/user/role != ''">
                    <p><xsl:value-of select="$author/user/role"/></p>
                </xsl:if>
                
                <xsl:if test="$author/user/organisationAccronym != ''">
                    <span class="ametys-tag ametys-tag--sm ametys-tag--gray text-uppercase"
                      data-ametys-tooltip="{$author/user/organisation}"><xsl:value-of select="$author/user/organisationAccronym"/></span>
                </xsl:if>
            </div>
        </div>
        <script type="text/javascript">
            $j("#wallcontent-<xsl:value-of select="$uniqueId"/> [data-momentdate]").each(function() {
                let date = $j(this).data('momentdate');
                $j(this).html(AmetysFront.Utils.toRelativeDate(date, {withTime: true}));
            });
        </script>
    </xsl:template>
    
    <xsl:template name="content-favorites">
        <span class="ametys-comment-vote__item ametys-toggle-favorite" style="display: none">
            <i class="fas fa-thumbtack"></i>
            <script type="text/javascript">
                var pinned = "<xsl:value-of select="tags/WORKSPACES_CONTENT_PINNED"/>" != '';
                var a = $j("#wallcontent-<xsl:value-of select="$uniqueId"/> .ametys-toggle-favorite");
                if (pinned)
                {
                    a.show();
                }
                if (pinned &amp;&amp; ametysUser.canPinWallContent)
                {
                    a.attr('title', "<i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_UNPIN" i18n:catalogue="plugin.workspaces" />");
                    a.on('click', function() { return WallContent.unpin('<xsl:value-of select="@id"/>')});
                }
                else if (ametysUser.canPinWallContent)
                {
                    a.addClass("pin");
                    a.attr('title', "<i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_PIN" i18n:catalogue="plugin.workspaces" />");
                    a.on('click', function() { return WallContent.pin('<xsl:value-of select="@id"/>')}); 
                    a.show();
                }
            </script>
        </span>
    </xsl:template>
    
    <xsl:template name="content-actions">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <div id="content-{$uniqueId}-actions" class="ametys-more ml-auto" style="display: none">
            <span class="g-dot_wrap">
                <span class="g-dot dot-1"></span>
                <span class="g-dot dot-2"></span>
                <span class="g-dot dot-3"></span>
            </span>
            <div class="ametys-more__dropdown">
                <i class="material-icons ametys-color-white">more_horiz</i>
                <ul>
                    
                    <!-- Edit -->
                    <xsl:call-template name="content-action-edit">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                    
                    <!-- Pin -->
                    <xsl:call-template name="content-action-pin">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                    
                    <!-- Unpin -->
                    <xsl:call-template name="content-action-unpin">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                    
                    <!-- Transform to subject -->
                    <xsl:call-template name="content-action-transform-to-subject">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                    
                    <!-- Report -->
                    <xsl:call-template name="content-action-report">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                    
                    <!-- Delete -->
                    <xsl:call-template name="content-action-delete">
                        <xsl:with-param name="contentId" select="$contentId"/>
                        <xsl:with-param name="author" select="$author"/>
                    </xsl:call-template>
                </ul>
            </div>
        </div>
                                                
        
        <script type="text/javascript">
            $j(document).ready(function () {
                $j("#content-<xsl:value-of select="$uniqueId" />-actions").on('click', function () {
                    $j(this).toggleClass('active');
                });
        
                var actions = $j("#content-<xsl:value-of select="$uniqueId" />-actions").find(".ametys-more__dropdown ul > li");
                var show = false;
                actions.each(function(i, a) {
                    if ($j(a).css('display') != 'none')
                    {
                        show = true;
                        return false;
                    }
                });
                
                if (show)
                    $j("#content-<xsl:value-of select="$uniqueId" />-actions").show();
            });
        </script>
    </xsl:template>
    
    <xsl:template name="content-action-like">   
        <xsl:param name="contentId"/>
        
        <span id="like-{$uniqueId}-action" class="ametys-comment-vote__item" onclick="likeOrUnlike_{$uniqueId}(this)"
              data-html="true"
              data-placement="top"
              data-offset="50px 0">
            <i class="far fa-thumbs-up"></i>
            <span data-nb-likes=""><xsl:value-of select="count(reactions/reaction[@type='LIKE']/actor)"/></span>
        </span>
        
        <script type="text/javascript">
            var likers_<xsl:value-of select="$uniqueId"/> = [<xsl:for-each select="reactions/reaction[@type='LIKE']/actor">{
            <xsl:for-each select="@*|node()">"<xsl:value-of select="local-name()"/>": "<xsl:value-of select="."/>",
            </xsl:for-each>}<xsl:if test="position() != last()">,</xsl:if>
        </xsl:for-each>]
        
            var isOwnLiker_<xsl:value-of select="$uniqueId"/> = false;
            $j.each(likers_<xsl:value-of select="$uniqueId"/>, function(i, liker) {
                if (liker.login == ametysUser.login &amp;&amp; liker.population == ametysUser.populationId)
                {
                    isOwnLiker_<xsl:value-of select="$uniqueId"/> = true;
                }
            });
            
            // Update tooltip with likers
            function updateTooltipLikers_<xsl:value-of select="$uniqueId"/>() 
            {
                let maxNbLikers = 5;
                let nbLikers = likers_<xsl:value-of select="$uniqueId"/>.length;
                
                let likers = "";
                $j.each(likers_<xsl:value-of select="$uniqueId"/>, function(i, liker) {
                    if (i &lt; maxNbLikers)
                    {
                        likers += "&lt;span class='like'>" + liker.fullname + "&lt;/span>"
                    }
                });
                
                let otherCount = nbLikers - maxNbLikers;
                if (otherCount == 1)
                {
                    likers += "&lt;span class='like'><i18n:text i18n:key="SKIN_CONTENT_LIKE_OTHER_TOOLTIP" i18n:catalogue="skin.{$skin}"/>&lt;/span>"
                }
                else if (otherCount &gt; 1)
                {
                    likers += "&lt;span class='like'>" + "<i18n:text i18n:key="SKIN_CONTENT_LIKE_OTHERS_TOOLTIP" i18n:catalogue="skin.{$skin}"/>".replace(/\{0}/, otherCount) + "&lt;/span>";
                }

                if (nbLikers > 0)
                {
                    $j('#like-<xsl:value-of select="$uniqueId"/>-action').attr('data-ametys-tooltip', likers);
                }
                else
                {
                    $j('#like-<xsl:value-of select="$uniqueId"/>-action').removeAttr('data-ametys-tooltip');
                }
            }
            
            function likeOrUnlike_<xsl:value-of select="$uniqueId"/>(btn) 
            {
                if (isOwnLiker_<xsl:value-of select="$uniqueId"/>)
                {
                    WallContent.unlike(btn, '<xsl:value-of select="@id"/>', likeOrUnlikeCb_<xsl:value-of select="$uniqueId"/>)
                }
                else
                {
                    WallContent.like(btn, '<xsl:value-of select="@id"/>', likeOrUnlikeCb_<xsl:value-of select="$uniqueId"/>)
                }
            }
            
            // Callback after like/unlike wall
            function likeOrUnlikeCb_<xsl:value-of select="$uniqueId"/>(btn, result, liked) 
            {
                var nbLikes = Number($j(btn).find('[data-nb-likes]').html());
                nbLikes = liked ? nbLikes+1 : nbLikes-1;
                $j(btn).find('[data-nb-likes]').html(nbLikes);
                
                var voteIcon = $j(btn).find('i');
                if (liked)
                {
                    $j(btn).addClass('active');
                    voteIcon.addClass('fas');
                    voteIcon.removeClass('far');
                    likers_<xsl:value-of select="$uniqueId"/>.push(ametysUser);
                    isOwnLiker_<xsl:value-of select="$uniqueId"/> = true;
                }
                else
                {
                    $j(btn).removeClass('active');
                    voteIcon.addClass('far');
                    voteIcon.removeClass('fas');
                    let index = -1;
                    $j.each(likers_<xsl:value-of select="$uniqueId"/>, function(i, liker) {
                        if (liker.login == ametysUser.login &amp;&amp; liker.population == ametysUser.populationId)
                        {
                            index = i;
                            return;
                        }
                    });
                    likers_<xsl:value-of select="$uniqueId"/>.splice(index, 1);
                    isOwnLiker_<xsl:value-of select="$uniqueId"/> = false;
                }
                
                // Update tooltip
                updateTooltipLikers_<xsl:value-of select="$uniqueId"/>();
            }
            
            $j(document).ready(function(){
                updateTooltipLikers_<xsl:value-of select="$uniqueId"/>();
                
                if (isOwnLiker_<xsl:value-of select="$uniqueId"/>)
                {
                    var $btn = $j('#like-<xsl:value-of select="$uniqueId"/>-action');
                    $btn.addClass('active');
                    var voteIcon = $btn.find('i');
                    voteIcon.addClass('fas');
                    voteIcon.removeClass('far');
                }
            });
        </script>
    </xsl:template>

    <xsl:template name="content-action-edit">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li style="display: none" id="edit-{$uniqueId}-action">
            <a href="javascript:;" onclick="WallContent.edit('{$contentId}')">
                <i class="fas fa-edit"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_EDIT" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
                    
        <script type="text/javascript">
            var a = $j("#edit-<xsl:value-of select="$uniqueId" />-action");
            if (("<xsl:value-of select="$author/user/login"/>" == ametysUser.login &amp;&amp; "<xsl:value-of select="$author/user/population"/>" == ametysUser.populationId) || ametysUser.canEditWallContent)
            {
                a.show();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-action-pin">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li style="display: none" id="pin-{$uniqueId}-action">
            <a href="#" onclick="return WallContent.pin('{$contentId}')">
                <i class="fas fa-thumbtack"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_PIN" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
        
        <script type="text/javascript">
            var a = $j("#pin-<xsl:value-of select="$uniqueId" />-action");
            var pinned = "<xsl:value-of select="tags/WORKSPACES_CONTENT_PINNED"/>" != '';
            if (ametysUser.canPinWallContent &amp;&amp; !pinned)
            {
                a.show();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-action-unpin">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li style="display: none" id="unpin-{$uniqueId}-action">
            <a href="#" onclick="return WallContent.unpin('{$contentId}')">
                <i class="fas fa-thumbtack"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_UNPIN" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
        
        <script type="text/javascript">
            var a = $j("#unpin-<xsl:value-of select="$uniqueId" />-action");
            var pinned = "<xsl:value-of select="tags/WORKSPACES_CONTENT_PINNED"/>" != '';
            if (ametysUser.canPinWallContent &amp;&amp; pinned)
            {
                a.show();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-action-delete">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li style="display: none" id="delete-{$uniqueId}-action" >
            <a href="#" onclick="return WallContent.deleteContent('{$contentId}')">
                <i class="fas fa-trash"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_DELETE" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
        
        <script type="text/javascript">
            var a = $j("#delete-<xsl:value-of select="$uniqueId" />-action");
            if (("<xsl:value-of select="$author/user/login"/>" == ametysUser.login &amp;&amp; "<xsl:value-of select="$author/user/population"/>" == ametysUser.populationId) || ametysUser.canDeleteWallContent)
            {
                a.show();
            }
        </script>
    </xsl:template>
    
    <xsl:template name="content-action-report">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li id="report-{$uniqueId}-action" >
            <a href="#" onclick="return WallContent.report('{$contentId}')">
                <i class="fas fa-exclamation-triangle"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_REPORT" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="content-action-transform-to-subject">
        <xsl:param name="contentId"/>
        <xsl:param name="author"/>
        
        <li style="display: none" id="transform-{$uniqueId}-action" >
            <a href="#">
                <i class="icon-messages"></i>
                <span><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_ACTION_TRANSFORM_TO_SUBJECT" i18n:catalogue="plugin.workspaces" /></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="docbook:para">
        <p class="ametys-comment__paragraph">
            <xsl:call-template name="get-styles"/>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    
    <xsl:template name="link-class-attribute">
        <xsl:param name="href"/>
        
        <xsl:attribute name="class">ametys-link<xsl:if test="@xrefstyle"><xsl:text> </xsl:text><xsl:value-of select="@xrefstyle"/></xsl:if></xsl:attribute>
    </xsl:template>
    
    <!-- Do not display comments header -->
    <xsl:template name="comments-header"/>
    
</xsl:stylesheet>
