<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:uri="org.ametys.core.util.URIUtils"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="resolver">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>
    
    <xsl:template match="/">
        <html>
            <head>
                <title><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></title>
            </head>
            <body id="default">
                <div class="ametys-auth-form">
                    <div class="ametys-auth-form-body">
                        <xsl:call-template name="body"/>
                        <xsl:call-template name="select-js"/>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="select-js">
        <script>
            var $select = $j('.select select'),
            placeholder = $j('.select').attr('placeholder');
            $select.selectpicker({
                width: '100%',
                    noneSelectedText: placeholder
            });
            
            $select.on('changed.bs.select', function () {
                var $target = $j(this).closest('.login-input-wrapper-userpopulation'),
                        emptyClass = 'login-input-wrapper-userpopulation-select-empty';
                
                $target.removeClass(emptyClass);
                
                if ($select[0].selectedIndex == -1) {
                    $target.addClass(emptyClass);
                }
            });
        </script>
    </xsl:template>
    
	<xsl:template name="body-title">
        <h2 class="ametys-auth-form-title">
        	<i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="body-existingaccount-title"/>
    
    <xsl:template name="show-hint"/>
    
    <xsl:template name="signup"/>
    
    <xsl:template name="login-form-inputs-forgotten-internal">
        <xsl:param name="label"/>
        <xsl:param name="url"/>
    
        <div class="login-link-wrapper-forgotten" style="float: right;">
            <a href="{$url}"><xsl:copy-of select="$label"/></a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
