<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		                    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="project ametys">
    
    <xsl:import href="skin:workspace://stylesheets/head.xsl" />
    
    <xsl:template name="manifest">
        <xsl:call-template name="head-meta-manifest">
            <xsl:with-param name="force" select="ametys:config('workspaces.pwa.enabled-on-all-projects') = 'true'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="projects-css">
	    <!-- Prettify -->
	    <link rel="stylesheet" type="text/css" href="{ametys:skinURL('prettify/prettify.css')}"/>
    </xsl:template>
    
    <xsl:template name="projects-scripts">
        <!-- Prettify -->
        <script src="{ametys:skinURL('prettify/prettify.js')}" type="text/javascript"></script>
        <script src="{ametys:skinURL('prettify/prettyPrintEvents.js')}" type="text/javascript"></script>
        
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/Project.', ametys:lang(), '.js'))}"></script>

        <script type="text/javascript">
            const projectName = '<xsl:value-of select="project:project()"/>';
            AmetysFront.setAppParameter('projectName', projectName);

            function leaveProject() 
            {
                Project.leaveProject(projectName, function() {
                    window.location.href= "<xsl:value-of select="$catalogHomeUrl"/>"
                })
            }

            window._originalProjectTitle = $j(document.getElementsByTagName("title")[0]).html();
            AmetysFront.onDisplayModeChange(function(mode) {
                if (mode == 'standalone') 
                {
                    let title = $j(document.getElementsByTagName("title")[0]);
                    title.html(window._originalProjectTitle.replace(/ - .*$/, ''));
                }
            });
        </script>
    </xsl:template>
    
    <xsl:template name="get-title">
        <xsl:choose>
            <xsl:when test="/cms/page"><xsl:value-of select="/cms/page/@long-title" /><xsl:text> - </xsl:text></xsl:when>
            <xsl:when test="/cms/html/head/title"><xsl:value-of select="/cms/html/head/title" /><xsl:text> - </xsl:text></xsl:when>
        </xsl:choose>
        <xsl:value-of select="project:projectTitle()"/>
    </xsl:template>
    
</xsl:stylesheet>
