<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:exslt="http://exslt.org/common"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n exslt">

    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:import href="skin://stylesheets/static/my-projects.xsl"/>
    <xsl:import href="skin://stylesheets/static/notifications.xsl"/>
    
    <xsl:template name="header">
        <header class="ametys-header">
        
            <div class="ametys-header__container">

                <!-- Logo -->
                <xsl:call-template name="header-main-logo"/>
                    
                <div class="container">
                    <div class="ametys-header-inner">
                        
                        <!-- Main search -->
                        <xsl:call-template name="header-main-search"/>
                        
                        <ul class="ametys-header-invokers-list">
                        
                            <!-- My projects -->
                            <!-- <xsl:call-template name="header-main-projects-item"/> -->
                            
                            <!-- Notifications -->
                            <!-- <xsl:call-template name="header-main-notifications-item"/> -->
                            
                            <!-- User menu -->
                            <xsl:call-template name="header-main-user-item"/>
                        </ul>
                    </div>
                </div>

                <!-- Activity stream -->
                <xsl:call-template name="header-main-activities"/>
            </div>
    
        </header>
    </xsl:template>
    
    <xsl:template name="header-main-logo">
        <a class="ametys-header-logo" href="{$catalogHomeUrl}">
            <img class="ametys-header-logo__img white-logo" src="{ametys:skinURL('templates/common/img/logo.png')}" alt="Ametys" />
            <img class="ametys-header-logo__img color-logo d-none" src="{ametys:skinURL('templates/common/img/logo-colorful.svg')}" alt="Ametys" />
        </a>
    </xsl:template>
    
    <xsl:template name="header-main-search">
         <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_SEARCH')"/>
         
         <xsl:if test="$searchPage/@id">
             <div class="ametys-header-search-wrap">
                <form action="{resolver:resolve('page', $searchPage/@id)}" method="post">
                    <div class="ametys-header-search">
                        <span class="ametys-header-search__icon material-icons search"></span>
                        <input name="textfield" class="ametys-header-search__control" type="text" placeholder="skin.{$skin}:SKIN_MAIN_SEARCH" i18n:attr="placeholder" />
                        <xsl:call-template name="header-main-search-additional-fields"/>
                    </div>
                    <span class="ametys-header-search--mobile">
                        <i class="material-icons">search</i>
                    </span>
                </form>
             </div>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-main-search-additional-fields"/>
    
    <xsl:template name="header-main-projects-item">
        <li class="ametys-header-invokers-list__item ametys-toprojects">
            <a class="ametys-header-invoker" href="#">
                <span class="ametys-header-invoker__icon fas fa-dice-d6"></span>
            </a>
            
            <xsl:call-template name="my-projects"/>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-notifications-item">
        <li class="ametys-header-invokers-list__item ametys-notifications">
            <a class="ametys-header-invoker" href="#">
                <span class="ametys-header-invoker__icon far fa-bell"></span>
                <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger"></span>
            </a>
            
            <xsl:call-template name="notifications"/>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-user-item">
        <li class="ametys-header-invokers-list__item ametys-header-invokers-list__item--last ametys-user">
            <a class="ametys-header-invoker" href="javascript:;">
                <span class="ametys-header-invoker__letter">
                    <img class="img-fluid rounded-circle" src="{$currentUser/user/imgUrl}" alt=""/>
                </span>
                <span class="ametys-header-invoker__text"><xsl:value-of select="$currentUser/user/firstname"></xsl:value-of></span>
            </a>
            <xsl:call-template name="user-menu"/>
        </li>
    </xsl:template>
    
    <xsl:template name="user-menu">
        <div class="ametys-user-list-wrap">
            <div class="ametys-header-invoker">
                <a href="#!" class="ametys-header-invoker__letter"><img class="img-fluid rounded-circle" src="{$currentUser/user/imgUrl}" alt=""/></a>
                <span class="ametys-header-invoker__text">
                    <a href="#" class="ametys-header-invoker__text_name"><xsl:value-of select="$currentUser/user/firstname"/></a>
                    <xsl:choose>
                        <xsl:when test="$currentUser/user/pageId != ''">
                            <a href="{resolver:resolve('page', $currentUser/user/pageId)}" class="ametys-header-invoker__text_profile"><i18n:text i18n:key="SKIN_USER_MENU_SEE_PROFILE" i18n:catalogue="skin.{$skin}"/></a>
                        </xsl:when>
                        <xsl:otherwise>
                            <span class="ametys-header-invoker__text_profile">&#160;</span>
                        </xsl:otherwise>
                    </xsl:choose>
                </span>
            </div>
            <ul class="ametys-user-list">
                <!-- User preferences -->
                <xsl:call-template name="user-menu-preferences"/>
                <!-- Help page -->
                <xsl:call-template name="user-menu-help"/>
                <!-- User statistics -->
                <xsl:call-template name="user-menu-statistics"/>
                <!-- Logout -->
                <xsl:call-template name="user-menu-logout"/>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="user-menu-help">
        <xsl:if test="$catalogSiteName != ''">
            <xsl:variable name="helpPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_HELP')"/>
            <xsl:if test="$helpPage/@id">
                <li>
                    <a href="{resolver:resolve('page', $helpPage/@id)}" data-ametys-mobile-user-link="true">
                        <i class="fas fa-question-circle"></i>
                        <span><i18n:text i18n:key="SKIN_USER_MENU_HELP" i18n:catalogue="skin.{$skin}"/></span>
                    </a>
                </li>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-menu-preferences">
        <xsl:if test="$catalogSiteName != ''">
            <xsl:variable name="prefPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_PREFERENCES', true())"/>
            <xsl:if test="$prefPage/@id">
                <li>
                    <a href="{resolver:resolve('page', $prefPage/@id)}" data-ametys-mobile-user-link="true">
                        <i class="fas fa-cog"></i>
                        <span><i18n:text i18n:key="SKIN_USER_MENU_PREFERENCES" i18n:catalogue="skin.{$skin}"/></span>
                    </a>
                </li>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-menu-statistics">
        <xsl:if test="$catalogSiteName != ''">
            <xsl:variable name="statsPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_STATISTICS', true())"/>
            <xsl:if test="$statsPage/@id">
                <li>
                    <a href="{resolver:resolve('page', $statsPage/@id)}" data-ametys-mobile-user-link="true">
                        <i class="fas fa-chart-bar"></i>
                        <span><i18n:text i18n:key="SKIN_USER_MENU_STATISTICS" i18n:catalogue="skin.{$skin}"/></span>
                    </a>
                </li>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="user-menu-logout">
        <li>
            <a href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html" data-ametys-mobile-user-logout="true" data-ametys-mobile-user-logout-icon="fas fa-sign-out-alt">
                <i class="fas fa-sign-out-alt"></i>
                <span><i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-activities">
         <div class="ametys-header-q-panel">
            <a class="ametys-header-invoker" href="javascript:;" id="qPanel">
                <span class="ametys-header-invoker__icon icon-activity_icon"></span>
                <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger" style="display:none"></span>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>