<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="plugin:web://stylesheets/content/article/article-main.xsl"/>	
	
    <xsl:variable name="displaySections" select="ametys:templateParameter('displaySections')" />
     
    <xsl:template name="common-content-head-css">
        <!-- Richtext Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <!-- End Richtext Styles -->
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
    	<xsl:choose>
    		<xsl:when test="$template = 'login' or $template = 'public-page'">
    			<xsl:call-template name="common-content-body-content-content"/>
    		</xsl:when>
    		<xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="$displaySections = 'true'">
                        <div class="ametys-card">
                            <div class="ametys-card-body">
                                <xsl:call-template name="common-content-body-content-content"/>
                            </div>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <article class="ametys-main__inner--padding ametys-mb-30">
                          <div class="ametys-main__inner__md--inside">
                                <div class="container">
                                    <xsl:call-template name="common-content-body-content-content"/>
                                </div>                        
                          </div>
                        </article>
                    </xsl:otherwise>
                </xsl:choose>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template name="common-content-body-content-title">
        <h1><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content-content">
    	<!-- Title -->
        <xsl:call-template name="common-content-body-content-title"/>
        
        <!-- Main illustration -->
        <xsl:call-template name="common-content-body-image-bigsize">
            <xsl:with-param name="maxWidth" select="'435'"/>
            <xsl:with-param name="maxHeight" select="'260'"/>
        </xsl:call-template>  
        
        <!-- Rich content -->
        <div class="ametys-richtext">
            <xsl:call-template name="common-content-body-content-rich"/>
        </div>
    </xsl:template>
	
</xsl:stylesheet>