<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:math="java.lang.Math" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:str="http://exslt.org/strings"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:stringutils="org.apache.commons.lang3.StringUtils"
    xmlns:exslt="http://exslt.org/common"
    xmlns:uriutils="org.ametys.core.util.URIUtils"
    exclude-result-prefixes="xalan math str ametys user resolver stringutils">  
    
    <xsl:import href="plugin:web://stylesheets/utils.xsl"/>
    
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="site" select="ametys:site()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template name="user-image-url">
        <xsl:param name="login" select="ametys:user()/user/@login"/>                         <!-- user's login -->
        <xsl:param name="population" select="ametys:user()/user/@population"/>               <!-- user's population id -->
        <xsl:param name="imgWidth">40</xsl:param>                                            <!-- dimension of user's avatar -->
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $population, '/', uriutils:encodePath($login), '/image_', $imgWidth, '?lang=', $lang)"/>
    </xsl:template>
    
    <xsl:template name="anonymous-user-img-url">
        <xsl:param name="imgWidth">40</xsl:param>   
        
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/unknown/unknown/image_', $imgWidth, '?lang=', $lang)"/>
    </xsl:template>
    
    <xsl:template name="anonymous-user-name">
        <i18n:text i18n:key="PLUGINS_WORKSPACES_UNKNOWN_USER" i18n:catalogue="plugin.workspaces"/>
    </xsl:template>
    
    <xsl:template name="user-info">
        <xsl:param name="login" select="ametys:user()/user/@login"/>                         <!-- user's login -->
        <xsl:param name="population" select="ametys:user()/user/@population"/>               <!-- user's population id -->
        <xsl:param name="userIdentity"/>                                                     <!-- user's identity as login#populationId -->
        <xsl:param name="imgWidth">40</xsl:param>                                            <!-- dimension of user's avatar -->
        
        <xsl:variable name="fUserIdentity">
            <xsl:choose>
                <xsl:when test="$userIdentity != ''"><xsl:text/><xsl:value-of select="$userIdentity"/></xsl:when>
                <xsl:otherwise><xsl:text/><xsl:value-of select="concat($login, '#', $population)"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="userContentId" select="user:getUserContent($lang, $fUserIdentity)"/>
        <xsl:variable name="userPageId" select="user:getUserPage($userContentId, ametys:config('workspaces.member.userdirectory.site.name'))"/>
        <xsl:variable name="ametysUser" select="ametys:user($fUserIdentity)"/>
         
        <user> 
            <login><xsl:value-of select="$ametysUser/user/@login"/></login>
            <population><xsl:value-of select="$ametysUser/user/@population"/></population>
            <contentId><xsl:value-of select="$userContentId"/></contentId>
            <imgUrl>
                <xsl:call-template name="user-image-url">
                    <xsl:with-param name="login" select="stringutils:substringBeforeLast($fUserIdentity, '#')"/>
                    <xsl:with-param name="population" select="stringutils:substringAfterLast($fUserIdentity, '#')"/>
                    <xsl:with-param name="imgWidth" select="$imgWidth"/>
                </xsl:call-template>
            </imgUrl>
            <xsl:choose>
                <xsl:when test="$userContentId != ''">
                   <xsl:variable name="firstname" select="ametys:contentAttribute($userContentId, 'firstname')"/>
                   <xsl:variable name="lastname" select="ametys:contentAttribute($userContentId, 'lastname')"/>
                   <firstname><xsl:value-of select="$firstname"/></firstname>
                   <lastname><xsl:value-of select="$lastname"/></lastname>
                   <fullname><xsl:value-of select="$firstname"/><xsl:if test="$firstname != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="$lastname"/></fullname>
                   <email><xsl:value-of select="ametys:contentAttribute($userContentId, 'email')"/></email>
                   <role><xsl:value-of select="ametys:contentAttribute($userContentId, 'function')"/></role>
                   <organisation><xsl:value-of select="ametys:contentAttribute($userContentId, 'organisation')"/></organisation>
                   <organisationAccronym><xsl:value-of select="ametys:contentAttribute($userContentId, 'organisation-accronym')"/></organisationAccronym>
                   <contentId><xsl:value-of select="$userContentId"/></contentId>
                </xsl:when>
                <xsl:when test="$ametysUser/user/fullname !=''">
                    <firstname><xsl:value-of select="$ametysUser/user/firstname"/></firstname>
                    <lastname><xsl:value-of select="$ametysUser/user/lastname"/></lastname>
                    <fullname><xsl:value-of select="$ametysUser/user/fullname"/></fullname>
                    <email><xsl:value-of select="$ametysUser/user/email"/></email>
                </xsl:when>
                <xsl:otherwise>
                    <fullname><xsl:value-of select="ametys:translate(concat('skin.', $skin, ':UNKNOWN_USER'))"/></fullname>
                </xsl:otherwise>
            </xsl:choose>
            <pageId><xsl:value-of select="$userPageId"/></pageId>
        </user>
    </xsl:template>
    
</xsl:stylesheet>    