<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                xmlns:math="java.lang.Math"
                xmlns:exslt="http://exslt.org/common"
                exclude-result-prefixes="ametys">
                
	<xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/variables.xsl"/>

    <xsl:template name="common-service-head-css">
       	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/home/scss/main.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/home/scss/print.css')}" />
		
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets/scss/main.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets/scss/print.css')}" />
		
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/comment/scss/main.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/comment/scss/print.css')}" />
        
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/scrollbar/scss/main.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/scrollbar/scss/print.css')}" />
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/truncate.js/truncate.js')}"></script>
        
        <script type="text/javascript">
            $j(document).ready(function(){
                $j('.ametys-scroll-h').mCustomScrollbar({
                    axis:"x",
                    scrollInertia: 10
                });
                
                handleTags();
            });
            
            function cropTextToMaxWidth(text, maxWidth) {
                const offScreenElement = document.createElement('span');
                offScreenElement.style.visibility = 'hidden';
                offScreenElement.style.position = 'absolute';
                offScreenElement.style.whiteSpace = 'nowrap';
                offScreenElement.style.font = 'inherit';
                offScreenElement.textContent = text;
                document.body.appendChild(offScreenElement);

                const textWidth = offScreenElement.offsetWidth;

                document.body.removeChild(offScreenElement);

                if (textWidth > maxWidth) {
                    const croppedText = text.slice(0, Math.floor((maxWidth / textWidth) * text.length));
                    return croppedText + '...';
                }

                return text;
            }
                
            function handleTags() {
                $j('.ametys-portlet .ametys-portlet__bottom').each(function() {
                    const widthItem = $j(this).width(); // portlet bottom width
                    const maxTextWith = widthItem - 16; // available width of tag text
                    
                    const tags = $j(this).find(".ametys-tag");
                    const nbTags = tags.length;
                    const counterWidth = 43; // counter width "+X"
                    
                    let widthTags = $j(this).position().left; // left position of tags
                    $j(tags).each(function() {
                        widthTags += $j(this).outerWidth(true); // width with padding and margin including
                    });
                    
                    if (widthTags > widthItem) {
                        let tagText = '';
                        let widthTagIncrement = 0;
                        let countTagHide = 0;
                        $j(tags).each(function(index) {
                            widthTagIncrement += $j(this).outerWidth(true); // width with padding and margin including
                            if (widthTagIncrement + counterWidth > widthItem) {
                                if (index === 0 &amp;&amp; tags.length == 1) {
                                    const text = $j(this).text();
                                    $j(this).text(cropTextToMaxWidth(text, maxTextWith));
                                    $j(this).attr('data-ametys-tooltip', text);
                                } else if (index === 0 &amp;&amp; tags.length > 1) {
                                    const text = $j(this).text();
                                    $j(this).text(cropTextToMaxWidth(text, maxTextWith - counterWidth));
                                    $j(this).attr('data-ametys-tooltip', text);
                                } else {
                                    $j(this).hide();
                                    tagText += $j(this).text() + ', ';
                                    countTagHide++;
                                }
                            }
                        });
                        tagText = tagText.slice(0, -2);
                        if (countTagHide > 0) {
                            // Display counter
                            $j(this).append(`&lt;span data-ametys-tooltip="${tagText}" class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent-light">&lt;i class="fas fa-plus" aria-hidden="true"&gt;&lt;/i&gt;${countTagHide}&lt;/span>`);
                        }
                    }
                });
            }
        </script>
        
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
	    <div class="ametys-home-top">
			<div class="ametys-scroll-h">
			    <div class="ametys-home-top__list">
                     <xsl:if test="count(/search/hits/hit) &lt; 4">
                        <xsl:call-template name="welcome-card"/>
                     </xsl:if>
                     
                     <xsl:call-template name="add-news-card"/>
                     
			         <xsl:apply-templates select="/search/hits/hit"/>
			    </div>
			</div>
		</div>
    </xsl:template>
    
    <xsl:template match="hit">
        <xsl:apply-templates select="content/html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level" select="'1'"/>
        </xsl:apply-templates>                           
    </xsl:template>
    
    <xsl:template name="welcome-card">
        <!-- TODO This card should be a content -->
        <div class="ametys-home-top__list__item ametys-home-top__list__item--purple">
            <div class="ametys-portlet">
                <div class="ametys-portlet__top px-3 pt-2 ametys-mb-2rem">
                    <div class="ametys-portlet__top__header">
                        <i class="fas fa-bullhorn"></i>
                        <i18n:text i18n:key="SKIN_HOME_NEWS_CAROUSEL_WELCOME_CARD_TITLE" i18n:catalogue="skin.{$skin}"/>
                    </div>
                </div>
                <div class="ametys-portlet__content ametys-portlet__llist--height px-3">
                    <ul class="ametys-portlet__content_numlist">
                        <li>
                            <a href="#"><i18n:text i18n:key="SKIN_HOME_NEWS_CAROUSEL_WELCOME_CARD_ITEM1_TEXT" i18n:catalogue="skin.{$skin}"/></a>
                        </li>
                        <li>
                            <a href="#"><i18n:text i18n:key="SKIN_HOME_NEWS_CAROUSEL_WELCOME_CARD_ITEM2_TEXT" i18n:catalogue="skin.{$skin}"/></a>
                        </li>
                    </ul>
                </div>
                <div class="ametys-portlet__bottom"></div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="add-news-card">
        
        <xsl:variable name="rootNewsPageId" select="ametys-front-edition:findPagesIdsByTagInDefaultWorkspace('NEWS_ROOT')/@id"/>
        
        <xsl:if test="$rootNewsPageId and ametys:renderingContext() = 'front' and ametys-front-edition:hasFrontEditionRight('Web_Rights_Page_Create', $rootNewsPageId, false())">
            <div class="ametys-home-top__list__item ametys-home-top__list__item--purple">
                <div class="ametys-portlet">
                    
                    <xsl:call-template name="add-news-card-top"/>
                    
                    <xsl:call-template name="add-news-card-content">
                        <xsl:with-param name="rootNewsPageId" select="$rootNewsPageId"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="add-news-card-bottom"/>
                    
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="add-news-card-top">
        <xsl:variable name="rawCurrentUser">
            <xsl:call-template name="user-info"/>
        </xsl:variable>
        <xsl:variable name="currentUser" select="exslt:node-set($rawCurrentUser)"/>
        
        <div class="ametys-portlet__top">
            <a href="#" class="ametys-portlet__top-user">
                <div class="ametys-portlet__top_img ametys-portlet__top_img--empty">
                    <img class="img-fluid rounded-circle" src="{$currentUser/user/imgUrl}" alt=""/>
                </div>
                <div class="ametys-portlet__top_user">
                    <h3><xsl:value-of select="$currentUser/user/fullname"/></h3>
                    <xsl:if test="$currentUser/user/organisationAccronym != ''">
                        <span class="ametys-tag ametys-tag--xs ametys-tag--gray ametys-truncate-1"><xsl:value-of select="$currentUser/user/organisationAccronym"/></span>
                    </xsl:if>
                </div>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="add-news-card-content">
        <xsl:param name="rootNewsPageId"/>
        
        <div class="ametys-portlet__content">
            <xsl:call-template name="ametys-front-edition-insert-create-page-button">
                <xsl:with-param name="page-id" select="$rootNewsPageId"/>
                <xsl:with-param name="title-i18n"><xsl:value-of select="concat('skin.', $skin, ':SKIN_HOME_NEWS_CAROUSEL_ADD_NEWS_BTN_TITLE')"/></xsl:with-param>
                <xsl:with-param name="button-text"><h2 class="ametys-truncate" data-lines="2"><i18n:text i18n:key="SKIN_HOME_NEWS_CAROUSEL_ADD_NEWS" i18n:catalogue="skin.{$skin}"/></h2><span class="ametys-portlet__content_newproj_icn"><i class="fas fa-pen"></i></span></xsl:with-param>
                <xsl:with-param name="edition-mode-only" select="false()"/>
                <xsl:with-param name="class">ametys-portlet__content_newproj</xsl:with-param>
                <xsl:with-param name="callback">function(page)
                    {
                        var path = AmetysFrontEdition.CONTEXT_PATH + "/" + AmetysFrontEdition.LANG + "/" + page.getPath() + ".html";
                        window.location.href = path;
                    }
                </xsl:with-param>
                <xsl:with-param name="config">{
                    "title": "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_HOME_NEWS_CAROUSEL_ADD_NEWS_DIALOG_TITLE')))"/>",
                    "force": true,
                    "workflowInitActionId": "14", 
                    "show-card-content" : false, 
                    "show-card-type" : false,  
                    "show-card-tags" : true,
                    "show-card-content-properties" : false,
                    "pagecontent-card-tags-categories-filter": ["provider_org.ametys.plugins.workspaces.categories.CategoryTagProvider", "provider_org.ametys.plugins.workspaces.keywords.KeywordTagProvider"],
                    "pagecontent-card-tags-categories-filter-only-subcategories": false,
                    "default-pagetype" : "template",
                    "default-template" : "page",
                    "default-zone" : "default",
                    "default-pagecontent-type" : "contenttype",
                    "default-contenttype" :  "org.ametys.plugins.workspaces.Content.catalogNews",
                    "default-page-title" : "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_HOME_NEWS_CAROUSEL_ADD_NEWS_DEFAULT_TITLE')))"/>",
                    "default-contenttype-label" : "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_HOME_NEWS_CAROUSEL_ADD_NEWS_CONTENT_TYPE_LABEL')))"/>",
                    "pagecontent-service" : false}
                    </xsl:with-param>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="add-news-card-bottom">
        <div class="ametys-comment-vote mt-auto">
            <span class="ametys-comment-vote__item">
                <i class="far fa-comment ametys-color-white"></i>
            </span>
        </div>
        <div class="ametys-portlet__bottom"></div>
    </xsl:template>
    
    <xsl:template name="ametys-front-edition-insert-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
            <a class="{$class}" title="{$title-i18n}" i18n:attr="title" href="javascript:void(0)" onclick="{$javascript-function}"><xsl:copy-of select="$button-text"/></a>
    </xsl:template>
    
</xsl:stylesheet>
