<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="math ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/user-password/password_3.5.xsl"/>
    <xsl:import href="service:web://pages/services/contenttype/helper/form.xsl"/>
    
    <xsl:template name="common-service-head-css">
    	<!-- Signup Page Styles -->
		<link rel="stylesheet" href="{ametys:skinURL('pages/password/scss/main.css')}" />
		<link rel="stylesheet" href="{ametys:skinURL('pages/password/scss/print.css')}" />
		<!-- END::Signup Page Styles -->
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="strong-password-head-js"/>
        
        <script type="text/javascript">
             $j(document).ready(function() {
                $j('.user-account.user-password form .field input').each(function(i, input) {
                    var label = $j(input).closest('.field').find('.label label').text();
                    $j(input).attr('placeholder', label);
                })
                
                $j('.user-account.user-password form .input select').selectpicker({
				    width: '100%'
			    });
             });
        </script>
    </xsl:template>
   
</xsl:stylesheet>
