<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                extension-element-prefixes="ametys resolver docbook">
    
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>
    
    <xsl:import href="plugin:cms://stylesheets/utils.xsl"/>
    <xsl:import href="docbookenhancement://docbook2html.xsl"/>
    
    <xsl:template match="hit">
        <li class="ametys-search-list__item" data-module-hit="true">
            <div class="ametys-search-item">
                <a class="ametys-search-item__full-link" href="{resolver:resolve('page', page)}"></a>
                
                <div class="ametys-search-item-header">
                    <div class="ametys-document">
                        <xsl:call-template name="content-image"/>
                         
                        <div class="ametys-document-info">
                            <xsl:call-template name="content-title"/>
                        
                            <xsl:call-template name="content-abstract"/>
                        </div>
                    </div>
                </div>
                
                <div class="ametys-search-item-info">
                    <div class="ametys-search-item-info__item">
                        <div class="ametys-schedule">
                            <xsl:call-template name="project"/>
                            <ul class="ametys-schedule-list">
                                <li class="ametys-schedule-list__item">
                                    <xsl:call-template name="content-date"/>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </li>
    </xsl:template> 
    
    <xsl:template name="content-image">
        <xsl:if test="attributes/illustration/image">
            <div class="ametys-document-img">
                <xsl:copy-of select="attributes/illustration/image"></xsl:copy-of>
                <img src="{resolver:resolveCroppedImage(attributes/illustration/image/@type, attributes/illustration/image/@uri, 97, 120)}" style="width: 100%;" alt=""/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-title">
        <h3 class="ametys-document-info__name"><xsl:value-of select="attributes/title"/></h3>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <div class="ametys-document-info__size">
             <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="text" select="attributes/abstract"/>
                <xsl:with-param name="defaultText" select="attributes/content/docbook:article"/>
                <xsl:with-param name="maxDefaultTextSize" select="'400'"/>
            </xsl:call-template> 
        </div>
    </xsl:template>
    
    <xsl:template name="content-date">
        <i class="ametys-schedule-list__item-icon far fa-clock"></i>
        
        <xsl:choose>
            <xsl:when test="@lastModifiedAt">
                <xsl:call-template name="format-date">
                    <xsl:with-param name="date" select="@lastModifiedAt"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="format-date">
                    <xsl:with-param name="date" select="@createdAt"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>