<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/tasks.xsl"/>
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>
    
    <xsl:template match="hit">
    	<li class="ametys-search-list__item" data-module-hit="true">
			<div class="ametys-search-item">
				<a class="ametys-search-item__full-link" href="{uri}"></a>
				
				<div class="ametys-search-item-header">
					<div class="ametys-document">
						<div class="ametys-document-info">
							<xsl:call-template name="label"/>
							<xsl:call-template name="description"/>
							<xsl:call-template name="assignment"/>
						</div>
					</div>
				</div>
				
				<div class="ametys-search-item-info">
					<div class="ametys-search-item-info__item">
						<div class="ametys-schedule">
							<xsl:call-template name="project"/>
							<xsl:call-template name="status"/>
						</div>
					</div>
				</div>
			</div>
		</li>
    </xsl:template> 
    
    <xsl:template name="label">
		<h4 class="ametys-document-info__name"><xsl:value-of select="label"/></h4>
	</xsl:template>
	
	<xsl:template name="description">
		<div class="ametys-document-info__size ametys-truncate" data-lines="2">
			<xsl:value-of select="description"/>
		</div>
	</xsl:template>
    
    <xsl:template name="assignment">
		<xsl:if test="assignments/assignment">
			<ul class="ametys-membres-list ametys-membres-list--reversed ametys-membres-list--md ametys-membres-list--border-0 list-unstyled">
				<xsl:choose>
				    <xsl:when test="count(assignments/assignment) &lt; 3">
				        <xsl:for-each select="assignments/assignment">
							<li>
								<xsl:call-template name="user-img">
								    <xsl:with-param name="user" select="." />
								</xsl:call-template>
							</li>
				        </xsl:for-each>
				    </xsl:when>
				    <xsl:otherwise>
				        <xsl:for-each select="assignments/assignment[position() = 1]">
                            <li>
                                <xsl:call-template name="user-img">
                                    <xsl:with-param name="user" select="." />
                                </xsl:call-template>
                            </li>
                        </xsl:for-each>
						<li class="ametys-membres-list-qty">
							<i class="fas fa-plus"></i>
							<xsl:value-of select="count(assignments/assignment) - 1"/>
						</li>
				    </xsl:otherwise>
				</xsl:choose>
			</ul>
		</xsl:if>
	</xsl:template>
    
    <xsl:template name="user-img">
        <xsl:param name="user" />
        
        <xsl:variable name="imgUrl" select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $user/@population, '/', uriutils:encodePath($user/@login), '/image_56?lang=', $lang)"/>
        		        
		<img src="{$imgUrl}" alt="" title="{$user/fullname}"/>
	</xsl:template>
	
	<xsl:template name="status">
		<span class="btn btn-sm btn-light px-3">
			<xsl:choose>
				<xsl:when test="isClosed = 'true'">
				    <i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_MODULE_TASKS_DISPLAY_CLOSED" i18n:catalogue="plugin.workspaces"/>
                </xsl:when>
				<xsl:when test="isClosed = 'false'">
					<i18n:text i18n:key="PLUGINS_WORKSPACES_MODULAR_SEARCH_MODULE_TASKS_DISPLAY_OPEN" i18n:catalogue="plugin.workspaces"/>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</span>
	</xsl:template>
    
</xsl:stylesheet>