<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                xmlns:math="java.lang.Math"
                xmlns:exslt="http://exslt.org/common"
                exclude-result-prefixes="ametys">
                
	<xsl:import href="plugin:web://pages/services/search/search-more-results.xsl"/>  
    
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/variables.xsl"/>

    <xsl:template name="common-service-head-css">
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets/scss/main.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets/scss/print.css')}" />
		
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets-search/scss/main.css')}" />
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/portlets-search/scss/print.css')}" />
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="search-service-head-js"/>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/truncate.js/truncate.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering"/>
    
    <xsl:template name="hits">
        <div class="ametys-search-portlets__list" data-ametys-search-role="hits">
            <xsl:for-each select="/search/hits/hit">
                <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-search-portlets__list__item<xsl:text> </xsl:text>
    </xsl:template>
    
    <xsl:template name="pagination-more-results">
        <xsl:if test="/search/pagination/@total > 1">
            <div class="ametys-loadmore" data-ametys-search-role="show-more">
                <xsl:attribute name="onclick"><xsl:call-template name="search-js-next-page"/></xsl:attribute>
                <div>
                    <i class="fas fa-sync" title="plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_MORE_RESULTS" i18n:attr="title"></i>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- Template for no result -->
    <xsl:template name="no-result">
        <div class="no-result" data-ametys-search-role="no-result">
            <p><i18n:text i18n:key="SKIN_SEARCH_SERVICE_NO_NEWS" i18n:catalogue="skin.{$skin}"/></p>
        </div>
    </xsl:template>
</xsl:stylesheet>
