/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.actions;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.tag.Tag;
import org.ametys.plugins.calendar.events.EventsFilter;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;

public class SetFilterInRequestAttributesAction
extends org.ametys.web.repository.page.actions.SetFilterInRequestAttributesAction
implements Contextualizable {
    protected EventsFilterHelper _eventsFilterHelper;
    protected AmetysObjectResolver _ametysResolver;
    protected Context _context;
    private String _view;
    private String _rangeType;
    private Set<Tag> _categories;
    private int _year;
    private int _month;
    private int _day;
    private int _monthsBefore;
    private int _monthsAfter;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._eventsFilterHelper = (EventsFilterHelper)((Object)smanager.lookup(EventsFilterHelper.ROLE));
        this._ametysResolver = (AmetysObjectResolver)this.manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected WebContentFilter _getFilterFromZoneItem(Parameters parameters, Map<String, String> result) throws ParameterException {
        Map parentContextAttrs = (Map)ContextHelper.getObjectModel((Context)this._context).get("parent-context");
        if (parentContextAttrs == null) {
            parentContextAttrs = Collections.EMPTY_MAP;
        }
        WebContentFilter filter = null;
        String zoneItemId = parameters.getParameter("zoneItemId");
        this._view = parameters.getParameter("view");
        LocalDate today = LocalDate.now();
        this._year = parameters.getParameterAsInteger("year", today.getYear());
        this._month = parameters.getParameterAsInteger("month", today.getMonthValue());
        this._day = parameters.getParameterAsInteger("day", today.getDayOfMonth());
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById("zoneItem://" + zoneItemId);
        if (this._isValid(zoneItem)) {
            this._monthsBefore = Math.toIntExact((Long)zoneItem.getServiceParameters().getValue("months-before", true, (Object)3L));
            this._monthsAfter = Math.toIntExact((Long)zoneItem.getServiceParameters().getValue("months-after", true, (Object)3L));
            this._rangeType = parameters.getParameter("rangeType", this._eventsFilterHelper.getDefaultRangeType(zoneItem));
            String siteName = zoneItem.getZone().getSitemapElement().getSiteName();
            List<Map<String, Object>> searchValues = this._eventsFilterHelper.getSearchContext(zoneItem, (List)parentContextAttrs.get("search"));
            this._categories = this._eventsFilterHelper.getTagCategories(zoneItem, searchValues, siteName);
            filter = this._getFilterFromZoneItem(zoneItem);
        }
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        result.put("siteName", sitemapElement.getSiteName());
        result.put("lang", sitemapElement.getSitemapName());
        result.put("path", sitemapElement.getPathInSitemap());
        return filter;
    }

    protected WebContentFilter _getFilterFromZoneItem(ZoneItem zoneItem) throws ParameterException {
        String zoneItemId = zoneItem.getId();
        EventsFilter filter = new EventsFilter(zoneItemId, this._ametysResolver, this._contentTypeEP, this._siteManager, this._tagProviderEP);
        filter.addSortCriteria("start-date", false, true);
        filter.addSortCriteria("end-date", false, true);
        filter.setLength(Integer.MAX_VALUE);
        String type = "agenda";
        EventsFilterHelper.DateTimeRange dateRange = this._eventsFilterHelper.getDateRange(type, this._year, this._month, this._day, this._monthsBefore, this._monthsAfter, this._rangeType);
        Expression expression = this._eventsFilterHelper.getExpression(type, dateRange);
        Set<String> contentTypes = this._eventsFilterHelper.getContentTypes(zoneItem);
        boolean maskOrphan = this._eventsFilterHelper.getMaskOrphan(zoneItem);
        WebContentFilter.AccessLimitation accessLimitation = this._eventsFilterHelper.getAccessLimitation(zoneItem);
        Set<String> categoryTags = this._eventsFilterHelper.getAllTags(this._categories);
        filter.setTitle(new I18nizableText(this._eventsFilterHelper.getTitle(zoneItem)));
        List<Map<String, Object>> searchValues = this._eventsFilterHelper.getSearchContext(zoneItem, null);
        this._eventsFilterHelper.configureFilter(filter, expression, contentTypes, searchValues, categoryTags, this._view, maskOrphan, accessLimitation);
        return filter;
    }

    protected boolean _isValid(ZoneItem zoneItem) {
        return zoneItem.getType().equals((Object)ZoneItem.ZoneType.SERVICE) && "org.ametys.plugins.calendar.Agenda".equals(zoneItem.getServiceId());
    }
}

