/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.events;

import java.util.HashSet;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.web.filter.DefaultWebContentFilter;
import org.ametys.web.filter.StaticWebContentFilter;
import org.ametys.web.filter.WebContentFilter;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.tags.TagExpression;

public class EventsFilter
extends StaticWebContentFilter {
    protected Expression _metadataExpression;

    public EventsFilter() {
    }

    public EventsFilter(String id, AmetysObjectResolver resolver, ContentTypeExtensionPoint contentTypeExtensionPoint, SiteManager siteManager, TagProviderExtensionPoint tagProviderEP) {
        super(id, resolver, contentTypeExtensionPoint, siteManager, tagProviderEP);
    }

    public EventsFilter(String id, EventsFilter originalFilter, AmetysObjectResolver resolver, ContentTypeExtensionPoint contentTypeExtensionPoint, SiteManager siteManager, TagProviderExtensionPoint tagProviderEP) {
        super(id, (StaticWebContentFilter)originalFilter, resolver, contentTypeExtensionPoint, siteManager, tagProviderEP);
    }

    public void setMetadataExpression(Expression expression) {
        this._metadataExpression = expression;
    }

    public Expression getMetadataExpression() {
        if (this._metadataExpression == null) {
            return super.getMetadataExpression();
        }
        return this._metadataExpression;
    }

    public WebContentFilter.FilterSearchContext createSeachContext() {
        return new EventFilterSearchContext(this, this._siteManager);
    }

    public void clearSearchContexts() {
        this._searchContexts.clear();
    }

    public class EventFilterSearchContext
    extends DefaultWebContentFilter.DefaultFilterSearchContext {
        protected Set<String> _orTags = new HashSet<String>();

        protected EventFilterSearchContext(EventsFilter this$0, SiteManager siteManager) {
            super((DefaultWebContentFilter)this$0, siteManager);
        }

        public Set<String> getOrTags() {
            return this._orTags;
        }

        public void setOrTags(Set<String> tags) {
            this._orTags = new HashSet<String>(tags);
        }

        public void addOrTag(String tagName) {
            this._orTags.add(tagName);
        }

        public Expression getTagsExpression(String siteName) {
            Expression tagExpr = super.getTagsExpression(siteName);
            Expression expr = null;
            if (!this._orTags.isEmpty()) {
                Expression[] tagExprArray = new Expression[this._orTags.size()];
                int i = 0;
                for (String tag : this._orTags) {
                    tagExprArray[i] = new TagExpression(Expression.Operator.EQ, tag);
                    ++i;
                }
                expr = tagExpr != null ? new AndExpression(new Expression[]{tagExpr, new OrExpression(tagExprArray)}) : new OrExpression(tagExprArray);
            } else {
                expr = tagExpr;
            }
            return expr;
        }
    }
}

