/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.icsreader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.filter.predicate.PeriodRule;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import org.ametys.cms.tag.Tag;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.plugins.calendar.icsreader.CacheKey;
import org.ametys.plugins.calendar.icsreader.LocalVEvent;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class IcsReader
implements Serviceable,
Component,
Initializable,
LogEnabled {
    public static final String ROLE = IcsReader.class.getName();
    private static final String __ICS_CACHE_ID = IcsReader.class.getName() + "$icsCache";
    private static final int __ICS_CONNECTION_TIMEOUT = 2000;
    private static final int __ICS_READ_TIMEOUT = 10000;
    protected Logger _logger;
    private AbstractCacheManager _abstractCacheManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._abstractCacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
    }

    public IcsEvents getEventList(String url, EventsFilterHelper.DateTimeRange dateRange, Long nbEvents, Long maxFileSize) {
        this.getLogger().debug("Fetch ics url : {}", (Object)url);
        CacheKey cacheKey = new CacheKey(url, dateRange, nbEvents, maxFileSize);
        Cache<CacheKey, IcsEvents> cache = this.getIcsCache();
        return (IcsEvents)cache.get((Object)cacheKey, key -> this._getEventList(url, dateRange, nbEvents, maxFileSize));
    }

    protected IcsEvents _getEventList(String url, EventsFilterHelper.DateTimeRange dateRange, Long nbEvents, Long maxFileSize) {
        IcsEvents icsEvents;
        block13: {
            long fileSize = this.getFileSize(url);
            if (fileSize > maxFileSize) {
                this.getLogger().warn("ICS File is too big : {}", (Object)url);
                return new IcsEvents(url, null, IcsEvents.Status.OVERSIZED);
            }
            URL icsUrl = new URI(url).toURL();
            HttpURLConnection connection = (HttpURLConnection)icsUrl.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(10000);
            String userInfo = icsUrl.getUserInfo();
            if (userInfo != null) {
                String basicAuth = "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", basicAuth);
            }
            InputStream body = connection.getInputStream();
            try {
                List componentList;
                CalendarBuilder builder = new CalendarBuilder();
                Calendar calendar = builder.build(body);
                this.getLogger().debug("Calendar is built for url : {}", (Object)url);
                List components = calendar.getComponents(new String[]{"VEVENT"});
                if (dateRange != null) {
                    Period period = new Period((Temporal)dateRange.fromDate(), (Temporal)dateRange.untilDate());
                    componentList = components.stream().filter(new PeriodRule(period)).toList();
                } else {
                    componentList = components;
                }
                this.getLogger().debug("Calendar is filtered for url : {}", (Object)url);
                ArrayList<VEvent> eventList = new ArrayList<VEvent>();
                Long nbEventsRemaining = nbEvents;
                for (CalendarComponent calendarComponent : componentList) {
                    if (nbEventsRemaining <= 0L) break;
                    if (!(calendarComponent instanceof VEvent)) continue;
                    eventList.add((VEvent)calendarComponent);
                    Long l = nbEventsRemaining;
                    nbEventsRemaining = nbEventsRemaining - 1L;
                }
                this.getLogger().debug("List is generated for url : {}", (Object)url);
                icsEvents = new IcsEvents(url, eventList);
                if (body == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Error while reading ics with url = '" + url + "'", (Throwable)e);
                    return new IcsEvents(url, null, IcsEvents.Status.ERROR);
                }
            }
            body.close();
        }
        return icsEvents;
    }

    public void initialize() throws Exception {
        System.setProperty("ical4j.unfolding.relaxed", "true");
        System.setProperty("net.fortuna.ical4j.timezone.cache.impl", "net.fortuna.ical4j.util.MapTimeZoneCache");
        Long cacheTtlConf = (Long)Config.getInstance().getValue("org.ametys.plugins.calendar.ics.reader.cache.ttl");
        Long cacheTtl = cacheTtlConf != null && cacheTtlConf.intValue() > 0 ? cacheTtlConf.intValue() : 60;
        Duration duration = Duration.ofMinutes(cacheTtl);
        this._abstractCacheManager.createMemoryCache(__ICS_CACHE_ID, new I18nizableText("plugin.calendar", "CALENDAR_SERVICE_AGENDA_ICS_CACHE_LABEL"), new I18nizableText("plugin.calendar", "CALENDAR_SERVICE_AGENDA_ICS_CACHE_DESC"), false, duration);
    }

    private Cache<CacheKey, IcsEvents> getIcsCache() {
        return this._abstractCacheManager.get(__ICS_CACHE_ID);
    }

    private long getFileSize(String url) throws IOException, URISyntaxException {
        this.getLogger().debug("Start to try to determine size of the file : {}", (Object)url);
        URL icsUrl = new URI(url).toURL();
        HttpURLConnection connection = (HttpURLConnection)icsUrl.openConnection();
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(10000);
        long nbByte = connection.getContentLengthLong();
        if (nbByte < 0L) {
            try (InputStream flux = connection.getInputStream();){
                this.getLogger().debug("Unable to get size from header, we download the file : {}", (Object)url);
                nbByte = 0L;
                while (flux.read() != -1) {
                    ++nbByte;
                }
            }
        }
        this.getLogger().debug("End of estimation of the size of the file, {} bytes : {}", (Object)nbByte, (Object)url);
        return nbByte;
    }

    public List<LocalVEvent> getEventDates(VEvent event, EventsFilterHelper.DateTimeRange dateRange, Tag tag) {
        ArrayList<LocalVEvent> result = new ArrayList<LocalVEvent>();
        Property rRuleProperty = event.getProperty("RRULE").orElse(null);
        if (rRuleProperty instanceof RRule) {
            RRule rRule = (RRule)rRuleProperty;
            DtStart dtStart = event.getDateTimeStart();
            DtEnd dtEnd = event.getDateTimeEnd();
            if (dtStart != null && dtEnd != null) {
                if (dateRange != null) {
                    long eventDurationInMs = this._toInstant((DateProperty)dtEnd).toEpochMilli() - this._toInstant((DateProperty)dtStart).toEpochMilli();
                    List dates = rRule.getRecur().getDates(dtStart.getDate(), (Temporal)dateRange.fromDate(), (Temporal)dateRange.untilDate());
                    for (Temporal startTemporal : dates) {
                        ZonedDateTime startDate = this._toZonedDateTime(startTemporal);
                        long eventEnd = startDate.toInstant().toEpochMilli() + eventDurationInMs;
                        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(eventEnd), ZoneOffset.UTC);
                        if (dtEnd.getDate() instanceof LocalDate) {
                            endDate = endDate.minus(1L, ChronoUnit.DAYS);
                        }
                        result.add(new LocalVEvent(event, startDate, endDate, tag));
                    }
                } else {
                    this.getLogger().debug("Impossible to get the list of events without a date range, it can be too much");
                }
            }
        } else {
            ZonedDateTime startDate = this._getEventDateTime((CalendarComponent)event, "DTSTART");
            ZonedDateTime endDate = this._getEventDateTime((CalendarComponent)event, "DTEND");
            if (startDate == null && endDate == null) {
                return result;
            }
            if (startDate == null) {
                startDate = endDate;
            } else if (endDate == null) {
                endDate = startDate;
            }
            result.add(new LocalVEvent(event, startDate, endDate, tag));
        }
        return result;
    }

    private Instant _toInstant(DateProperty property) {
        return Instant.from(property.getDate());
    }

    private ZonedDateTime _getEventDateTime(CalendarComponent event, String propertyName) {
        Property property = event.getProperty(propertyName).orElse(null);
        if (property instanceof DateProperty) {
            DateProperty dateProperty = (DateProperty)property;
            Temporal result = dateProperty.getDate();
            if (result != null && "DTEND".equals(propertyName) && result instanceof LocalDate) {
                LocalDate date = (LocalDate)result;
                result = date.minus(1L, ChronoUnit.DAYS);
            }
            return this._toZonedDateTime(result);
        }
        return null;
    }

    private ZonedDateTime _toZonedDateTime(Temporal temporal) {
        if (temporal instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)temporal;
            return zonedDateTime;
        }
        if (temporal instanceof LocalDate) {
            LocalDate date = (LocalDate)temporal;
            return date.atStartOfDay(ZoneOffset.UTC);
        }
        if (temporal instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)temporal;
            offsetDateTime.toZonedDateTime();
        }
        return ZonedDateTime.from(temporal);
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    private Logger getLogger() {
        return this._logger;
    }

    public static class IcsEvents {
        private String _url;
        private List<VEvent> _events;
        private Status _status;
        private Tag _tag;

        public IcsEvents(String url, List<VEvent> events) {
            this(url, events, Status.OK);
        }

        public IcsEvents(String url, List<VEvent> events, Status status) {
            this._url = url;
            this._events = events;
            this._tag = null;
            this._status = status;
        }

        public String getUrl() {
            return this._url;
        }

        public boolean hasEvents() {
            return this._events != null && this._events.size() > 0;
        }

        public List<VEvent> getEvents() {
            return this._events;
        }

        public Tag getTag() {
            return this._tag;
        }

        public void setTag(Tag tag) {
            this._tag = tag;
        }

        public Status getStatus() {
            return this._status;
        }

        public static enum Status {
            OVERSIZED,
            ERROR,
            OK;

        }
    }
}

