<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="http://exslt.org/math"
                exclude-result-prefixes="resolver math">

    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>

	<xsl:variable name="view">abstract</xsl:variable>
	
	<xsl:variable name="date" select="concat(/events/@year, '-', /events/@month, '-', /events/@day)"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">events-calendar events-calendar-list filtered-contents-<xsl:value-of select="$view"/> wrapper</xsl:variable>
    <xsl:variable name="is-empty" select="not(/events)"/> 
    <xsl:variable name="common-service-name-id">service-calendar-list</xsl:variable>  	

    <!-- +
         | HEAD
         + -->    
         
    <xsl:template name="common-service-head-other">    
        <xsl:call-template name="contents-css"/>    
        <xsl:call-template name="contents-js"/>    
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
<!--         <xsl:call-template name="common-service-head-title-content"> -->
<!--             <xsl:with-param name="title"> -->
<!--                 <i18n:translate> -->
<!--                     <i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_DAY_EVENTS_TITLE"/> -->
<!--                     <i18n:param> -->
<!--                         <i18n:date src-pattern="yyyy-MM-dd" pattern="d MMMM yyyy" value="{$date}"/> -->
<!--                     </i18n:param> -->
<!--                 </i18n:translate> -->
<!--             </xsl:with-param> -->
<!--         </xsl:call-template> -->
    </xsl:template>
    
    <xsl:template name="contents-css">
        <xsl:for-each select="/events/contents/event/view/content/html/head/link">
            <xsl:variable name="href" select="@href"/>
            <xsl:variable name="media" select="@media"/>
            <xsl:variable name="type" select="@type"/>
            <xsl:variable name="rel" select="@rel"/>
        
            <xsl:if test="not(preceding::link[local-name(..) = 'head' and local-name(../..) = 'html' and local-name(../../..) = 'content' and local-name(../../../..) = 'contents' and count(ancestor::*) = 4 and not(@href != $href) and not(@media != $media) and not(@type != $type) and not(@rel != $rel)])">
               <xsl:copy-of select="."/>
            </xsl:if>
        </xsl:for-each>
        <xsl:copy-of select="/events/contents/event/view/content/html/head/style"/>
    </xsl:template>
    
    <xsl:template name="contents-js">
        <xsl:copy-of select="/events/contents/event/view/content/html/head/script"/>
    </xsl:template>
	
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title">
                <i18n:translate>
                    <i18n:text i18n:key="CALENDAR_SERVICE_CALENDAR_DAY_EVENTS_TITLE"/>
                    <i18n:param>
                        <i18n:date src-pattern="yyyy-MM-dd" pattern="d MMMM yyyy" value="{$date}"/>
                    </i18n:param>
                </i18n:translate>
                <xsl:text> </xsl:text><!-- this line is for a bug in helper that skip non text nodes -->            
            </xsl:with-param>
        </xsl:call-template>    
    </xsl:template>         
        
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:if test="/events/contents/event/view/content">     
        	<ul>       
            	<xsl:apply-templates select="/events/contents/event/view/content"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content">
    	<li>
            <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
                <xsl:with-param name="level" select="2"/>
            </xsl:apply-templates>
        </li>
    </xsl:template>
	
</xsl:stylesheet>
