/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.calendar.search;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.web.frontoffice.search.SearchService;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.service.ServiceExtensionPoint;

/**
 * Action to determine if the result search page of the {@link CalendarSearchService} instance corresponding to the given {@link ZoneItem} id is cacheable.
 */
public class IsSearchResultCacheableAction extends org.ametys.web.frontoffice.search.requesttime.IsSearchResultCacheableAction
{
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        ServiceExtensionPoint serviceEP = (ServiceExtensionPoint) smanager.lookup(ServiceExtensionPoint.ROLE);
        _searchService = (SearchService) serviceEP.getExtension(CalendarSearchService.SERVICE_ID);
    }
}
