<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:exsl="http://exslt.org/common"
    xmlns:text="http://ametys.org/text/3.0"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:math="java.lang.Math"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:encoder="java.net.URLEncoder"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    extension-element-prefixes="exsl text resolver math ametys encoder event escaper">
    
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="pagePath" select="/events/@page-path"/>
    <xsl:variable name="zoneItemId" select="/events/@zoneItemId"/>
    <xsl:variable name="encZoneItemId" select="encoder:encode(encoder:encode($zoneItemId, 'UTF-8'), 'UTF-8')"/>
    <xsl:variable name="pdfDownload" select="/events/@pdf-download"/>
    <xsl:variable name="icalDownload" select="/events/@ical-download"/>
    <xsl:variable name="link" select="/events/@link"/>
    <xsl:variable name="rssUrl" select="/events/rssUrl"/>
    <xsl:variable name="linkTitle" select="/events/@link-title"/>
    <xsl:variable name="rangeType" select="/events/@range"/>
    <xsl:variable name="requestedTags" select="/events/@requested-tags"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">agenda</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>
    <xsl:variable name="common-service-name">service-agenda</xsl:variable>
    
    <!-- +
         | HEAD
         + -->    
         
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="string(/events/@title)"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-other">    
	    <xsl:call-template name="rss-head"/>
    </xsl:template>
    
    <xsl:template name="rss-head">
    	<link rel="alternate" type="application/rss+xml" i18n:attr="title" title="plugin.web:PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_RSS_FEED_ALT" href="{$site-uri-prefix}/{$rssUrl}"/>
    </xsl:template>    
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            function createAmetysCalendar_getSiteUriPrefix(plugin)
            {
                return "<xsl:value-of select="$site-uri-prefix"/>/_plugins/" + plugin;
            }
        </script>
        
        <script src="{$uri-prefix}/plugins/calendar/resources/js/agenda.{$lang}.js" type="text/javascript"/>
        
        <script type="text/javascript">
            $j(function() 
                {
                    var events = [];
                    <xsl:apply-templates select="/events/contents/event" mode="js"/>
                    
                    var months = []; 
                    <xsl:apply-templates select="/events/calendar-months/month" mode="js"/>
    
                    var categories = [];
                    <xsl:apply-templates select="/events/tag-categories/category/tags/tag" mode="js"/>
                
                    var cfg = {
                        siteName: "<xsl:value-of select="$site"/>",
                        language: "<xsl:value-of select="$lang"/>",
                        minDate : $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="/events/@start"/>'),
                        maxDate : $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="/events/@end"/>'),
                        rangeType : "<xsl:value-of select="$rangeType"/>",
                        monthsBefore: <xsl:value-of select="/events/@months-before"/>,
                        monthsAfter: <xsl:value-of select="/events/@months-after"/>,
                        currentCategory : "<xsl:value-of select="$requestedTags"/>",
                        pdfDownload : <xsl:value-of select="$pdfDownload = 'true'"/>,
                        icalDownload : <xsl:value-of select="$icalDownload = 'true'"/>,
                        <xsl:if test="starts-with($link, 'page://')">
                            linkURL : "<xsl:value-of select="resolver:resolve('page', $link)"/>",
                            linkLabel : <xsl:choose>
                                            <xsl:when test="$linkTitle != ''">
                                                "<xsl:value-of select="escaper:escapeJavaScript($linkTitle)"/>",
                                            </xsl:when>
                                            <xsl:otherwise>
                                                "<xsl:value-of select="escaper:escapeJavaScript(ametys:pageTitle($link))"/>",
                                            </xsl:otherwise>
                                        </xsl:choose>
                        </xsl:if>
                        zoneItemId : "<xsl:value-of select="$encZoneItemId"/>",
                        events : events,
                        months : months,
                        categories : categories
                    }
                    
                    createAmetysCalendar("#calendar-<xsl:value-of select="$uniqueId"/>", cfg);
                }
            );
        </script>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    
    <xsl:template name="common-service-body-nonempty-content-title">
    	<xsl:call-template name="rss"/>
    	
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="string(/events/@title)"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">    
        <xsl:call-template name="ics-errors" />
        <xsl:call-template name="all-events-when-no-js"/>
        <xsl:call-template name="events-marker-when-js"/>
    </xsl:template>
    
    <!-- Template for the rss link -->
    <xsl:template name="rss">
        <xsl:if test="$rssUrl != ''">
            <div class="rss">
                <a href="{$site-uri-prefix}/{$rssUrl}"><i18n:text i18n:key="PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_RSS_FEED_ALT" i18n:catalogue="plugin.web"/></a>
            </div>
        </xsl:if>    
    </xsl:template> 
    
    <!-- +
         | Generating events list when js is missing
         + -->
    <xsl:template name="all-events-when-no-js">
        <noscript>
        	<xsl:if test="/events/months/month">
	            <ul class="months">
	                <xsl:for-each select="/events/months/month">
	                    <xsl:if test="/events/contents/event[starts-with(content/metadata/start-date, current()/@str)]">
	                        <li>
	                            <p class="month"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="MMMM yyyy" value="{@raw}"/></p>
	                            
	                            <xsl:if test="$pdfDownload = 'true'">
	                            	<br/>
	                                <a href="{$uri-prefix}/plugins/calendar/{$site}/{$lang}/{substring(@str, 1, 4)}/{substring(@str, 6, 7)}/01/{$encZoneItemId}/month/{$requestedTags}/agenda.pdf">
	                                    <i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_PDF"/>
	                                </a>
	                            </xsl:if>
	                            
	                            <ul class="events">
	                                <xsl:for-each select="/events/contents/event[starts-with(content/metadata/start-date, current()/@str)]">
	                                    <li>
	                                    	<xsl:variable name="categories"><xsl:call-template name="get-categories"/></xsl:variable>
	                                        <p class="category"><xsl:value-of select="exsl:node-set($categories)/category[1]"/></p>
	                                        
	                                        <xsl:copy-of select="view/content/html/body/node()"/>
	                                    </li>
	                                </xsl:for-each>
	                            </ul>
	                        </li>
	                    </xsl:if>
	                </xsl:for-each>
	            </ul>
	        </xsl:if>
            
            <xsl:if test="starts-with($link, 'page://')">
            	<div class="link">
            		<a href="{resolver:resolve('page', $link)}">
            			<xsl:choose>
                            <xsl:when test="$linkTitle != ''">
                                <xsl:value-of select="$linkTitle"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="ametys:pageTitle($link)"/>
                            </xsl:otherwise>
                        </xsl:choose>
            		</a>
            	</div>
            </xsl:if>
        </noscript>
    </xsl:template>
    
    <!-- +
         | Generating calendar marker for js 
         + -->    
    <xsl:template name="events-marker-when-js">
        <script type="text/javascript">
            document.write("&lt;div id=\"calendar-<xsl:value-of select="$uniqueId"/>\"&gt;&lt;/div&gt;");
        </script>
    </xsl:template>
    
    <!-- +
         | STORE INFORMATION IN JS 
         + -->
    <xsl:template match="event" mode="js">
        <xsl:variable name="categories"><xsl:call-template name="get-categories"/></xsl:variable>
        <xsl:variable name="category" select="exsl:node-set($categories)/category[1]"/>
        
        events.push({
            contentId: "<xsl:value-of select="content/@id"/>",
            eventId: "<xsl:value-of select="substring-after(content/@id, '//')"/>",
            title: "<xsl:value-of select="escaper:escapeJavaScript(content/metadata/title)"/>",
            start: $j.datepicker.parseDate('yy-mm-dd', "<xsl:if test="content/metadata/start-date"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyy-MM-dd" value="{content/metadata/start-date}"/></xsl:if>"),
            end: $j.datepicker.parseDate('yy-mm-dd', "<xsl:if test="content/metadata/end-date"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyy-MM-dd" value="{content/metadata/end-date}"/></xsl:if>"),
            abstract: "<xsl:value-of select="escaper:escapeJavaScript(content/metadata/abstract)"/>",
            description: "<xsl:choose>
                        <xsl:when test="@start and @end">
                            <i18n:translate>
                                <i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_EVENT_TITLE_FROM_TO"/>
                                <i18n:param><xsl:value-of select="escaper:escapeJavaScript(content/metadata/title)"/></i18n:param>
                                <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMMM yyyy" value="{content/metadata/start-date}"/></i18n:param>
                                <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMMM yyyy" value="{content/metadata/end-date}"/></i18n:param>
                            </i18n:translate>
                        </xsl:when>
                        <xsl:otherwise>
                            <i18n:translate>
                                <i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_EVENT_TITLE_SINGLE_DAY"/>
                                <i18n:param><xsl:value-of select="escaper:escapeJavaScript(content/metadata/title)"/></i18n:param>
                                <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd MMMM yyyy" value="{content/metadata/start-date}"/></i18n:param>
                            </i18n:translate>
                        </xsl:otherwise>
                    </xsl:choose>"
            <xsl:if test="$category">
                <xsl:text>,catNumber: 'category_</xsl:text><xsl:value-of select="$category/@number"/>'
                <xsl:text>,catName: 'category_</xsl:text><xsl:value-of select="$category/@name"/>'
                <xsl:text>,catLabel: "</xsl:text><xsl:value-of select="escaper:escapeJavaScript($category)"/>"
            </xsl:if>
            <xsl:if test="pages/page">
            ,path: "<xsl:value-of select="resolver:resolve('page', pages/page[1]/@id, false())"/>"
            </xsl:if>
        });
    </xsl:template>
    
    <xsl:template match="month" mode="js">
        var weeks = [];
        
        <xsl:for-each select="calendar/week">
            weeks.push({
                start: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="day[1]/@date"/>'),
                end: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="day[last()]/@date"/>'),
                previous: new Date(<xsl:value-of select="@previousYear"/>, <xsl:value-of select="@previousMonth - 1"/>, <xsl:value-of select="@previousDay"/>), 
                next: new Date(<xsl:value-of select="@nextYear"/>, <xsl:value-of select="@nextMonth - 1"/>, <xsl:value-of select="@nextDay"/>), 
                label: "<i18n:translate>
                            <i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_FROM_TO"/>
                            <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{day[1]/@raw}"/></i18n:param>
                            <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{day[last()]/@raw}"/></i18n:param>
                        </i18n:translate>",
                
                days: [<xsl:for-each select="day">
                    { date: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="@date"/>') }<xsl:if test="position() &lt; last()">,</xsl:if>
                </xsl:for-each>]
            });
        </xsl:for-each>
        
        months.push({
            start: $j.datepicker.parseDate('yy-mm-dd', '<xsl:value-of select="substring-before(@raw, 'T')"/>'),
            year: <xsl:value-of select="@year"/>,
            month: <xsl:value-of select="@month"/>,
            str: '<xsl:value-of select="concat(@year, '-', format-number(@month, '00'))"/>',
            label: "<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="MMMM yyyy" value="{@raw}"/>",
            weeks: weeks
        });
    </xsl:template>
    
    <xsl:template match="tag" mode="js">
        categories.push({
            num: <xsl:value-of select="position()"/>,
            name: "<xsl:value-of select="text:lowercase(@name)"/>",
            label: "<xsl:value-of select="escaper:escapeJavaScript(.)"/>"
        });
    </xsl:template>
    
    <xsl:template name="get-categories">
        <xsl:variable name="event-tags" select="content/tags/*"/>
        <xsl:for-each select="/events/tag-categories/category/tags/tag">
            <xsl:variable name="tagName" select="@name"/>
            <xsl:if test="exsl:node-set($event-tags)[local-name() = $tagName]">
                <category name="{text:lowercase($tagName)}" number="{position()}"><xsl:value-of select="."/></category>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="ics-errors">
        <xsl:if test="$rendering-context = 'back' and errors-ics">
           <xsl:call-template name="display-errors">
              <xsl:with-param name="titleI18nKey" select="'plugin.calendar:CALENDAR_SERVICE_AGENDA_ICS_OVERSIZED'" />
              <xsl:with-param name="status" select="'OVERSIZED'" />
           </xsl:call-template>
             	            
           <xsl:call-template name="display-errors">
              <xsl:with-param name="titleI18nKey" select="'plugin.calendar:CALENDAR_SERVICE_AGENDA_ICS_ERRORS'" />
              <xsl:with-param name="status" select="'ERROR'" />
           </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="display-errors">
        <xsl:param name="titleI18nKey" />
        <xsl:param name="status" />
        
        <xsl:if test="errors-ics/ics[@status = $status]">
            <xsl:variable name="htmlMessage">
                <ul>
                    <xsl:for-each select="errors-ics/ics[@status = $status]">
                       <li><xsl:value-of select="@url" /></li>
                    </xsl:for-each>
                </ul>
            </xsl:variable>    
            
            <xsl:call-template name="display-bo-warning-message">
                <xsl:with-param name="titleI18nKey" select="$titleI18nKey"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
